/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.applications;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.ExecutionResults;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.system.WindowsNativeUtils;
import org.netbeans.installer.utils.system.windows.WindowsRegistry;

public class JavaUtils {
    private static Map<File, JavaInfo> knownJdks = new HashMap<File, JavaInfo>();
    public static Version criticalLowVersion = Version.getVersion("1.7.0_00");
    public static Version criticalHighVersion = Version.getVersion("1.7.0_09");
    public static final String JRE_NESTED_SUBDIR = "/bin/jre/";
    public static final String JDK_KEY = "SOFTWARE\\JavaSoft\\Java Development Kit";
    public static final String JRE_KEY = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
    public static final String JAVAHOME_VALUE = "JavaHome";
    public static final String MICROVERSION_VALUE = "MicroVersion";
    public static final String CURRENT_VERSION_VALUE = "CurrentVersion";
    public static final String TEST_JDK_RESOURCE = "org/netbeans/installer/utils/applications/TestJDK.class";
    public static final String TEST_JDK_URI = "resource:org/netbeans/installer/utils/applications/TestJDK.class";
    public static final String TEST_JDK_CLASSNAME = "TestJDK";
    public static final int TEST_JDK_OUTPUT_PARAMETERS = 5;
    public static final String NON_FINAL_JVM_PATTERN = "-(ea|rc[0-9]*|beta[0-9]*|preview[0-9]*|dp[0-9]*|alpha[0-9]*|fcs)";
    public static final String ERROR_VERIFICATION_KEY = "JU.error.verification";
    public static final String ERROR_CANNOT_DELETE_KEY = "JU.error.cannot.delete";
    public static final String ERROR_CANNOT_DOWNLOAD_TESTJDK_KEY = "JU.error.cannot.download.testjdk";
    public static final String ERROR_CANNOT_CANONIZE_KEY = "JU.error.cannot.canonize";

    public static boolean isJavaHome(File javaHome) {
        if (!javaHome.exists() || !javaHome.isDirectory()) {
            return false;
        }
        File probe = JavaUtils.getExecutable(javaHome);
        if (!probe.exists() || !probe.isFile()) {
            return false;
        }
        probe = new File(javaHome, "lib");
        if (!probe.exists() || !probe.isDirectory()) {
            return false;
        }
        String extension = "";
        if (SystemUtils.isWindows()) {
            extension = ".exe";
        }
        return (probe = new File(javaHome, "bin/javac" + extension)).exists() && probe.isFile() || (probe = new File(javaHome, "bin/java" + extension)).exists() && probe.isFile();
    }

    public static boolean isJdk(File javaHome) {
        File javac;
        if (!JavaUtils.isJavaHome(javaHome)) {
            return false;
        }
        String extension = "";
        if (SystemUtils.isWindows()) {
            extension = ".exe";
        }
        return SystemUtils.isMacOS() || (javac = new File(javaHome, "bin/javac" + extension)).exists() && javac.isFile();
    }

    public static boolean isRecommended(Version version) {
        return version.olderThan(criticalLowVersion) || version.newerThan(criticalHighVersion);
    }

    public static void addJavaInfo(File location, JavaInfo info) {
        if (knownJdks.get(location) == null) {
            knownJdks.put(location, info);
        }
    }

    public static void removeJavaInfo(File location) {
        if (knownJdks.get(location) != null) {
            knownJdks.remove(location);
        }
    }

    public static Version getVersion(File javaHome) {
        JavaInfo info = JavaUtils.getInfo(javaHome);
        return info == null ? null : info.getVersion();
    }

    public static JavaInfo getInfo(File javaHome) {
        return JavaUtils.getInfo(javaHome, false);
    }

    public static JavaInfo getInfo(File javaHome, boolean ignoreKnownJdks) {
        File testJdk;
        File location = FileUtils.getNormalizedPathFile(javaHome);
        if (!ignoreKnownJdks && knownJdks.get(location) != null) {
            return knownJdks.get(location);
        }
        if (!JavaUtils.isJavaHome(location)) {
            return null;
        }
        File executable = JavaUtils.getExecutable(location);
        try {
            testJdk = FileProxy.getInstance().getFile(TEST_JDK_URI);
        }
        catch (DownloadException e) {
            ErrorManager.notifyError(ResourceUtils.getString(JavaUtils.class, ERROR_CANNOT_DOWNLOAD_TESTJDK_KEY, TEST_JDK_URI), e);
            return null;
        }
        JavaInfo jdkInfo = null;
        try {
            ExecutionResults results = SystemUtils.executeCommand(executable.getAbsolutePath(), "-classpath", testJdk.getParentFile().getAbsolutePath(), TEST_JDK_CLASSNAME);
            jdkInfo = JavaInfo.getInfo(results.getStdOut());
            if (jdkInfo != null) {
                LogManager.log("... put jdk info to the Java map");
                knownJdks.put(location, jdkInfo);
            } else {
                LogManager.log("... can`t get jdkInfo from " + location);
            }
        }
        catch (IOException e) {
            LogManager.log(ResourceUtils.getString(JavaUtils.class, ERROR_VERIFICATION_KEY), (Throwable)e);
        }
        if (!testJdk.delete()) {
            ErrorManager.notifyError(ResourceUtils.getString(JavaUtils.class, ERROR_CANNOT_DELETE_KEY, testJdk.getAbsolutePath()));
        }
        return jdkInfo;
    }

    public static File getExecutable(File javaHome) {
        if (SystemUtils.isWindows()) {
            return new File(javaHome, "bin/java.exe");
        }
        return new File(javaHome, "bin/java");
    }

    public static File getExecutableW(File javaHome) {
        if (SystemUtils.isWindows()) {
            return new File(javaHome, "bin/javaw.exe");
        }
        return new File(javaHome, "bin/java");
    }

    public static void createJdkKey(Version version, String javaHome) throws NativeException {
        if (!SystemUtils.isWindows()) {
            return;
        }
        WindowsRegistry registry = ((WindowsNativeUtils)SystemUtils.getNativeUtils()).getWindowsRegistry();
        String key = registry.constructKey(JDK_KEY, version.toJdkStyle());
        JavaUtils.setJdkData(key, version, javaHome);
        JavaUtils.updateJdkKey(registry.constructKey(JDK_KEY, version.toMinor()));
        JavaUtils.updateCurrentVersion();
    }

    public static void deleteJdkKey(Version version, String javaHome) throws NativeException {
        String currentJavaHome;
        if (!SystemUtils.isWindows()) {
            return;
        }
        WindowsRegistry registry = ((WindowsNativeUtils)SystemUtils.getNativeUtils()).getWindowsRegistry();
        String key = registry.constructKey(JDK_KEY, version.toJdkStyle());
        int section = JavaUtils.getJDKRegistrySection(registry);
        if (registry.keyExists(section, key) && registry.valueExists(section, key, JAVAHOME_VALUE) && (currentJavaHome = registry.getStringValue(section, key, JAVAHOME_VALUE)).equals(javaHome)) {
            registry.deleteKey(section, key);
            JavaUtils.updateJdkKey(registry.constructKey(JDK_KEY, version.toMinor()));
        }
        JavaUtils.updateCurrentVersion();
    }

    public static File findJDKHome(Version jdkVersion) {
        return JavaUtils.findJavaHome(JDK_KEY, jdkVersion);
    }

    public static File findJreHome(Version jdkVersion) {
        return JavaUtils.findJavaHome(JRE_KEY, jdkVersion);
    }

    private static File findJavaHome(String javaKey, Version jdkVersion) {
        File result = null;
        try {
            if (SystemUtils.isWindows()) {
                String version = jdkVersion.toJdkStyle();
                LogManager.log("... checking if JDK " + version + " is already installed");
                WindowsRegistry winreg = ((WindowsNativeUtils)SystemUtils.getNativeUtils()).getWindowsRegistry();
                if (winreg.keyExists(2, javaKey, version)) {
                    String versKey = javaKey + "\\" + version;
                    if (winreg.valueExists(2, versKey, JAVAHOME_VALUE)) {
                        String javaHome = winreg.getStringValue(2, versKey, JAVAHOME_VALUE);
                        if (JavaUtils.getInfo(new File(javaHome)) != null) {
                            result = new File(javaHome);
                        } else {
                            LogManager.log("... no Java at " + javaHome);
                        }
                    } else {
                        LogManager.log("... cannot find JavaHome value for this Java");
                    }
                } else {
                    LogManager.log("... cannot find key for this Java");
                }
            }
        }
        catch (NativeException e) {
            LogManager.log(e);
        }
        return result;
    }

    private static int getJDKRegistrySection(WindowsRegistry registry) throws NativeException {
        return registry.canModifyKey(2, JDK_KEY) ? 2 : 1;
    }

    private static void setJdkData(String key, Version version, String javaHome) throws NativeException {
        WindowsRegistry registry = ((WindowsNativeUtils)SystemUtils.getNativeUtils()).getWindowsRegistry();
        int section = JavaUtils.getJDKRegistrySection(registry);
        registry.createKey(section, key);
        registry.setStringValue(section, key, JAVAHOME_VALUE, javaHome);
        registry.setStringValue(section, key, MICROVERSION_VALUE, version.getMicro());
    }

    private static void updateJdkKey(String key) throws NativeException {
        WindowsRegistry registry = ((WindowsNativeUtils)SystemUtils.getNativeUtils()).getWindowsRegistry();
        int section = JavaUtils.getJDKRegistrySection(registry);
        registry.createKey(section, key);
        String javaHome = null;
        Version version = null;
        for (String subkey : registry.getSubKeys(section, JDK_KEY)) {
            String tempJavaHome;
            Version tempVersion;
            if (!subkey.startsWith(key) || subkey.equals(key) || !registry.valueExists(section, subkey, JAVAHOME_VALUE) || (tempVersion = JavaUtils.getVersion(new File(tempJavaHome = registry.getStringValue(section, subkey, JAVAHOME_VALUE)))) == null || version != null && !version.olderThan(tempVersion)) continue;
            javaHome = tempJavaHome;
            version = tempVersion;
        }
        if (version != null && javaHome != null) {
            JavaUtils.setJdkData(key, version, javaHome);
        } else {
            registry.deleteKey(section, key);
        }
    }

    private static void updateCurrentVersion() throws NativeException {
        WindowsRegistry registry = ((WindowsNativeUtils)SystemUtils.getNativeUtils()).getWindowsRegistry();
        int section = JavaUtils.getJDKRegistrySection(registry);
        registry.createKey(section, JDK_KEY);
        String name = null;
        Version version = null;
        for (String key : registry.getSubKeys(section, JDK_KEY)) {
            if (!registry.valueExists(section, key, JAVAHOME_VALUE)) continue;
            String tempName = registry.getKeyName(key);
            String tempJavaHome = registry.getStringValue(section, key, JAVAHOME_VALUE);
            Version tempVersion = JavaUtils.getVersion(new File(tempJavaHome));
            if (tempVersion == null || version != null && !version.olderThan(tempVersion)) continue;
            name = tempName;
            version = tempVersion;
        }
        if (name != null && version != null) {
            registry.setStringValue(section, JDK_KEY, CURRENT_VERSION_VALUE, name);
        } else {
            registry.deleteKey(section, JDK_KEY);
        }
    }

    private JavaUtils() {
    }

    public static class JavaInfo {
        private Version version;
        private String vendor;
        private boolean nonFinal;
        private String arch;

        public static JavaInfo getInfo(String string) {
            String[] lines = StringUtils.splitByLines(string);
            Version version = null;
            boolean nonFinal = false;
            if (lines.length == 6) {
                String javaVersion = lines[0];
                String javaVmVersion = lines[1];
                String vendor = lines[2];
                String osName = lines[3];
                String osArch = lines[4];
                LogManager.log("... java.version    = " + javaVersion);
                LogManager.log("... java.vm.version = " + javaVmVersion);
                LogManager.log("... java.vendor     = " + vendor);
                LogManager.log("... os.name         = " + osName);
                LogManager.log("... os.arch         = " + osArch);
                String versionString = javaVmVersion.contains(javaVersion) ? javaVmVersion.substring(javaVmVersion.indexOf(javaVersion)) : javaVersion;
                Matcher nonFinalMatcher = Pattern.compile(JavaUtils.NON_FINAL_JVM_PATTERN).matcher(versionString);
                if (nonFinalMatcher.find()) {
                    versionString = versionString.replaceAll(JavaUtils.NON_FINAL_JVM_PATTERN, "");
                    nonFinal = true;
                }
                if (versionString.matches("[0-9]+\\.[0-9]+\\.[0-9]+-b[0-9]+")) {
                    versionString = versionString.replace("-b", ".0.");
                }
                if (versionString.matches("[0-9]+\\.[0-9]+\\.[0-9]+_[0-9]+-b[0-9]+")) {
                    versionString = versionString.replace("-b", ".");
                }
                if (vendor.contains("BEA")) {
                    versionString = versionString.replaceAll("([0-9]+\\.[0-9]+\\.[0-9])+-([0-9]+)", "$1.0.$2");
                }
                LogManager.log("... version string : " + versionString);
                Matcher matcher = Pattern.compile("[0-9][0-9_\\.\\-]+[0-9]").matcher(versionString);
                if (matcher.find()) {
                    version = Version.getVersion(matcher.group());
                }
                if (version != null) {
                    return new JavaInfo(version, vendor, osArch, nonFinal);
                }
            } else {
                LogManager.log("... different lines number [" + lines.length + "]");
                for (int j = 0; j < lines.length; ++j) {
                    LogManager.log("... line [" + j + "] = [" + lines[j] + "]");
                }
            }
            return null;
        }

        public JavaInfo(Version version, String vendor) {
            this.arch = version.toString().endsWith("64") ? "x64" : "";
            this.version = version;
            this.vendor = vendor;
            this.nonFinal = false;
        }

        public JavaInfo(Version version, String vendor, boolean nonFinal) {
            this(version, vendor);
            this.nonFinal = nonFinal;
        }

        public JavaInfo(Version version, String vendor, String arch, boolean nonFinal) {
            this(version, vendor);
            this.arch = arch;
            this.nonFinal = nonFinal;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getVendor() {
            return this.vendor;
        }

        public boolean isNonFinal() {
            return this.nonFinal;
        }

        public String getArch() {
            this.arch = this.arch.contains("64") ? "x64" : this.arch;
            return this.arch;
        }
    }
}

