/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.nbjavac.parsing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.parser.LazyDocCommentTable;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.nbjavac.parsing.FindAnonymousVisitor;
import org.netbeans.modules.java.source.nbjavac.parsing.PartialReparserService;
import org.netbeans.modules.java.source.nbjavac.parsing.TranslatePositionsVisitor;
import org.netbeans.modules.java.source.nbjavac.parsing.TreeLoader;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.JavacFlowListener;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class PartialReparserImpl
implements JavacParser.PartialReparser {
    private static final Logger LOGGER = Logger.getLogger(PartialReparserImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reparseMethod(CompilationInfoImpl ci, Snapshot snapshot, MethodTree orig, String newBody) throws IOException {
        JavaSource.Phase currentPhase;
        assert (ci != null);
        FileObject fo = ci.getFileObject();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Reparse method in: {0}", fo);
        }
        if (JavaSource.Phase.PARSED.compareTo((Enum)(currentPhase = ci.getPhase())) > 0) {
            return false;
        }
        try {
            CompilationUnitTree cu = ci.getCompilationUnit();
            if (cu == null) return false;
            if (newBody == null) {
                return false;
            }
            JavacTaskImpl task = ci.getJavacTask();
            if (Options.instance(task.getContext()).isSet("lombokDetected")) {
                return false;
            }
            PartialReparserService pr = PartialReparserService.instance(task.getContext());
            if (((JCTree.JCMethodDecl)orig).localEnv == null) {
                return false;
            }
            JavacTrees jt = JavacTrees.instance(task);
            int origStartPos = (int)jt.getSourcePositions().getStartPosition(cu, orig.getBody());
            int origEndPos = (int)jt.getSourcePositions().getEndPosition(cu, orig.getBody());
            if (origStartPos < 0) {
                LOGGER.log(Level.WARNING, "Javac returned startpos: {0} < 0", new Object[]{origStartPos});
                return false;
            }
            if (origStartPos > origEndPos) {
                LOGGER.log(Level.WARNING, "Javac returned startpos: {0} > endpos: {1}", new Object[]{origStartPos, origEndPos});
                return false;
            }
            FindAnonymousVisitor fav = new FindAnonymousVisitor();
            fav.scan(orig.getBody(), null);
            if (fav.hasLocalClass) {
                if (!LOGGER.isLoggable(Level.FINER)) return false;
                LOGGER.log(Level.FINER, "Skeep reparse method (old local classes): {0}", fo);
                return false;
            }
            int firstInner = fav.firstInner;
            int noInner = fav.noInner;
            Context ctx = task.getContext();
            TreeLoader treeLoader = TreeLoader.instance(ctx);
            if (treeLoader != null) {
                treeLoader.startPartialReparse();
            }
            try {
                Log l = Log.instance(ctx);
                l.startPartialReparse();
                JavaFileObject prevLogged = l.useSource(cu.getSourceFile());
                try {
                    DiagnosticListener dl = ci.getDiagnosticListener();
                    assert (dl instanceof CompilationInfoImpl.DiagnosticListenerImpl);
                    ((CompilationInfoImpl.DiagnosticListenerImpl)dl).startPartialReparse(origStartPos, origEndPos);
                    long start = System.currentTimeMillis();
                    HashMap docComments = new HashMap();
                    JCTree.JCBlock block = pr.reparseMethodBody(cu, orig, newBody + " ", firstInner, docComments);
                    LOGGER.log(Level.FINER, "Reparsed method in: {0}", fo);
                    if (block == null) {
                        LOGGER.log(Level.FINER, "Skeep reparse method, invalid position, newBody: ", newBody);
                        boolean bl = false;
                        return bl;
                    }
                    int newEndPos = (int)jt.getSourcePositions().getEndPosition(cu, block);
                    if (newEndPos != origStartPos + newBody.length()) {
                        boolean bl = false;
                        return bl;
                    }
                    fav.reset();
                    fav.scan(block, null);
                    int newNoInner = fav.noInner;
                    if (fav.hasLocalClass || noInner != newNoInner) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.log(Level.FINER, "Skeep reparse method (new local classes): {0}", fo);
                        }
                        boolean bl = false;
                        return bl;
                    }
                    ((LazyDocCommentTable)((JCTree.JCCompilationUnit)cu).docComments).table.keySet().removeAll(fav.docOwners);
                    ((LazyDocCommentTable)((JCTree.JCCompilationUnit)cu).docComments).table.putAll(docComments);
                    long end = System.currentTimeMillis();
                    if (fo != null) {
                        JavacParser.logTime((FileObject)fo, (JavaSource.Phase)JavaSource.Phase.PARSED, (long)(end - start));
                    }
                    int delta = newEndPos - origEndPos;
                    EndPosTable endPos = ((JCTree.JCCompilationUnit)cu).endPositions;
                    TranslatePositionsVisitor tpv = new TranslatePositionsVisitor(orig, endPos, delta);
                    tpv.scan((Tree)cu, null);
                    ((JCTree.JCMethodDecl)orig).body = block;
                    if (JavaSource.Phase.RESOLVED.compareTo((Enum)currentPhase) <= 0) {
                        JavacFlowListener fl;
                        start = System.currentTimeMillis();
                        pr.reattrMethodBody(orig, block);
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.log(Level.FINER, "Resolved method in: {0}", fo);
                        }
                        if (!((CompilationInfoImpl.DiagnosticListenerImpl)dl).hasPartialReparseErrors() && (fl = JavacFlowListener.instance((Context)ctx)) != null && fl.hasFlowCompleted(fo)) {
                            List diag;
                            if (LOGGER.isLoggable(Level.FINER) && !(diag = ci.getDiagnostics()).isEmpty()) {
                                LOGGER.log(Level.FINER, "Reflow with errors: {0} {1}", new Object[]{fo, diag});
                            }
                            TreePath tp = TreePath.getPath(cu, (Tree)orig);
                            Tree t = tp.getParentPath().getLeaf();
                            pr.reflowMethodBody(cu, (ClassTree)t, orig);
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.log(Level.FINER, "Reflowed method in: {0}", fo);
                            }
                        }
                        end = System.currentTimeMillis();
                        if (fo != null) {
                            JavacParser.logTime((FileObject)fo, (JavaSource.Phase)JavaSource.Phase.ELEMENTS_RESOLVED, (long)0L);
                            JavacParser.logTime((FileObject)fo, (JavaSource.Phase)JavaSource.Phase.RESOLVED, (long)(end - start));
                        }
                    }
                    long startM = System.currentTimeMillis();
                    char[] chars = snapshot.getText().toString().toCharArray();
                    ((Position.LineMapImpl)cu.getLineMap()).build(chars, chars.length);
                    LOGGER.log(Level.FINER, "Rebuilding LineMap took: {0}", System.currentTimeMillis() - startM);
                    ((CompilationInfoImpl.DiagnosticListenerImpl)dl).endPartialReparse(delta);
                }
                finally {
                    l.endPartialReparse();
                    l.useSource(prevLogged);
                }
                ci.update(snapshot);
                return true;
            }
            finally {
                if (treeLoader != null) {
                    treeLoader.endPartialReparse();
                }
            }
        }
        catch (CouplingAbort ca) {
            return false;
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            boolean a = false;
            if (!$assertionsDisabled) {
                a = true;
            }
            if (!a) return false;
            JavacParser.dumpSource((CompilationInfoImpl)ci, (Throwable)t);
            return false;
        }
    }
}

