/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.features.HighlighterSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class TokensBrowserTopComponent
extends TopComponent {
    private static final String PREFERRED_ID = "TokensBrowserTopComponent";
    private static final long serialVersionUID = 1L;
    private static TokensBrowserTopComponent instance;
    private JTree tree;
    private Listener listener;
    private HighlighterSupport highlighting = new HighlighterSupport(Color.yellow);
    private boolean listen = true;
    private CaretListener caretListener;
    private JEditorPane lastPane;
    private DocumentListener documentListener;
    private AbstractDocument lastDocument;
    private RequestProcessor.Task task;

    private TokensBrowserTopComponent() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.tree = new JTree();
        this.tree.setCellRenderer(new Renderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!TokensBrowserTopComponent.this.listen) {
                    return;
                }
                TokensBrowserTopComponent.this.mark();
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TokensBrowserTopComponent.this.mark();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TokensBrowserTopComponent.this.mark();
            }
        });
        this.tree.setRootVisible(false);
        this.add(new JScrollPane(this.tree), "Center");
        this.setName(NbBundle.getMessage(TokensBrowserTopComponent.class, (String)"CTL_TokensBrowserTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TokensBrowserTopComponent.class, (String)"HINT_TokensBrowserTopComponent"));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized TokensBrowserTopComponent getDefault() {
        if (instance == null) {
            instance = new TokensBrowserTopComponent();
        }
        return instance;
    }

    public static synchronized TokensBrowserTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find TokensBrowser component. It will not be located properly in the window system.");
            return TokensBrowserTopComponent.getDefault();
        }
        if (win instanceof TokensBrowserTopComponent) {
            return (TokensBrowserTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'TokensBrowserTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return TokensBrowserTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected void componentShowing() {
        this.refresh();
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
    }

    protected void componentHidden() {
        if (this.listener != null) {
            this.listener.remove();
            this.listener = null;
        }
        if (this.lastPane != null) {
            this.lastPane.removeCaretListener(this.caretListener);
        }
        this.lastPane = null;
        if (this.lastDocument != null) {
            this.lastDocument.removeDocumentListener(this.documentListener);
        }
        this.lastDocument = null;
        this.highlighting.removeHighlight();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void mark() {
        EditorCookie editorCookie;
        Node[] ns = TopComponent.getRegistry().getActivatedNodes();
        if (ns.length == 1 && this.tree.isFocusOwner() && (editorCookie = (EditorCookie)ns[0].getLookup().lookup(EditorCookie.class)) != null) {
            THNode t = (THNode)this.tree.getLastSelectedPathComponent();
            if (t == null) {
                return;
            }
            Token token = t.getToken();
            if (token == null) {
                return;
            }
            if (t != null) {
                this.highlighting.highlight(editorCookie.getDocument(), t.getOffset(), t.getOffset() + token.length());
                return;
            }
        }
        this.highlighting.removeHighlight();
    }

    private JEditorPane getCurrentEditor() {
        Node[] ns = TopComponent.getRegistry().getActivatedNodes();
        if (ns.length != 1) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)ns[0].getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes() == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes().length < 1) {
            return null;
        }
        return editorCookie.getOpenedPanes()[0];
    }

    private AbstractDocument getCurrentDocument() {
        Node[] ns = TopComponent.getRegistry().getActivatedNodes();
        if (ns.length != 1) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)ns[0].getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes() == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes().length < 1) {
            return null;
        }
        JEditorPane pane = editorCookie.getOpenedPanes()[0];
        if (this.caretListener == null) {
            this.caretListener = new CListener();
        }
        if (this.lastPane != null && this.lastPane != pane) {
            this.lastPane.removeCaretListener(this.caretListener);
            this.lastPane = null;
        }
        if (this.lastPane == null) {
            pane.addCaretListener(this.caretListener);
            this.lastPane = pane;
        }
        AbstractDocument doc = (AbstractDocument)((Object)editorCookie.getDocument());
        if (this.documentListener == null) {
            this.documentListener = new CDocumentListener();
        }
        if (this.lastDocument != null && this.lastDocument != doc) {
            this.lastDocument.removeDocumentListener(this.documentListener);
            this.lastDocument = null;
        }
        if (this.lastDocument == null) {
            doc.addDocumentListener(this.documentListener);
            this.lastDocument = doc;
        }
        return doc;
    }

    private void refreshLater() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                TokensBrowserTopComponent.this.refresh();
                TokensBrowserTopComponent.this.task = null;
            }
        }, 1000);
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractDocument doc = TokensBrowserTopComponent.this.getCurrentDocument();
                TokenSequence ts = null;
                if (doc != null) {
                    try {
                        doc.readLock();
                        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                        if (tokenHierarchy == null) {
                            return;
                        }
                        ts = tokenHierarchy.tokenSequence();
                    }
                    finally {
                        doc.readUnlock();
                    }
                }
                if (ts == null) {
                    TokensBrowserTopComponent.this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
                } else {
                    TokensBrowserTopComponent.this.tree.setModel(new DefaultTreeModel(new TSNode(null, ts, null, 0, 0)));
                }
                JEditorPane editor = TokensBrowserTopComponent.this.getCurrentEditor();
                if (editor != null) {
                    int position = TokensBrowserTopComponent.this.getCurrentEditor().getCaret().getDot();
                    TokensBrowserTopComponent.this.selectPath(position);
                }
            }
        });
    }

    private void selectPath(int offset) {
        Object root = this.tree.getModel().getRoot();
        if (!(root instanceof TSNode)) {
            return;
        }
        this.listen = false;
        TSNode n = (TSNode)root;
        TreePath path = new TreePath(n);
        path = this.findPath(path, offset);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
        this.listen = true;
    }

    private TreePath findPath(TreePath path, int offset) {
        THNode parent = (THNode)path.getLastPathComponent();
        Enumeration<? extends TreeNode> en = parent.children();
        while (en.hasMoreElements()) {
            THNode n = (THNode)en.nextElement();
            if (n.getOffset() + n.getToken().length() <= offset) continue;
            if (offset < n.getOffset()) {
                return path;
            }
            if (n.isLeaf()) {
                return new MPath(path, n);
            }
            return this.findPath(new MPath(path, n), offset);
        }
        return path;
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference component;

        Listener(TokensBrowserTopComponent c) {
            this.component = new WeakReference<TokensBrowserTopComponent>(c);
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        }

        TokensBrowserTopComponent getComponent() {
            TokensBrowserTopComponent c = (TokensBrowserTopComponent)((Object)this.component.get());
            if (c != null) {
                return c;
            }
            this.remove();
            return null;
        }

        void remove() {
            TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TokensBrowserTopComponent c = this.getComponent();
            if (c == null) {
                return;
            }
            c.refresh();
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return TokensBrowserTopComponent.getDefault();
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        private Renderer() {
        }

        private String e(CharSequence t) {
            if (t == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            int k = t.length();
            for (int i = 0; i < k; ++i) {
                if (t.charAt(i) == '\t') {
                    sb.append("\\t");
                    continue;
                }
                if (t.charAt(i) == '\r') {
                    sb.append("\\r");
                    continue;
                }
                if (t.charAt(i) == '\n') {
                    sb.append("\\n");
                    continue;
                }
                sb.append(t.charAt(i));
            }
            return sb.toString();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value instanceof THNode)) {
                return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            }
            THNode node = (THNode)value;
            Token token = node.getToken();
            if (token == null) {
                return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            }
            StringBuilder sb = new StringBuilder().append('<').append(node.getOffset()).append(",\"").append(token.id().name()).append(",\"").append(this.e(token.text())).append("\">");
            return super.getTreeCellRendererComponent(tree, sb.toString(), sel, expanded, leaf, row, hasFocus);
        }
    }

    class CListener
    implements CaretListener {
        CListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            int position = e.getDot();
            try {
                TokensBrowserTopComponent.this.selectPath(position);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    class CDocumentListener
    implements DocumentListener {
        CDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TokensBrowserTopComponent.this.refreshLater();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TokensBrowserTopComponent.this.refreshLater();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TokensBrowserTopComponent.this.refreshLater();
        }
    }

    static class TNode
    implements THNode {
        private TSNode parent;
        private Token token;
        private String mimeType;
        private int index;
        private int offset;

        TNode(TSNode parent, Token token, String mimeType, int index, int offset) {
            this.parent = parent;
            this.token = token;
            this.mimeType = mimeType;
            this.index = index;
            this.offset = offset;
        }

        @Override
        public TreeNode getChildAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getChildCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static class TSNode
    implements THNode {
        private TSNode parent;
        private TokenSequence ts;
        private Token token;
        private int offset;
        private int index;

        TSNode(TSNode parent, TokenSequence ts, Token token, int offset, int index) {
            this.parent = parent;
            this.ts = ts;
            this.token = token;
            this.offset = offset;
            this.index = index;
        }

        @Override
        public TreeNode getChildAt(int index) {
            this.ts.moveIndex(index);
            this.ts.moveNext();
            TokenSequence ts2 = this.ts.embedded();
            if (ts2 != null) {
                return new TSNode(this, ts2, this.ts.token(), this.ts.offset(), this.ts.index());
            }
            return new TNode(this, this.ts.token(), this.getMimeType(), index, this.ts.offset());
        }

        @Override
        public int getChildCount() {
            return this.ts.tokenCount();
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public String getMimeType() {
            return this.ts.language().mimeType();
        }

        @Override
        public int getIndex(TreeNode node) {
            return ((THNode)node).getIndex();
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Enumeration children() {
            return new Enumeration(){
                private int i = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.i < TSNode.this.getChildCount();
                }

                public Object nextElement() {
                    return TSNode.this.getChildAt(this.i++);
                }
            };
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static class MPath
    extends TreePath {
        MPath(TreePath path, Object e) {
            super(path, e);
        }
    }

    static interface THNode
    extends TreeNode {
        public Token getToken();

        public String getMimeType();

        public int getOffset();

        public int getIndex();
    }
}

