/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public class StompHeaderAccessor
extends SimpMessageHeaderAccessor {
    private static final AtomicLong messageIdCounter = new AtomicLong();
    public static final String STOMP_ID_HEADER = "id";
    public static final String STOMP_HOST_HEADER = "host";
    public static final String STOMP_ACCEPT_VERSION_HEADER = "accept-version";
    public static final String STOMP_MESSAGE_ID_HEADER = "message-id";
    public static final String STOMP_RECEIPT_HEADER = "receipt";
    public static final String STOMP_RECEIPT_ID_HEADER = "receipt-id";
    public static final String STOMP_SUBSCRIPTION_HEADER = "subscription";
    public static final String STOMP_VERSION_HEADER = "version";
    public static final String STOMP_MESSAGE_HEADER = "message";
    public static final String STOMP_ACK_HEADER = "ack";
    public static final String STOMP_NACK_HEADER = "nack";
    public static final String STOMP_LOGIN_HEADER = "login";
    public static final String STOMP_PASSCODE_HEADER = "passcode";
    public static final String STOMP_DESTINATION_HEADER = "destination";
    public static final String STOMP_CONTENT_TYPE_HEADER = "content-type";
    public static final String STOMP_CONTENT_LENGTH_HEADER = "content-length";
    public static final String STOMP_HEARTBEAT_HEADER = "heart-beat";
    private static final long[] DEFAULT_HEARTBEAT = new long[]{0L, 0L};
    private static final String COMMAND_HEADER = "stompCommand";
    private static final String CREDENTIALS_HEADER = "stompCredentials";

    private StompHeaderAccessor(StompCommand command, Map<String, List<String>> externalSourceHeaders) {
        super(command.getMessageType(), externalSourceHeaders);
        Assert.notNull((Object)((Object)command), (String)"Command must not be null");
        this.setHeader(COMMAND_HEADER, (Object)command);
        if (externalSourceHeaders != null) {
            this.setSimpMessageHeaders(command, externalSourceHeaders);
        }
    }

    private void setSimpMessageHeaders(StompCommand command, Map<String, List<String>> extHeaders) {
        List<String> values = extHeaders.get(STOMP_DESTINATION_HEADER);
        if (!CollectionUtils.isEmpty(values)) {
            super.setDestination(values.get(0));
        }
        if (!CollectionUtils.isEmpty(values = extHeaders.get(STOMP_CONTENT_TYPE_HEADER))) {
            super.setContentType(MimeTypeUtils.parseMimeType((String)values.get(0)));
        }
        if (StompCommand.SUBSCRIBE.equals((Object)command) || StompCommand.UNSUBSCRIBE.equals((Object)command)) {
            values = extHeaders.get(STOMP_ID_HEADER);
            if (!CollectionUtils.isEmpty(values)) {
                super.setSubscriptionId(values.get(0));
            }
        } else if (StompCommand.MESSAGE.equals((Object)command)) {
            values = extHeaders.get(STOMP_SUBSCRIPTION_HEADER);
            if (!CollectionUtils.isEmpty(values)) {
                super.setSubscriptionId(values.get(0));
            }
        } else if (StompCommand.CONNECT.equals((Object)command) && !StringUtils.isEmpty((Object)this.getPasscode())) {
            this.setHeader(CREDENTIALS_HEADER, new StompPasscode(this.getPasscode()));
            this.setPasscode("PROTECTED");
        }
    }

    private StompHeaderAccessor(Message<?> message) {
        super(message);
    }

    public static StompHeaderAccessor create(StompCommand command) {
        return new StompHeaderAccessor(command, null);
    }

    public static StompHeaderAccessor create(StompCommand command, Map<String, List<String>> headers) {
        return new StompHeaderAccessor(command, headers);
    }

    public static StompHeaderAccessor wrap(Message<?> message) {
        return new StompHeaderAccessor(message);
    }

    @Override
    public Map<String, List<String>> toNativeHeaderMap() {
        MimeType contentType;
        Map<String, List<String>> result = super.toNativeHeaderMap();
        String destination = super.getDestination();
        if (destination != null) {
            result.put(STOMP_DESTINATION_HEADER, Arrays.asList(destination));
        }
        if ((contentType = super.getContentType()) != null) {
            result.put(STOMP_CONTENT_TYPE_HEADER, Arrays.asList(contentType.toString()));
        }
        if (this.getCommand() != null && this.getCommand().requiresSubscriptionId()) {
            String subscriptionId = this.getSubscriptionId();
            if (subscriptionId != null) {
                String name = StompCommand.MESSAGE.equals((Object)this.getCommand()) ? STOMP_SUBSCRIPTION_HEADER : STOMP_ID_HEADER;
                result.put(name, Arrays.asList(subscriptionId));
            } else {
                this.logger.warn((Object)((Object)((Object)this.getCommand()) + " frame does not have a subscription identifier" + this.toString()));
            }
        }
        if (StompCommand.MESSAGE.equals((Object)this.getCommand()) && this.getMessageId() == null) {
            String messageId = this.getSessionId() + "-" + messageIdCounter.getAndIncrement();
            result.put(STOMP_MESSAGE_ID_HEADER, Arrays.asList(messageId));
        }
        return result;
    }

    public Map<String, List<String>> toStompHeaderMap() {
        StompPasscode credentials;
        if (StompCommand.CONNECT.equals((Object)this.getCommand()) && (credentials = (StompPasscode)this.getHeader(CREDENTIALS_HEADER)) != null) {
            Map<String, List<String>> headers = this.toNativeHeaderMap();
            headers.put(STOMP_PASSCODE_HEADER, Arrays.asList(credentials.passcode));
            return headers;
        }
        return this.toNativeHeaderMap();
    }

    public StompCommand updateStompCommandAsClientMessage() {
        Assert.state((boolean)SimpMessageType.MESSAGE.equals((Object)this.getMessageType()), (String)("Unexpected message type " + this.getMessage()));
        if (this.getCommand() == null) {
            this.setHeader(COMMAND_HEADER, (Object)StompCommand.SEND);
        } else if (!this.getCommand().equals((Object)StompCommand.SEND)) {
            throw new IllegalStateException("Unexpected STOMP command " + (Object)((Object)this.getCommand()));
        }
        return this.getCommand();
    }

    public void updateStompCommandAsServerMessage() {
        Assert.state((boolean)SimpMessageType.MESSAGE.equals((Object)this.getMessageType()), (String)("Unexpected message type " + this.getMessage()));
        if (this.getCommand() == null || this.getCommand().equals((Object)StompCommand.SEND)) {
            this.setHeader(COMMAND_HEADER, (Object)StompCommand.MESSAGE);
        } else if (!this.getCommand().equals((Object)StompCommand.MESSAGE)) {
            throw new IllegalStateException("Unexpected STOMP command " + (Object)((Object)this.getCommand()));
        }
    }

    public StompCommand getCommand() {
        return (StompCommand)((Object)this.getHeader(COMMAND_HEADER));
    }

    public Set<String> getAcceptVersion() {
        String rawValue = this.getFirstNativeHeader(STOMP_ACCEPT_VERSION_HEADER);
        return rawValue != null ? StringUtils.commaDelimitedListToSet((String)rawValue) : Collections.emptySet();
    }

    public void setAcceptVersion(String acceptVersion) {
        this.setNativeHeader(STOMP_ACCEPT_VERSION_HEADER, acceptVersion);
    }

    public void setHost(String host) {
        this.setNativeHeader(STOMP_HOST_HEADER, host);
    }

    public String getHost() {
        return this.getFirstNativeHeader(STOMP_HOST_HEADER);
    }

    @Override
    public void setDestination(String destination) {
        super.setDestination(destination);
        this.setNativeHeader(STOMP_DESTINATION_HEADER, destination);
    }

    public long[] getHeartbeat() {
        String rawValue = this.getFirstNativeHeader(STOMP_HEARTBEAT_HEADER);
        if (!StringUtils.hasText((String)rawValue)) {
            return Arrays.copyOf(DEFAULT_HEARTBEAT, 2);
        }
        String[] rawValues = StringUtils.commaDelimitedListToStringArray((String)rawValue);
        return new long[]{Long.valueOf(rawValues[0]), Long.valueOf(rawValues[1])};
    }

    @Override
    public void setContentType(MimeType contentType) {
        super.setContentType(contentType);
        this.setNativeHeader(STOMP_CONTENT_TYPE_HEADER, contentType.toString());
    }

    public Integer getContentLength() {
        String contentLength = this.getFirstNativeHeader(STOMP_CONTENT_LENGTH_HEADER);
        return StringUtils.hasText((String)contentLength) ? new Integer(contentLength) : null;
    }

    public void setContentLength(int contentLength) {
        this.setNativeHeader(STOMP_CONTENT_LENGTH_HEADER, String.valueOf(contentLength));
    }

    public void setHeartbeat(long cx, long cy) {
        this.setNativeHeader(STOMP_HEARTBEAT_HEADER, StringUtils.arrayToCommaDelimitedString((Object[])new Object[]{cx, cy}));
    }

    public void setAck(String ack) {
        this.setNativeHeader(STOMP_ACK_HEADER, ack);
    }

    public String getAck() {
        return this.getFirstNativeHeader(STOMP_ACK_HEADER);
    }

    public void setNack(String nack) {
        this.setNativeHeader(STOMP_NACK_HEADER, nack);
    }

    public String getNack() {
        return this.getFirstNativeHeader(STOMP_NACK_HEADER);
    }

    public void setLogin(String login) {
        this.setNativeHeader(STOMP_LOGIN_HEADER, login);
    }

    public String getLogin() {
        return this.getFirstNativeHeader(STOMP_LOGIN_HEADER);
    }

    public void setPasscode(String passcode) {
        this.setNativeHeader(STOMP_PASSCODE_HEADER, passcode);
    }

    public String getPasscode() {
        return this.getFirstNativeHeader(STOMP_PASSCODE_HEADER);
    }

    public void setReceiptId(String receiptId) {
        this.setNativeHeader(STOMP_RECEIPT_ID_HEADER, receiptId);
    }

    public String getReceiptId() {
        return this.getFirstNativeHeader(STOMP_RECEIPT_ID_HEADER);
    }

    public void setReceipt(String receiptId) {
        this.setNativeHeader(STOMP_RECEIPT_HEADER, receiptId);
    }

    public String getReceipt() {
        return this.getFirstNativeHeader(STOMP_RECEIPT_HEADER);
    }

    public String getMessage() {
        return this.getFirstNativeHeader(STOMP_MESSAGE_HEADER);
    }

    public void setMessage(String content) {
        this.setNativeHeader(STOMP_MESSAGE_HEADER, content);
    }

    public String getMessageId() {
        return this.getFirstNativeHeader(STOMP_MESSAGE_ID_HEADER);
    }

    public void setMessageId(String id) {
        this.setNativeHeader(STOMP_MESSAGE_ID_HEADER, id);
    }

    public String getVersion() {
        return this.getFirstNativeHeader(STOMP_VERSION_HEADER);
    }

    public void setVersion(String version) {
        this.setNativeHeader(STOMP_VERSION_HEADER, version);
    }

    private static class StompPasscode {
        private final String passcode;

        public StompPasscode(String passcode) {
            this.passcode = passcode;
        }

        public String toString() {
            return "[PROTECTED]";
        }
    }
}

