/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.URLHandlersBundleStreamHandler;
import org.apache.felix.framework.URLHandlersContentHandlerProxy;
import org.apache.felix.framework.URLHandlersStreamHandlerProxy;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.osgi.service.url.URLStreamHandlerService;

class URLHandlers
implements URLStreamHandlerFactory,
ContentHandlerFactory {
    private static final Class[] CLASS_TYPE = new Class[]{Class.class};
    private static final Class URLHANDLERS_CLASS = URLHandlers.class;
    private static final SecureAction m_secureAction = new SecureAction();
    private static volatile SecurityManagerEx m_sm = null;
    private static volatile URLHandlers m_handler = null;
    private static Map m_classloaderToFrameworkLists = new HashMap();
    private static final List m_frameworks = new ArrayList();
    private static int m_counter = 0;
    private static Map m_contentHandlerCache = null;
    private static Map m_streamHandlerCache = null;
    private static URLStreamHandlerFactory m_streamHandlerFactory;
    private static ContentHandlerFactory m_contentHandlerFactory;
    private static final String STREAM_HANDLER_PACKAGE_PROP = "java.protocol.handler.pkgs";
    private static final String DEFAULT_STREAM_HANDLER_PACKAGE = "sun.net.www.protocol|com.ibm.oti.net.www.protocol|gnu.java.net.protocol|wonka.net|com.acunia.wonka.net|org.apache.harmony.luni.internal.net.www.protocol|weblogic.utils|weblogic.net|javax.net.ssl|COM.newmonics.www.protocols";
    private static Object m_rootURLHandlers;
    private static final String m_streamPkgs;
    private static final Map m_builtIn;
    private static final boolean m_loaded;
    private static final Map m_handlerToURL;

    private void init(String protocol, URLStreamHandlerFactory factory) {
        try {
            URLStreamHandler handler = this.getBuiltInStreamHandler(protocol, factory);
            if (handler != null) {
                URL url = new URL(protocol, null, -1, "", handler);
                m_handlerToURL.put(handler, url);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLHandlers() {
        m_sm = new SecurityManagerEx();
        Class<URL> clazz = URL.class;
        synchronized (URL.class) {
            URLStreamHandlerFactory currentFactory = null;
            try {
                currentFactory = (URLStreamHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(URL.class, URLStreamHandlerFactory.class, URLHANDLERS_CLASS, "streamHandlerLock");
            }
            catch (Throwable ex) {
                // empty catch block
            }
            this.init("file", currentFactory);
            this.init("ftp", currentFactory);
            this.init("http", currentFactory);
            this.init("https", currentFactory);
            try {
                this.getBuiltInStreamHandler("jar", currentFactory);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (currentFactory != null) {
                try {
                    URL.setURLStreamHandlerFactory(currentFactory);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            try {
                URL.setURLStreamHandlerFactory(this);
                m_streamHandlerFactory = this;
                m_rootURLHandlers = this;
                try {
                    m_secureAction.flush(URL.class, URL.class);
                }
                catch (Throwable t) {}
            }
            catch (Error err) {
                try {
                    m_streamHandlerFactory = (URLStreamHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(URL.class, URLStreamHandlerFactory.class, URLHANDLERS_CLASS, "streamHandlerLock");
                    if (m_streamHandlerFactory == null) {
                        throw err;
                    }
                    if (!m_streamHandlerFactory.getClass().getName().equals(URLHANDLERS_CLASS.getName())) {
                        URL.setURLStreamHandlerFactory(this);
                        m_rootURLHandlers = this;
                    } else if (URLHANDLERS_CLASS != m_streamHandlerFactory.getClass()) {
                        try {
                            m_secureAction.invoke(m_secureAction.getDeclaredMethod(m_streamHandlerFactory.getClass(), "registerFrameworkListsForContextSearch", new Class[]{ClassLoader.class, List.class}), m_streamHandlerFactory, new Object[]{URLHANDLERS_CLASS.getClassLoader(), m_frameworks});
                            m_rootURLHandlers = m_streamHandlerFactory;
                        }
                        catch (Exception ex) {
                            new RuntimeException(ex.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    throw err;
                }
            }
            try {
                URLConnection.setContentHandlerFactory(this);
                m_contentHandlerFactory = this;
                try {
                    m_secureAction.flush(URLConnection.class, URLConnection.class);
                }
                catch (Throwable t) {}
            }
            catch (Error err) {
                try {
                    m_contentHandlerFactory = (ContentHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(URLConnection.class, ContentHandlerFactory.class, URLHANDLERS_CLASS, null);
                    if (m_contentHandlerFactory == null) {
                        throw err;
                    }
                    if (!m_contentHandlerFactory.getClass().getName().equals(URLHANDLERS_CLASS.getName())) {
                        URLConnection.setContentHandlerFactory(this);
                    }
                }
                catch (Exception ex) {
                    throw err;
                }
            }
            if (m_streamHandlerFactory != this && URLHANDLERS_CLASS.getName().equals(m_streamHandlerFactory.getClass().getName())) {
                m_sm = null;
                m_handlerToURL.clear();
                m_builtIn.clear();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerFrameworkListsForContextSearch(ClassLoader index, List frameworkLists) {
        Class<URL> clazz = URL.class;
        synchronized (URL.class) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                m_classloaderToFrameworkLists.put(index, frameworkLists);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterFrameworkListsForContextSearch(ClassLoader index) {
        Class<URL> clazz = URL.class;
        synchronized (URL.class) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                m_classloaderToFrameworkLists.remove(index);
                if (m_classloaderToFrameworkLists.isEmpty()) {
                    List list = m_frameworks;
                    synchronized (list) {
                        if (m_frameworks.isEmpty()) {
                            try {
                                m_secureAction.swapStaticFieldIfNotClass(URL.class, URLStreamHandlerFactory.class, null, "streamHandlerLock");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (m_streamHandlerFactory.getClass() != URLHANDLERS_CLASS) {
                                URL.setURLStreamHandlerFactory(m_streamHandlerFactory);
                            }
                            try {
                                m_secureAction.swapStaticFieldIfNotClass(URLConnection.class, ContentHandlerFactory.class, null, null);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (m_contentHandlerFactory.getClass() != URLHANDLERS_CLASS) {
                                URLConnection.setContentHandlerFactory(m_contentHandlerFactory);
                            }
                        }
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLStreamHandler getBuiltInStreamHandler(String protocol, URLStreamHandlerFactory factory) {
        URLStreamHandler result;
        Map map = m_builtIn;
        synchronized (map) {
            if (m_builtIn.containsKey(protocol)) {
                return (URLStreamHandler)m_builtIn.get(protocol);
            }
        }
        if (factory != null && (result = factory.createURLStreamHandler(protocol)) != null) {
            return this.addToCache(protocol, result);
        }
        URLStreamHandler handler = this.loadBuiltInStreamHandler(protocol, null);
        if (handler == null) {
            handler = this.loadBuiltInStreamHandler(protocol, ClassLoader.getSystemClassLoader());
        }
        return this.addToCache(protocol, handler);
    }

    private URLStreamHandler loadBuiltInStreamHandler(String protocol, ClassLoader classLoader) {
        StringTokenizer pkgTok = new StringTokenizer(m_streamPkgs, "| ");
        while (pkgTok.hasMoreTokens()) {
            String pkg = pkgTok.nextToken().trim();
            String className = pkg + "." + protocol + ".Handler";
            try {
                Class handler = m_secureAction.forName(className, classLoader);
                if (handler == null) continue;
                return (URLStreamHandler)handler.newInstance();
            }
            catch (Throwable ex) {
            }
        }
        String androidHandler = null;
        if ("file".equalsIgnoreCase(protocol)) {
            androidHandler = "libcore.net.url.FileHandler";
        } else if ("ftp".equalsIgnoreCase(protocol)) {
            androidHandler = "libcore.net.url.FtpHandler";
        } else if ("http".equalsIgnoreCase(protocol)) {
            androidHandler = "libcore.net.http.HttpHandler";
        } else if ("https".equalsIgnoreCase(protocol)) {
            androidHandler = "libcore.net.http.HttpsHandler";
        } else if ("jar".equalsIgnoreCase(protocol)) {
            androidHandler = "libcore.net.url.JarHandler";
        }
        if (androidHandler != null) {
            try {
                Class handler = m_secureAction.forName(androidHandler, classLoader);
                if (handler != null) {
                    return (URLStreamHandler)handler.newInstance();
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return null;
    }

    private synchronized URLStreamHandler addToCache(String protocol, URLStreamHandler result) {
        if (!m_builtIn.containsKey(protocol)) {
            m_builtIn.put(protocol, result);
            return result;
        }
        return (URLStreamHandler)m_builtIn.get(protocol);
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = this.getFromStreamCache(protocol);
        if (handler != null) {
            return handler;
        }
        if (protocol.equals("bundle")) {
            return this.addToStreamCache(protocol, new URLHandlersBundleStreamHandler(m_secureAction));
        }
        handler = this.getBuiltInStreamHandler(protocol, m_streamHandlerFactory != this ? m_streamHandlerFactory : null);
        return this.addToStreamCache(protocol, new URLHandlersStreamHandlerProxy(protocol, m_secureAction, handler, (URL)m_handlerToURL.get(handler)));
    }

    public ContentHandler createContentHandler(String mimeType) {
        ContentHandler handler = this.getFromContentCache(mimeType);
        if (handler != null) {
            return handler;
        }
        return this.addToContentCache(mimeType, new URLHandlersContentHandlerProxy(mimeType, m_secureAction, m_contentHandlerFactory != this ? m_contentHandlerFactory : null));
    }

    private synchronized ContentHandler addToContentCache(String mimeType, ContentHandler handler) {
        if (m_contentHandlerCache == null) {
            m_contentHandlerCache = new HashMap();
        }
        return (ContentHandler)this.addToCache(m_contentHandlerCache, mimeType, handler);
    }

    private synchronized ContentHandler getFromContentCache(String mimeType) {
        return m_contentHandlerCache != null ? m_contentHandlerCache.get(mimeType) : null;
    }

    private synchronized URLStreamHandler addToStreamCache(String protocol, URLStreamHandler handler) {
        if (m_streamHandlerCache == null) {
            m_streamHandlerCache = new HashMap();
        }
        return (URLStreamHandler)this.addToCache(m_streamHandlerCache, protocol, handler);
    }

    private synchronized URLStreamHandler getFromStreamCache(String protocol) {
        return m_streamHandlerCache != null ? m_streamHandlerCache.get(protocol) : null;
    }

    private Object addToCache(Map cache, String key, Object value) {
        if (value == null) {
            return null;
        }
        Object result = cache.get(key);
        if (result == null) {
            cache.put(key, value);
            result = value;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFrameworkInstance(Object framework, boolean enable) {
        List list = m_frameworks;
        synchronized (list) {
            if (enable) {
                if (m_handler == null) {
                    m_handler = new URLHandlers();
                }
                m_frameworks.add(framework);
            }
            ++m_counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterFrameworkInstance(Object framework) {
        boolean unregister = false;
        List list = m_frameworks;
        synchronized (list) {
            --m_counter;
            if (m_frameworks.remove(framework) && m_frameworks.isEmpty()) {
                unregister = true;
                m_handler = null;
            }
        }
        if (unregister) {
            try {
                m_secureAction.invoke(m_secureAction.getDeclaredMethod(m_rootURLHandlers.getClass(), "unregisterFrameworkListsForContextSearch", new Class[]{ClassLoader.class}), m_rootURLHandlers, new Object[]{URLHANDLERS_CLASS.getClassLoader()});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFrameworkFromContext() {
        Map map = m_classloaderToFrameworkLists;
        synchronized (map) {
            if (m_classloaderToFrameworkLists.isEmpty()) {
                List list = m_frameworks;
                synchronized (list) {
                    if (m_counter == 1 && m_frameworks.size() == 1) {
                        return m_frameworks.get(0);
                    }
                }
            }
        }
        Class[] stack = m_sm.getClassContext();
        Class targetClass = null;
        for (int i = 0; i < stack.length; ++i) {
            String name;
            if (stack[i].getClassLoader() == null || !(name = stack[i].getClassLoader().getClass().getName()).startsWith("org.apache.felix.framework.ModuleImpl$ModuleClassLoader") && !name.equals("org.apache.felix.framework.searchpolicy.ContentClassLoader") && !name.startsWith("org.apache.felix.framework.BundleWiringImpl$BundleClassLoader")) continue;
            targetClass = stack[i];
            break;
        }
        if (targetClass != null) {
            Map map2 = m_classloaderToFrameworkLists;
            synchronized (map2) {
                ClassLoader index = targetClass.getClassLoader().getClass().getClassLoader();
                List frameworks = (List)m_classloaderToFrameworkLists.get(index);
                if (frameworks == null && index == URLHANDLERS_CLASS.getClassLoader()) {
                    frameworks = m_frameworks;
                }
                if (frameworks != null) {
                    List list = frameworks;
                    synchronized (list) {
                        for (int i = 0; i < frameworks.size(); ++i) {
                            Object framework = frameworks.get(i);
                            try {
                                if (m_secureAction.invoke(m_secureAction.getDeclaredMethod(framework.getClass(), "getBundle", CLASS_TYPE), framework, new Object[]{targetClass}) == null) continue;
                                return framework;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    static {
        m_builtIn = new HashMap();
        String pkgs = new SecureAction().getSystemProperty(STREAM_HANDLER_PACKAGE_PROP, "");
        m_streamPkgs = pkgs.equals("") ? DEFAULT_STREAM_HANDLER_PACKAGE : pkgs + "|" + DEFAULT_STREAM_HANDLER_PACKAGE;
        m_loaded = null != URLHandlersStreamHandlerProxy.class && null != URLHandlersContentHandlerProxy.class && null != URLStreamHandlerService.class;
        m_handlerToURL = new HashMap();
    }
}

