/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JTextField;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.copy.CopyDialog;
import org.netbeans.modules.subversion.ui.diff.Bundle;
import org.netbeans.modules.subversion.ui.diff.SelectDiffTreePanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SelectDiffTree
extends CopyDialog
implements PropertyChangeListener {
    private final RepositoryPaths repositoryPaths;
    private final File root;
    private final RepositoryFile repositoryFile;

    public SelectDiffTree(RepositoryFile repositoryFile, File root) {
        super(new SelectDiffTreePanel(), Bundle.CTL_SelectDiffTree_Title(root.getName()), Bundle.CTL_SelectDiffTree_okButton());
        int browserMode;
        String browserPurposeMessage;
        this.root = root;
        this.repositoryFile = repositoryFile;
        SelectDiffTreePanel panel = this.getSelectDiffTreePanel();
        this.setupUrlComboBox(repositoryFile, panel.urlComboBox, true);
        this.repositoryPaths = new RepositoryPaths(repositoryFile, (JTextField)panel.urlComboBox.getEditor().getEditorComponent(), panel.browseRepositoryButton, panel.revisionTextField, panel.searchRevisionButton);
        this.repositoryPaths.addPropertyChangeListener(this);
        this.getSelectDiffTreePanel().getAccessibleContext().setAccessibleDescription(Bundle.CTL_SelectDiffTree_RepositoryFile());
        if (root.isFile()) {
            this.getSelectDiffTreePanel().urlLabel.setText(Bundle.CTL_SelectDiffTree_RepositoryFile());
            browserPurposeMessage = Bundle.LBL_BrowserMessageSelectDiffTreeFile();
            browserMode = 7;
        } else {
            browserPurposeMessage = Bundle.LBL_BrowserMessageSelectDiffTreeFolder();
            browserMode = 2;
        }
        this.repositoryPaths.setupBehavior(browserPurposeMessage, browserMode, "org.netbeans.modules.subversion.ui.browser.selectdifftree", "org.netbeans.modules.subversion.ui.search.selectdifftree");
    }

    RepositoryFile getRepositoryFile() {
        try {
            RepositoryFile[] repositoryFiles = this.repositoryPaths.getRepositoryFiles();
            if (repositoryFiles.length > 0) {
                return repositoryFiles[0];
            }
            SVNRevision revision = this.repositoryPaths.getRevision();
            if (revision == null) {
                return null;
            }
            SVNUrl url = SvnUtils.getRepositoryUrl(this.root);
            RepositoryFile rf = new RepositoryFile(this.repositoryFile.getRepositoryUrl(), url, revision);
            return rf;
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        return null;
    }

    private SelectDiffTreePanel getSelectDiffTreePanel() {
        return (SelectDiffTreePanel)this.getPanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("valid")) {
            boolean valid = (Boolean)evt.getNewValue();
            this.getOKButton().setEnabled(valid);
        }
    }
}

