/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.fallback;

import java.awt.GraphicsEnvironment;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.keyring.fallback.MasterPasswordPanel;
import org.netbeans.modules.keyring.spi.EncryptionProvider;
import org.netbeans.modules.keyring.utils.Utils;
import org.openide.util.Mutex;
import org.openide.util.NbPreferences;

public class MasterPasswordEncryption
implements EncryptionProvider {
    private static final Logger LOG = Logger.getLogger(MasterPasswordEncryption.class.getName());
    private static final String ENCRYPTION_ALGORITHM = "PBEWithSHA1AndDESede";
    private SecretKeyFactory KEY_FACTORY;
    private AlgorithmParameterSpec PARAM_SPEC;
    private Cipher encrypt;
    private Cipher decrypt;
    private boolean unlocked;
    private Callable<Void> encryptionChanging;
    private char[] newMasterPassword;
    private boolean fresh;

    @Override
    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.master")) {
            LOG.fine("master password encryption disabled");
            return false;
        }
        if (GraphicsEnvironment.isHeadless()) {
            LOG.fine("disabling master password encryption in headless mode");
            return false;
        }
        try {
            this.KEY_FACTORY = SecretKeyFactory.getInstance(ENCRYPTION_ALGORITHM);
            this.encrypt = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            this.decrypt = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            Preferences prefs = NbPreferences.forModule(Keyring.class);
            Utils.goMinusR(prefs);
            String saltKey = "salt";
            byte[] salt = prefs.getByteArray(saltKey, null);
            if (salt == null) {
                salt = new byte[36];
                new SecureRandom().nextBytes(salt);
                prefs.putByteArray(saltKey, salt);
            }
            this.PARAM_SPEC = new PBEParameterSpec(salt, 20);
            LOG.warning("Falling back to master password encryption; add -J-Dorg.netbeans.modules.keyring.level=0 to netbeans.conf to see why native keyrings could not be loaded");
            return true;
        }
        catch (Exception x) {
            LOG.log(Level.INFO, "Cannot initialize security using PBEWithSHA1AndDESede", x);
            return false;
        }
    }

    @Override
    public String id() {
        return "general";
    }

    @Override
    public byte[] encrypt(char[] cleartext) throws Exception {
        if (!this.unlockIfNecessary()) {
            throw new Exception("cannot unlock");
        }
        try {
            return this.doEncrypt(cleartext);
        }
        catch (Exception x) {
            this.unlocked = false;
            throw x;
        }
    }

    @Override
    public char[] decrypt(byte[] ciphertext) throws Exception {
        AtomicBoolean callEncryptionChanging = new AtomicBoolean();
        if (!this.unlockIfNecessary(callEncryptionChanging)) {
            throw new Exception("cannot unlock");
        }
        try {
            char[] cArray = this.doDecrypt(ciphertext);
            return cArray;
        }
        catch (Exception x) {
            this.unlocked = false;
            throw x;
        }
        finally {
            if (callEncryptionChanging.get()) {
                try {
                    this.encryptionChanging.call();
                }
                catch (Exception x) {
                    LOG.log(Level.FINE, "failed to change encryption", x);
                }
            }
        }
    }

    private boolean unlockIfNecessary() {
        AtomicBoolean callEncryptionChanging = new AtomicBoolean();
        boolean result = this.unlockIfNecessary(callEncryptionChanging);
        if (callEncryptionChanging.get()) {
            try {
                this.encryptionChanging.call();
            }
            catch (Exception x) {
                LOG.log(Level.FINE, "failed to change encryption", x);
            }
        }
        return result;
    }

    private boolean unlockIfNecessary(AtomicBoolean callEncryptionChanging) {
        if (this.unlocked) {
            return true;
        }
        char[][] passwords = (char[][])Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<char[][]>(){

            public char[][] run() {
                return new MasterPasswordPanel().display(MasterPasswordEncryption.this.fresh);
            }
        });
        if (passwords == null) {
            LOG.fine("cancelled master password dialog");
            return false;
        }
        try {
            this.unlock(passwords[0]);
            Arrays.fill(passwords[0], '\u0000');
            if (passwords.length == 2) {
                this.newMasterPassword = passwords[1];
                LOG.fine("will set new master password");
                callEncryptionChanging.set(true);
            }
            return true;
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "failed to initialize ciphers", x);
            return false;
        }
    }

    void unlock(char[] masterPassword) throws Exception {
        LOG.fine("switching to new master password");
        PBEKeySpec keySpec = new PBEKeySpec(masterPassword);
        SecretKey key = this.KEY_FACTORY.generateSecret(keySpec);
        this.encrypt.init(1, (Key)key, this.PARAM_SPEC);
        this.decrypt.init(2, (Key)key, this.PARAM_SPEC);
        this.unlocked = true;
    }

    byte[] doEncrypt(char[] cleartext) throws Exception {
        assert (this.unlocked);
        byte[] cleartextB = Utils.chars2Bytes(cleartext);
        byte[] result = this.encrypt.doFinal(cleartextB);
        Arrays.fill(cleartextB, (byte)0);
        return result;
    }

    char[] doDecrypt(byte[] ciphertext) throws Exception {
        assert (this.unlocked);
        byte[] result = this.decrypt.doFinal(ciphertext);
        char[] cleartext = Utils.bytes2Chars(result);
        Arrays.fill(result, (byte)0);
        return cleartext;
    }

    @Override
    public boolean decryptionFailed() {
        this.unlocked = false;
        return this.unlockIfNecessary();
    }

    @Override
    public void encryptionChangingCallback(Callable<Void> callback) {
        this.encryptionChanging = callback;
    }

    @Override
    public void encryptionChanged() {
        assert (this.newMasterPassword != null);
        LOG.fine("encryption changed");
        try {
            this.unlock(this.newMasterPassword);
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "failed to initialize ciphers", x);
        }
        Arrays.fill(this.newMasterPassword, '\u0000');
        this.newMasterPassword = null;
    }

    @Override
    public void freshKeyring(boolean fresh) {
        this.fresh = fresh;
    }
}

