/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.testng.AbstractTestGenerator;
import org.netbeans.modules.testng.ClassMap;
import org.netbeans.modules.testng.TestGeneratorSetup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestGenerator
extends AbstractTestGenerator {
    static final String ANN_BEFORE_CLASS = "org.testng.annotations.BeforeClass";
    static final String ANN_AFTER_CLASS = "org.testng.annotations.AfterClass";
    static final String ANN_BEFORE = "org.testng.annotations.BeforeMethod";
    static final String ANN_AFTER = "org.testng.annotations.AfterMethod";
    static final String ANN_TEST = "org.testng.annotations.Test";
    private static final String ANN_SUITE_MEMBERS = "SuiteClasses";
    private static final String BEFORE_CLASS_METHOD_NAME = "setUpClass";
    private static final String AFTER_CLASS_METHOD_NAME = "tearDownClass";
    private static final String BEFORE_METHOD_NAME = "setUpMethod";
    private static final String AFTER_METHOD_NAME = "tearDownMethod";

    TestGenerator(TestGeneratorSetup setup) {
        super(setup);
    }

    TestGenerator(TestGeneratorSetup setup, List<ElementHandle<TypeElement>> srcTopClassHandles, List<String> suiteMembers, boolean isNewTestClass) {
        super(setup, srcTopClassHandles, suiteMembers, isNewTestClass);
    }

    @Override
    protected ClassTree composeNewTestClass(WorkingCopy workingCopy, String name, List<? extends Tree> members) {
        TreeMaker maker = workingCopy.getTreeMaker();
        ModifiersTree modifiers = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        return maker.Class(modifiers, (CharSequence)name, Collections.emptyList(), null, Collections.emptyList(), members);
    }

    @Override
    protected List<? extends Tree> generateInitMembers(WorkingCopy workingCopy) {
        if (!(this.setup.isGenerateBefore() || this.setup.isGenerateAfter() || this.setup.isGenerateBeforeClass() || this.setup.isGenerateAfterClass())) {
            return Collections.emptyList();
        }
        ArrayList<MethodTree> result = new ArrayList<MethodTree>(4);
        if (this.setup.isGenerateBeforeClass()) {
            result.add(this.generateInitMethod(BEFORE_CLASS_METHOD_NAME, ANN_BEFORE_CLASS, true, workingCopy));
        }
        if (this.setup.isGenerateAfterClass()) {
            result.add(this.generateInitMethod(AFTER_CLASS_METHOD_NAME, ANN_AFTER_CLASS, true, workingCopy));
        }
        if (this.setup.isGenerateBefore()) {
            result.add(this.generateInitMethod(BEFORE_METHOD_NAME, ANN_BEFORE, false, workingCopy));
        }
        if (this.setup.isGenerateAfter()) {
            result.add(this.generateInitMethod(AFTER_METHOD_NAME, ANN_AFTER, false, workingCopy));
        }
        return result;
    }

    @Override
    protected ClassTree generateMissingInitMembers(ClassTree tstClass, TreePath tstClassTreePath, WorkingCopy workingCopy) {
        if (!(this.setup.isGenerateBefore() || this.setup.isGenerateAfter() || this.setup.isGenerateBeforeClass() || this.setup.isGenerateAfterClass())) {
            return tstClass;
        }
        ClassMap classMap = ClassMap.forClass(tstClass, tstClassTreePath, workingCopy.getTrees());
        if (!(this.setup.isGenerateBefore() && !classMap.containsBefore() || this.setup.isGenerateAfter() && !classMap.containsAfter() || this.setup.isGenerateBeforeClass() && !classMap.containsBeforeClass() || this.setup.isGenerateAfterClass() && !classMap.containsAfterClass())) {
            return tstClass;
        }
        TreeMaker maker = workingCopy.getTreeMaker();
        List<? extends Tree> tstMembersOrig = tstClass.getMembers();
        ArrayList<Tree> tstMembers = new ArrayList<Tree>(tstMembersOrig.size() + 4);
        tstMembers.addAll(tstMembersOrig);
        this.generateMissingInitMembers(tstMembers, classMap, workingCopy);
        ClassTree newClass = maker.Class(tstClass.getModifiers(), (CharSequence)tstClass.getSimpleName(), tstClass.getTypeParameters(), tstClass.getExtendsClause(), tstClass.getImplementsClause(), tstMembers);
        return newClass;
    }

    @Override
    protected boolean generateMissingInitMembers(List<Tree> tstMembers, ClassMap clsMap, WorkingCopy workingCopy) {
        int afterClassIndex;
        int beforeClassIndex;
        int afterIndex;
        int beforeIndex;
        int targetIndex;
        boolean modified = false;
        if (this.setup.isGenerateBeforeClass() && !clsMap.containsBeforeClass()) {
            if (clsMap.containsAfterClass()) {
                targetIndex = clsMap.getAfterClassIndex();
            } else {
                beforeIndex = clsMap.getBeforeIndex();
                afterIndex = clsMap.getAfterIndex();
                targetIndex = beforeIndex != -1 && afterIndex != -1 ? Math.min(beforeIndex, afterIndex) : Math.max(beforeIndex, afterIndex);
            }
            this.addInitMethod(BEFORE_CLASS_METHOD_NAME, ANN_BEFORE_CLASS, true, targetIndex, tstMembers, clsMap, workingCopy);
            modified = true;
        }
        if (this.setup.isGenerateAfterClass() && !clsMap.containsAfterClass()) {
            if (clsMap.containsBeforeClass()) {
                targetIndex = clsMap.getBeforeClassIndex() + 1;
            } else {
                beforeIndex = clsMap.getBeforeIndex();
                afterIndex = clsMap.getAfterIndex();
                targetIndex = beforeIndex != -1 && afterIndex != -1 ? Math.min(beforeIndex, afterIndex) : Math.max(beforeIndex, afterIndex);
            }
            this.addInitMethod(AFTER_CLASS_METHOD_NAME, ANN_AFTER_CLASS, true, targetIndex, tstMembers, clsMap, workingCopy);
            modified = true;
        }
        if (this.setup.isGenerateBefore() && !clsMap.containsBefore()) {
            if (clsMap.containsAfter()) {
                targetIndex = clsMap.getAfterIndex();
            } else {
                beforeClassIndex = clsMap.getBeforeClassIndex();
                targetIndex = Math.max(beforeClassIndex, afterClassIndex = clsMap.getAfterClassIndex());
                if (targetIndex != -1) {
                    ++targetIndex;
                }
            }
            this.addInitMethod(BEFORE_METHOD_NAME, ANN_BEFORE, false, targetIndex, tstMembers, clsMap, workingCopy);
            modified = true;
        }
        if (this.setup.isGenerateAfter() && !clsMap.containsAfter()) {
            if (clsMap.containsBefore()) {
                targetIndex = clsMap.getBeforeIndex() + 1;
            } else {
                beforeClassIndex = clsMap.getBeforeClassIndex();
                targetIndex = Math.max(beforeClassIndex, afterClassIndex = clsMap.getAfterClassIndex());
                if (targetIndex != -1) {
                    ++targetIndex;
                }
            }
            this.addInitMethod(AFTER_METHOD_NAME, ANN_AFTER, false, targetIndex, tstMembers, clsMap, workingCopy);
            modified = true;
        }
        return modified;
    }

    private void addInitMethod(String methodName, String annotationClassName, boolean isStatic, int targetIndex, List<Tree> clsMembers, ClassMap clsMap, WorkingCopy workingCopy) {
        MethodTree initMethod = this.generateInitMethod(methodName, annotationClassName, isStatic, workingCopy);
        if (targetIndex == -1) {
            targetIndex = this.getPlaceForFirstInitMethod(clsMap);
        }
        if (targetIndex != -1) {
            clsMembers.add(targetIndex, initMethod);
        } else {
            clsMembers.add(initMethod);
        }
        clsMap.addNoArgMethod(methodName, annotationClassName, targetIndex);
    }

    private MethodTree generateInitMethod(String methodName, String annotationClassName, boolean isStatic, WorkingCopy workingCopy) {
        Set<Modifier> methodModifiers = isStatic ? TestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.STATIC) : Collections.singleton(Modifier.PUBLIC);
        ModifiersTree modifiers = this.createModifiersTree(annotationClassName, methodModifiers, workingCopy);
        TreeMaker maker = workingCopy.getTreeMaker();
        BlockTree methodBody = maker.Block(Collections.emptyList(), false);
        MethodTree method = maker.Method(modifiers, (CharSequence)methodName, (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(maker.Identifier((CharSequence)"Exception")), methodBody, null);
        return method;
    }

    @Override
    protected void generateMissingPostInitMethods(TreePath tstClassTreePath, List<Tree> tstMembers, ClassMap clsMap, WorkingCopy workingCopy) {
    }

    @Override
    protected MethodTree composeNewTestMethod(String testMethodName, BlockTree testMethodBody, List<ExpressionTree> throwsList, WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        return maker.Method(this.createModifiersTree(ANN_TEST, TestGenerator.createModifierSet(Modifier.PUBLIC), workingCopy), (CharSequence)testMethodName, (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), throwsList, testMethodBody, null);
    }

    private boolean checkSuiteMembersAnnotation(AnnotationMirror annMirror, List<String> suiteMembers, WorkingCopy workingCopy) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> annParams = annMirror.getElementValues();
        if (annParams.size() != 1) {
            return false;
        }
        AnnotationValue annValue = annParams.values().iterator().next();
        Object value = annValue.getValue();
        if (value instanceof List) {
            List items = (List)value;
            if (items.size() != suiteMembers.size()) {
                return false;
            }
            Types types = workingCopy.getTypes();
            Iterator<String> suiteMembersIt = suiteMembers.iterator();
            for (AnnotationValue item : items) {
                Name suiteMemberName = this.getAnnotationValueClassName(item, types);
                if (suiteMemberName == null) {
                    return false;
                }
                if (suiteMemberName.contentEquals(suiteMembersIt.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Name getAnnotationValueClassName(AnnotationValue annValue, Types types) {
        TypeMirror typeMirror;
        Element typeElement;
        Object value = annValue.getValue();
        if (value instanceof TypeMirror && (typeElement = types.asElement(typeMirror = (TypeMirror)value)).getKind() == ElementKind.CLASS) {
            return ((TypeElement)typeElement).getQualifiedName();
        }
        return null;
    }
}

