/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.knockout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import org.netbeans.spi.knockout.BindingsProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.TopologicalSortException;

public final class Bindings {
    private final String name;
    private final List<Bindings> subBindings = new ArrayList<Bindings>();
    private final List<Object> props = new ArrayList<Object>();

    private Bindings(String name) {
        this.name = name;
    }

    public static Bindings create(String name) {
        return new Bindings(name);
    }

    public final Bindings booleanProperty(String name, boolean array) {
        this.addProp(name, array, "true");
        return this;
    }

    public final Bindings stringProperty(String name, boolean array) {
        this.addProp(name, array, "''");
        return this;
    }

    public final Bindings intProperty(String name, boolean array) {
        this.addProp(name, array, "0");
        return this;
    }

    public final Bindings doubleProperty(String name, boolean array) {
        this.addProp(name, array, "0.1");
        return this;
    }

    public final Bindings function(String name) {
        this.addProp(name, false, "function() {}");
        return this;
    }

    public final Bindings modelProperty(String name, Bindings binding, boolean array) {
        this.subBindings.add(binding);
        this.addProp(name, array, binding);
        return this;
    }

    final String generate() {
        StringBuilder sb = new StringBuilder();
        HashSet<Bindings> visited = new HashSet<Bindings>();
        SequencedCollection<Bindings> lhs = new LinkedHashSet<Bindings>();
        StringBuilder delayedInit = new StringBuilder();
        if (!this.walkBindings(visited, lhs)) {
            HashMap<Bindings, List<Bindings>> edges = new HashMap<Bindings, List<Bindings>>();
            for (Bindings b : lhs) {
                edges.put(b, b.subBindings);
            }
            try {
                BaseUtilities.topologicalSort(lhs, edges);
                throw new IllegalStateException();
            }
            catch (TopologicalSortException ex) {
                lhs = Collections.checkedList(ex.partialSort(), Bindings.class);
            }
        }
        for (Bindings b : lhs) {
            b.generate(sb, delayedInit, visited);
            visited.remove(b);
        }
        sb.append((CharSequence)delayedInit);
        sb.append("\nko.applyBindings(").append(this.name).append(");\n");
        return sb.toString();
    }

    private void generate(StringBuilder sb, StringBuilder delayedInit, Set<Bindings> notYetProcessed) {
        sb.append("var ").append(this.name).append(" = {");
        String sep = "\n";
        for (int i = 0; i < this.props.size(); i += 3) {
            String propName = (String)this.props.get(i);
            Boolean array = (Boolean)this.props.get(i + 1);
            Object value = this.props.get(i + 2);
            if (value instanceof Bindings) {
                Bindings b = (Bindings)value;
                if (notYetProcessed.contains(b)) {
                    delayedInit.append("\n").append(this.name).append("[\"").append(propName).append("\"] = ").append(b.name).append(";");
                    continue;
                }
                value = b.name;
            }
            if (array.booleanValue()) {
                value = "[ " + value + " ]";
            }
            sb.append(sep).append("  ").append('\"').append(propName).append("\" : ").append(value);
            sep = ",\n";
        }
        sb.append("\n};\n");
    }

    private void addProp(String name, boolean array, Object value) {
        if (name.contains("\"")) {
            throw new IllegalStateException("Wrong name " + name);
        }
        this.props.add(name);
        this.props.add(array);
        this.props.add(value);
    }

    private boolean walkBindings(Set<Bindings> visited, Collection<Bindings> collect) {
        if (!visited.add(this)) {
            return false;
        }
        boolean ok = true;
        for (Bindings b : this.subBindings) {
            ok &= b.walkBindings(visited, collect);
        }
        collect.add(this);
        return ok;
    }

    public static String findBindings(FileObject htmlFile, int versionOfFormat) {
        if (versionOfFormat != 1) {
            return null;
        }
        for (BindingsProvider p : Lookup.getDefault().lookupAll(BindingsProvider.class)) {
            BindingsProvider.Response r = p.findBindings(htmlFile);
            if (r.bindings == null) continue;
            return r.bindings.generate();
        }
        return null;
    }
}

