/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tax.parser.XMLParsingSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.io.TreeStreamResult;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.xml.sax.InputSource;

public class LayerUtils {
    private static final Logger LOG = Logger.getLogger(LayerUtils.class.getName());

    private LayerUtils() {
    }

    public static ClassPath findResourceCP(Project project) {
        Sources s = ProjectUtils.getSources((Project)project);
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        for (String type : new String[]{"java", "resources"}) {
            for (SourceGroup group : s.getSourceGroups(type)) {
                roots.add(group.getRootFolder());
            }
        }
        if (roots.isEmpty()) {
            LOG.log(Level.WARNING, "no resource path for {0}", project);
        }
        return ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
    }

    static URL[] currentify(URL u, String suffix, ClassPath cp) {
        if (cp == null) {
            return new URL[]{u};
        }
        if (u.getProtocol().equals("nbres")) {
            FileObject fo;
            String path = u.getFile();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((fo = cp.findResource(path)) != null) {
                return new URL[]{fo.toURL()};
            }
        } else if (u.getProtocol().equals("nbresloc")) {
            String ext;
            String name;
            String nameext;
            String folder;
            int idx;
            ArrayList<URL> urls = new ArrayList<URL>();
            String path = u.getFile();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((idx = path.lastIndexOf(47)) == -1) {
                folder = "";
                nameext = path;
            } else {
                folder = path.substring(0, idx + 1);
                nameext = path.substring(idx + 1);
            }
            idx = nameext.lastIndexOf(46);
            if (idx == -1) {
                name = nameext;
                ext = "";
            } else {
                name = nameext.substring(0, idx);
                ext = nameext.substring(idx);
            }
            ArrayList<String> suffixes = new ArrayList<String>(LayerUtils.computeSubVariants(suffix));
            suffixes.add(suffix);
            Collections.reverse(suffixes);
            for (String trysuffix : suffixes) {
                String trypath = folder + name + trysuffix + ext;
                FileObject fo = cp.findResource(trypath);
                if (fo == null) continue;
                urls.add(fo.toURL());
            }
            if (!urls.isEmpty()) {
                return urls.toArray(new URL[urls.size()]);
            }
        }
        return new URL[]{u};
    }

    static URL urlForBundle(String bundleName) throws MalformedURLException {
        return new URL("nbresloc:/" + bundleName.replace('.', '/') + ".properties");
    }

    private static List<String> computeSubVariants(String name) {
        int idx = name.indexOf(95);
        if (idx == -1) {
            return Collections.emptyList();
        }
        String base = name.substring(0, idx);
        String suffix = name.substring(idx);
        List<String> l = LayerUtils.computeSubVariants(base, suffix);
        return l.subList(0, l.size() - 1);
    }

    private static List<String> computeSubVariants(String base, String suffix) {
        int idx = suffix.indexOf(95, 1);
        if (idx == -1) {
            LinkedList<String> l = new LinkedList<String>();
            l.add(base);
            l.add(base + suffix);
            return l;
        }
        String remainder = suffix.substring(idx);
        List<String> l1 = LayerUtils.computeSubVariants(base, remainder);
        List<String> l2 = LayerUtils.computeSubVariants(base + suffix.substring(0, idx), remainder);
        LinkedList<String> l = new LinkedList<String>(l1);
        l.addAll(l2);
        return l;
    }

    public static SavableTreeEditorCookie cookieForFile(FileObject f) {
        return new CookieImpl(f);
    }

    @NonNull
    public static FileSystem getEffectiveSystemFilesystem(Project p) throws IOException {
        NbModuleProvider nbm = (NbModuleProvider)p.getLookup().lookup(NbModuleProvider.class);
        assert (nbm != null);
        return nbm.getEffectiveSystemFilesystem();
    }

    private static final class CookieImpl
    implements SavableTreeEditorCookie,
    FileChangeListener,
    FileSystem.AtomicAction {
        private TreeDocumentRoot root;
        private boolean dirty;
        private Exception problem;
        private final FileObject f;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private static RequestProcessor RP = new RequestProcessor(CookieImpl.class.getName());

        public CookieImpl(FileObject f) {
            this.f = f;
            f.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)f));
        }

        public TreeDocumentRoot getDocumentRoot() {
            return this.root;
        }

        public int getStatus() {
            if (this.problem != null) {
                return 3;
            }
            if (this.root != null) {
                return 1;
            }
            return 0;
        }

        public TreeDocumentRoot openDocumentRoot() throws IOException, TreeException {
            if (this.root == null && this.f.isValid()) {
                try {
                    boolean oldDirty = this.dirty;
                    int oldStatus = this.getStatus();
                    this.root = new XMLParsingSupport().parse(new InputSource(this.f.toURL().toExternalForm()));
                    this.problem = null;
                    this.dirty = false;
                    this.pcs.firePropertyChange("dirty", oldDirty, false);
                    this.pcs.firePropertyChange("status", oldStatus, 1);
                }
                catch (IOException e) {
                    this.problem = e;
                    throw e;
                }
                catch (TreeException e) {
                    this.problem = e;
                    throw e;
                }
                ((TreeObject)this.root).addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        CookieImpl.this.modified();
                    }
                });
            }
            return this.root;
        }

        public Task prepareDocumentRoot() {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        private void modified() {
            if (!this.dirty) {
                this.dirty = true;
                this.pcs.firePropertyChange("dirty", false, true);
            }
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public synchronized void save() throws IOException {
            if (this.root == null || !this.dirty) {
                return;
            }
            this.f.getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            this.dirty = false;
            this.pcs.firePropertyChange("dirty", true, false);
        }

        public void run() throws IOException {
            OutputStream os = this.f.getOutputStream();
            try {
                new TreeStreamResult(os).getWriter(this.root).writeDocument();
            }
            catch (TreeException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            finally {
                os.close();
            }
        }

        public void fileChanged(final FileEvent fe) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CookieImpl.this.changed(fe);
                }
            });
        }

        public void fileDeleted(FileEvent fe) {
            this.changed(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.changed((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
            assert (false);
        }

        public void fileDataCreated(FileEvent fe) {
            assert (false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changed(FileEvent fe) {
            CookieImpl cookieImpl = this;
            synchronized (cookieImpl) {
                if (fe.firedFrom((FileSystem.AtomicAction)this)) {
                    return;
                }
                this.problem = null;
                this.dirty = false;
                this.root = null;
            }
            this.pcs.firePropertyChange("documentRoot", null, null);
        }
    }

    public static interface SavableTreeEditorCookie
    extends TreeEditorCookie {
        public static final String PROP_DIRTY = "dirty";

        public boolean isDirty();

        public void save() throws IOException;
    }
}

