/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

final class Asm {
    private static final String DESC_PATCHED_PUBLIC_ANNOTATION = "Lorg/openide/modules/PatchedPublic;";
    private static final String DESC_CTOR_ANNOTATION = "Lorg/openide/modules/ConstructorDelegate;";
    private static final String DESC_DEFAULT_CTOR = "()V";
    private static final String CONSTRUCTOR_NAME = "<init>";

    private Asm() {
    }

    public static byte[] patch(byte[] data, String extender, ClassLoader theClassLoader) throws IOException {
        String extInternalName;
        ClassReader clr = new ClassReader(data);
        ClassWriter wr = new ClassWriter(clr, 0);
        ClassNode theClass = new ClassNode();
        clr.accept((ClassVisitor)theClass, 0);
        MethodNode defCtor = null;
        theClass.superName = extInternalName = extender.replace(".", "/");
        String resName = extInternalName + ".class";
        try (InputStream istm = theClassLoader.getResourceAsStream(resName);){
            if (istm == null) {
                throw new IOException("Could not find classfile for extender class");
            }
            ClassReader extenderReader = new ClassReader(istm);
            ClassNode extenderClass = new ClassNode();
            extenderReader.accept((ClassVisitor)extenderClass, 4);
            for (MethodNode m : theClass.methods) {
                if (!CONSTRUCTOR_NAME.equals(m.name)) continue;
                if (DESC_DEFAULT_CTOR.equals(m.desc)) {
                    defCtor = m;
                }
                Asm.replaceSuperCtorCalls(theClass, extenderClass, m);
            }
            block10: for (Object o : extenderClass.methods) {
                MethodNode mn = (MethodNode)o;
                if (mn.invisibleAnnotations == null || (mn.access & 8) <= 0) continue;
                for (AnnotationNode an : mn.invisibleAnnotations) {
                    if (!DESC_CTOR_ANNOTATION.equals(an.desc)) continue;
                    Asm.delegateToFactory(an, extenderClass, mn, theClass, defCtor);
                    continue block10;
                }
            }
            block12: for (MethodNode mn : theClass.methods) {
                if (mn.invisibleAnnotations == null) continue;
                for (AnnotationNode an : mn.invisibleAnnotations) {
                    if (!DESC_PATCHED_PUBLIC_ANNOTATION.equals(an.desc)) continue;
                    mn.access = mn.access & 0xFFFFFFF9 | 1;
                    continue block12;
                }
            }
        }
        theClass.accept((ClassVisitor)wr);
        byte[] result = wr.toByteArray();
        return result;
    }

    private static void replaceSuperCtorCalls(ClassNode theClass, ClassNode extenderClass, MethodNode mn) {
        for (AbstractInsnNode aIns : mn.instructions) {
            if (aIns.getOpcode() != 183) continue;
            MethodInsnNode mins = (MethodInsnNode)aIns;
            if (!CONSTRUCTOR_NAME.equals(mins.name) || !mins.owner.equals(extenderClass.superName)) break;
            mins.owner = extenderClass.name;
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] splitDescriptor(String desc) {
        ArrayList<String> arr = new ArrayList<String>();
        int lastPos = 0;
        int i = 0;
        while (i < desc.length()) {
            char c = desc.charAt(i);
            switch (c) {
                case '(': {
                    lastPos = i + 1;
                    break;
                }
                case ')': {
                    return arr.toArray(new String[arr.size()]);
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    arr.add(desc.substring(lastPos, i + 1));
                    lastPos = i + 1;
                    break;
                }
                case '[': {
                    break;
                }
                case 'L': {
                    i = desc.indexOf(59, i);
                    arr.add(desc.substring(lastPos, i + 1));
                    lastPos = i + 1;
                }
            }
            ++i;
        }
        return arr.toArray(new String[arr.size()]);
    }

    private static void delegateToFactory(AnnotationNode an, ClassNode targetClass, MethodNode targetMethod, ClassNode clazz, MethodNode noArgCtor) {
        String desc = targetMethod.desc;
        CtorDelVisitor v = new CtorDelVisitor(327680);
        an.accept((AnnotationVisitor)v);
        int nextPos = desc.indexOf(59, 2);
        desc = "(" + desc.substring(nextPos + 1);
        MethodNode mn = new MethodNode(327680, targetMethod.access & 0xFFFFFFF7, CONSTRUCTOR_NAME, desc, targetMethod.signature, targetMethod.exceptions.toArray(new String[targetMethod.exceptions.size()]));
        mn.visibleAnnotations = targetMethod.visibleAnnotations;
        mn.visibleParameterAnnotations = targetMethod.visibleParameterAnnotations;
        mn.parameters = targetMethod.parameters;
        mn.exceptions = targetMethod.exceptions;
        mn.visitCode();
        mn.visitVarInsn(25, 0);
        if (v.indices == null) {
            mn.visitMethodInsn(183, clazz.name, noArgCtor.name, noArgCtor.desc, false);
        } else {
            String[] paramDescs = Asm.splitDescriptor(targetMethod.desc);
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (int i : v.indices) {
                sb.append(paramDescs[i]);
            }
            sb.append(")V");
            SignatureReader r = new SignatureReader(targetMethod.desc);
            CallParametersWriter callWr = new CallParametersWriter(mn, v.indices);
            r.accept((SignatureVisitor)callWr);
            for (int i : v.indices) {
                mn.visitVarInsn(callWr.out[i * 2], callWr.out[i * 2 + 1]);
            }
            mn.visitMethodInsn(183, clazz.name, CONSTRUCTOR_NAME, sb.toString(), false);
        }
        SignatureReader r = new SignatureReader(targetMethod.desc);
        CallParametersWriter callWr = new CallParametersWriter(mn, true);
        r.accept((SignatureVisitor)callWr);
        mn.visitMethodInsn(184, targetClass.name, targetMethod.name, targetMethod.desc, false);
        mn.visitInsn(177);
        mn.maxStack = callWr.localSize;
        mn.maxLocals = callWr.localSize;
        clazz.methods.add(mn);
    }

    private static class CtorDelVisitor
    extends AnnotationVisitor {
        int[] indices;

        public CtorDelVisitor(int i) {
            super(i);
        }

        public void visit(String string, Object o) {
            if ("delegateParams".equals(string)) {
                this.indices = (int[])o;
            }
            super.visit(string, o);
        }
    }

    private static class CallParametersWriter
    extends SignatureVisitor {
        private final MethodNode mn;
        private int localSize;
        private int[] paramIndices;
        int[] out = new int[10];
        private int cnt;
        private int paramIndex = 0;

        public CallParametersWriter(MethodNode mn, boolean firstSelf) {
            super(327680);
            this.mn = mn;
            this.paramIndex = firstSelf ? 0 : 1;
        }

        public CallParametersWriter(MethodNode mn, int[] indices) {
            super(327680);
            this.mn = mn;
            this.paramIndices = indices;
        }

        void storeLoads() {
            for (int i : this.paramIndices) {
                this.mn.visitVarInsn(this.out[i * 2], this.out[i * 2 + 1]);
            }
        }

        private void load(int opcode, int paramIndex) {
            if (this.paramIndices == null) {
                this.mn.visitVarInsn(opcode, paramIndex);
            } else {
                if (this.out.length <= paramIndex + 1) {
                    this.out = Arrays.copyOf(this.out, this.out.length * 2);
                }
                this.out[this.cnt * 2] = opcode;
                this.out[this.cnt * 2 + 1] = paramIndex;
            }
            ++this.cnt;
        }

        public void visitEnd() {
            this.load(25, this.paramIndex++);
            ++this.localSize;
        }

        public void visitBaseType(char c) {
            int opcode;
            int idx = this.paramIndex++;
            switch (c) {
                case 'J': {
                    opcode = 22;
                    ++this.paramIndex;
                    ++this.localSize;
                    break;
                }
                case 'D': {
                    opcode = 24;
                    ++this.paramIndex;
                    ++this.localSize;
                    break;
                }
                case 'F': {
                    opcode = 23;
                    break;
                }
                default: {
                    opcode = 21;
                }
            }
            this.load(opcode, idx);
            ++this.localSize;
        }

        public SignatureVisitor visitTypeArgument(char c) {
            return new NullSignVisitor();
        }

        public void visitTypeArgument() {
        }

        public void visitInnerClassType(String string) {
        }

        public void visitClassType(String string) {
        }

        public SignatureVisitor visitArrayType() {
            this.load(25, this.paramIndex++);
            ++this.localSize;
            return new NullSignVisitor();
        }

        public void visitTypeVariable(String string) {
        }

        public SignatureVisitor visitExceptionType() {
            return new NullSignVisitor();
        }

        public SignatureVisitor visitReturnType() {
            return new NullSignVisitor();
        }

        public SignatureVisitor visitParameterType() {
            return this;
        }

        public SignatureVisitor visitInterface() {
            return null;
        }

        public SignatureVisitor visitSuperclass() {
            return null;
        }

        public SignatureVisitor visitInterfaceBound() {
            return new NullSignVisitor();
        }

        public SignatureVisitor visitClassBound() {
            return new NullSignVisitor();
        }

        public void visitFormalTypeParameter(String string) {
            super.visitFormalTypeParameter(string);
        }
    }

    private static class NullSignVisitor
    extends SignatureVisitor {
        public NullSignVisitor() {
            super(327680);
        }
    }
}

