/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class SQLHistoryEntry {
    private String url;
    private String sql;
    private Date date;

    protected SQLHistoryEntry() {
    }

    public SQLHistoryEntry(String url, String sql, Date date) {
        this.url = url;
        this.sql = sql;
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    void setDate(Date date) {
        this.date = date;
    }

    public String getSql() {
        return this.sql;
    }

    void setSql(String sql) {
        this.sql = sql != null ? sql.trim() : sql;
    }

    public String getUrl() {
        return this.url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    String getDateXMLVariant() {
        if (this.date == null) {
            return Long.toString(new Date().getTime());
        }
        return Long.toString(this.date.getTime());
    }

    void setDateXMLVariant(String value) {
        if (value == null) {
            this.date = new Date();
        } else {
            try {
                this.date = new Date(Long.parseLong(value));
            }
            catch (NumberFormatException nfe) {
                try {
                    this.date = DateFormat.getDateTimeInstance(3, 3).parse(value);
                }
                catch (ParseException pe) {
                    this.date = new Date();
                }
            }
        }
    }

    public String toString() {
        return "SQLHistoryEntry{url=" + this.url + ", sql=" + this.sql + ", date=" + this.date + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLHistoryEntry other = (SQLHistoryEntry)obj;
        if (this.url == null ? other.url != null : !this.url.toLowerCase().equals(other.url.toLowerCase())) {
            return false;
        }
        return !(this.sql == null ? other.sql != null : !this.sql.toLowerCase().equals(other.sql.toLowerCase()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.sql != null ? this.sql.toLowerCase().hashCode() : 0);
        return hash;
    }
}

