/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.htmlui;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.htmlui.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class JSNI2JavaScriptBody {
    public static ErrorDescription computeWarning(HintContext ctx) {
        Token<JavaTokenId> token = JSNI2JavaScriptBody.findBlockToken(ctx.getInfo(), ctx.getPath(), ctx);
        if (token == null) {
            return null;
        }
        Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix();
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_JSNI2JavaScriptBody(), (Fix[])new Fix[]{fix});
    }

    private static Token<JavaTokenId> findBlockToken(CompilationInfo info, TreePath path, HintContext ctx) {
        int end = (int)info.getTrees().getSourcePositions().getEndPosition(path.getCompilationUnit(), path.getLeaf());
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return null;
        }
        ts.move(end);
        if (ctx != null && ctx.isCanceled() || !ts.movePrevious() || ts.token().id() != JavaTokenId.SEMICOLON) {
            return null;
        }
        block6: while (ts.movePrevious()) {
            if (ctx != null && ctx.isCanceled()) {
                return null;
            }
            switch ((JavaTokenId)ts.token().id()) {
                case WHITESPACE: {
                    continue block6;
                }
                case LINE_COMMENT: {
                    continue block6;
                }
                case JAVADOC_COMMENT: {
                    continue block6;
                }
                case BLOCK_COMMENT: {
                    CharSequence tok = ts.token().text();
                    int l = tok.length();
                    if (l <= 4 || !tok.subSequence(0, 4).toString().equals("/*-{") || !tok.subSequence(l - 4, l).toString().equals("}-*/")) continue block6;
                    return ts.offsetToken();
                }
            }
            break;
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_JSNI2JavaScriptBody();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            Token jsniComment = JSNI2JavaScriptBody.findBlockToken((CompilationInfo)ctx.getWorkingCopy(), ctx.getPath(), null);
            if (jsniComment == null) {
                return;
            }
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            MethodTree mt = (MethodTree)ctx.getPath().getLeaf();
            ArrayList<LiteralTree> params = new ArrayList<LiteralTree>();
            for (VariableTree variableTree : mt.getParameters()) {
                params.add(make.Literal((Object)variableTree.getName().toString()));
            }
            String body = jsniComment.text().toString().replace("\"", "\\\"");
            body = body.replace("/*-{", "").replace("}-*/", "");
            ArrayList<AssignmentTree> arrayList = new ArrayList<AssignmentTree>();
            arrayList.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"args"), (ExpressionTree)make.NewArray(null, Collections.emptyList(), params)));
            if (body.contains("@") && body.contains("::")) {
                arrayList.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"javacall"), (ExpressionTree)make.Literal((Object)true)));
            }
            String[] lines = body.split("\n");
            StringBuilder jsB = new StringBuilder();
            String sep = "\"";
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i < lines.length - 1) {
                    line = line + "\\n";
                }
                jsB.append(sep).append(line).append("\"");
                sep = " + \n\"";
            }
            arrayList.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"body"), (ExpressionTree)make.Identifier((CharSequence)jsB.toString())));
            AnnotationTree jsBody = make.Annotation((Tree)make.QualIdent("net.java.html.js.JavaScriptBody"), arrayList);
            ctx.getWorkingCopy().rewrite((Tree)mt.getModifiers(), (Tree)make.addModifiersAnnotation(mt.getModifiers(), jsBody));
        }
    }
}

