/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DynamicDeviceGroup;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.work.DebugLog;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.tasks.CheckComplianceTask;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class TakeSnapshotTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(TakeSnapshotTask.class);
    private static Set<Long> scheduledAutoSnapshots = new HashSet<Long>();
    private static Set<Long> runningSnapshots = new HashSet<Long>();
    private static boolean AUTOSNAPSHOT_ANYIP = false;
    public static int AUTOSNAPSHOT_INTERVAL = 10;
    private Device device;
    private boolean automatic = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkAutoSnasphot(Long device) {
        Set<Long> set = scheduledAutoSnapshots;
        synchronized (set) {
            return scheduledAutoSnapshots.add(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkRunningSnapshot(Long device) {
        Set<Long> set = runningSnapshots;
        synchronized (set) {
            return runningSnapshots.add(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearScheduledAutoSnapshot(Long device) {
        Set<Long> set = scheduledAutoSnapshots;
        synchronized (set) {
            scheduledAutoSnapshots.remove(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearRunningSnapshot(Long device) {
        Set<Long> set = runningSnapshots;
        synchronized (set) {
            runningSnapshots.remove(device);
        }
    }

    protected TakeSnapshotTask() {
    }

    public TakeSnapshotTask(Device device, String comments, String author) {
        super(comments, device.getLastConfig() == null ? device.getMgmtAddress().getIp() : device.getName(), author);
        this.device = device;
    }

    public TakeSnapshotTask(Device device, String comments, String author, boolean automatic) {
        this(device, comments, author);
        this.automatic = automatic;
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getDevice());
        Hibernate.initialize(this.getDevice().getLastConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Starting snapshot task for device {}.", (Object)this.device.getId());
        this.logIt(String.format("Snapshot task for device %s (%s).", this.device.getName(), this.device.getMgmtAddress().getIp()), 5);
        Session session = Database.getSession();
        try {
            session.beginTransaction();
            session.refresh(this.device);
            if (this.device.getStatus() != Device.Status.INPRODUCTION) {
                logger.trace("Device not INPRODUCTION, stopping the snapshot task.");
                this.logIt("The device is not enabled (not in production).", 2);
                this.status = Task.Status.FAILURE;
                return;
            }
            if (!TakeSnapshotTask.checkRunningSnapshot(this.device.getId())) {
                logger.trace("Snapshot task already ongoing for this device, cancelling.");
                this.logIt("A snapshot task is already running for this device, cancelling this task.", 2);
                this.status = Task.Status.CANCELLED;
                return;
            }
            this.device.takeSnapshot(this.debugEnabled);
            this.logIt(String.format("Device logs (%d next lines):", this.device.getLog().size()), 3);
            this.log.append(this.device.getPlainLog());
            session.update(this.device);
            session.getTransaction().commit();
            this.status = Task.Status.SUCCESS;
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            logger.error("Error while taking the snapshot.", e);
            this.logIt("Error while taking the snapshot: " + e.getMessage(), 3);
            this.logIt(String.format("Device logs (%d next lines):", this.device.getLog().size()), 3);
            this.log.append(this.device.getPlainLog());
            this.status = Task.Status.FAILURE;
            return;
        }
        finally {
            try {
                if (this.debugEnabled) {
                    this.debugLog = new DebugLog(this.device.getPlainSessionDebugLog());
                }
            }
            catch (Exception e1) {
                logger.error("Error while saving the debug logs.", e1);
            }
            TakeSnapshotTask.clearRunningSnapshot(this.device.getId());
            if (this.automatic) {
                TakeSnapshotTask.clearScheduledAutoSnapshot(this.device.getId());
            }
            session.close();
        }
        logger.debug("Request to refresh all the groups for the device after the snapshot.");
        DynamicDeviceGroup.refreshAllGroups(this.device);
        try {
            CheckComplianceTask checkTask = new CheckComplianceTask(this.device, "Check compliance after snapshot.", "Auto");
            TaskManager.addTask(checkTask);
        }
        catch (Exception e) {
            logger.error("Error while registering the new task.", e);
        }
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Device snapshot";
    }

    @ManyToOne(fetch=FetchType.LAZY)
    protected Device getDevice() {
        return this.device;
    }

    protected boolean isAutomatic() {
        return this.automatic;
    }

    protected void setAutomatic(boolean automatic) {
        this.automatic = automatic;
    }

    @XmlElement
    @Transient
    protected long getDeviceId() {
        return this.device.getId();
    }

    protected void setDevice(Device device) {
        this.device = device;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TakeSnapshotTask task = (TakeSnapshotTask)super.clone();
        task.setDevice(this.device);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean scheduleSnapshotIfNeeded(List<String> drivers, Network4Address address) {
        Device device;
        logger.debug("Request to take a snapshot of device with IP {}, if necessary.", (Object)address.getIp());
        try (Session session = Database.getSession();){
            logger.trace("Retrieving the device.");
            device = (Device)session.createQuery("select d from Device d where d.status = :inprod and d.mgmtAddress.address = :ip").setParameter("inprod", (Object)Device.Status.INPRODUCTION).setInteger("ip", address.getAddress()).uniqueResult();
            if (device == null && AUTOSNAPSHOT_ANYIP) {
                logger.warn("No device with such management IP {} in the database. Looking for this address in the interface table.", (Object)address.getIp());
                device = (Device)session.createQuery("select d from Device d join d.networkInterfaces ni join ni.ip4Addresses a where d.status = :inprod and a.address = :ip").setParameter("inprod", (Object)Device.Status.INPRODUCTION).setInteger("ip", address.getAddress()).uniqueResult();
            }
            if (device == null) {
                logger.warn("No device with such IP address {} in the database.", (Object)address.getIp());
                boolean bl = false;
                return bl;
            }
            if (!drivers.contains(device.getDriver())) {
                logger.warn("The driver {} of the device {} in database isn't in the list of drivers asking for a snapshot (address {}).", device.getDriver(), device.getId(), device.getMgmtAddress());
                boolean bl = false;
                return bl;
            }
            if (!TakeSnapshotTask.checkAutoSnasphot(device.getId())) {
                logger.debug("A snapshot task is already scheduled.");
                boolean bl = true;
                return bl;
            }
        }
        try {
            TakeSnapshotTask snapshot = new TakeSnapshotTask(device, "Automatic snapshot after config change", "Auto", true);
            snapshot.schedule(AUTOSNAPSHOT_INTERVAL);
            TaskManager.addTask(snapshot);
        }
        catch (Exception e) {
            logger.error("Error while scheduling the automatic snapshot.", e);
        }
        return true;
    }

    @Override
    public void onSchedule() {
        if (this.automatic) {
            TakeSnapshotTask.checkAutoSnasphot(this.device.getId());
        }
    }

    @Override
    public void onCancel() {
        TakeSnapshotTask.clearScheduledAutoSnapshot(this.device.getId());
    }

    static {
        if (Netshot.getConfig("netshot.snapshots.auto.anyip", "false").equals("true")) {
            AUTOSNAPSHOT_ANYIP = true;
        }
        try {
            int interval = Integer.parseInt(Netshot.getConfig("netshot.snapshots.auto.interval", "10"));
            if (interval < 1) {
                throw new Exception();
            }
            AUTOSNAPSHOT_INTERVAL = interval;
        }
        catch (Exception e) {
            logger.error("Invalid value for netshot.snapshots.auto.interval in the configuration file. Using default of {} minutes.", (Object)AUTOSNAPSHOT_INTERVAL);
        }
    }
}

