/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.1lf, -1.2lf) - dvec2(-0.1lf, -1.2lf)) => dvec2(0.0lf, 0.0lf)
 * (dvec2(-0.1lf, -1.2lf) - dvec2(-0.42lf, 0.48lf)) => dvec2(0.31999999999999995lf, -1.68lf)
 * (dvec2(-0.42lf, 0.48lf) - dvec2(-0.1lf, -1.2lf)) => dvec2(-0.31999999999999995lf, 1.68lf)
 * (dvec2(-0.42lf, 0.48lf) - dvec2(-0.42lf, 0.48lf)) => dvec2(0.0lf, 0.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.1lf, -1.2lf) - dvec2(-0.1lf, -1.2lf)), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((dvec2(-0.1lf, -1.2lf) - dvec2(-0.42lf, 0.48lf)), dvec2(0.31999999999999995lf, -1.68lf)) <= 1.7102046661145562e-05lf ? 1 : -1] array1;
  double[distance((dvec2(-0.42lf, 0.48lf) - dvec2(-0.1lf, -1.2lf)), dvec2(-0.31999999999999995lf, 1.68lf)) <= 1.7102046661145562e-05lf ? 1 : -1] array2;
  double[distance((dvec2(-0.42lf, 0.48lf) - dvec2(-0.42lf, 0.48lf)), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
