/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;

public class SelectBranchPopup {
    private static final String CONFIGURE_MESSAGE = SvnBundle.message("configure.branches.item", new Object[0]);

    private SelectBranchPopup() {
    }

    public static void show(@NotNull Project project, @NotNull VirtualFile file, @NotNull BranchSelectedCallback callback, @Nullable String title) {
        if (project == null) {
            SelectBranchPopup.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SelectBranchPopup.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            SelectBranchPopup.$$$reportNull$$$0(2);
        }
        SelectBranchPopup.show(project, file, callback, title, null);
    }

    public static void show(@NotNull Project project, @NotNull VirtualFile file, @NotNull BranchSelectedCallback callback, @Nullable String title, @Nullable Component component) {
        RootUrlInfo rootUrlInfo;
        SvnFileUrlMapping urlMapping;
        Url svnurl;
        if (project == null) {
            SelectBranchPopup.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SelectBranchPopup.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            SelectBranchPopup.$$$reportNull$$$0(5);
        }
        if ((svnurl = (urlMapping = SvnVcs.getInstance(project).getSvnFileUrlMapping()).getUrlForFile(VfsUtilCore.virtualToIoFile((VirtualFile)file))) != null && (rootUrlInfo = urlMapping.getWcRootForUrl(svnurl)) != null) {
            SelectBranchPopup.showForBranchRoot(project, rootUrlInfo.getVirtualFile(), callback, title, component);
        }
    }

    public static void showForBranchRoot(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull BranchSelectedCallback callback, @Nullable String title) {
        if (project == null) {
            SelectBranchPopup.$$$reportNull$$$0(6);
        }
        if (vcsRoot == null) {
            SelectBranchPopup.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            SelectBranchPopup.$$$reportNull$$$0(8);
        }
        SelectBranchPopup.showForBranchRoot(project, vcsRoot, callback, title, null);
    }

    public static void showForBranchRoot(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull BranchSelectedCallback callback, @Nullable String title, @Nullable Component component) {
        if (project == null) {
            SelectBranchPopup.$$$reportNull$$$0(9);
        }
        if (vcsRoot == null) {
            SelectBranchPopup.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            SelectBranchPopup.$$$reportNull$$$0(11);
        }
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(project).get(vcsRoot);
        ArrayList<Object> items = new ArrayList<Object>();
        ContainerUtil.addIfNotNull(items, (Object)configuration.getTrunk());
        items.addAll(configuration.getBranchLocations());
        items.add(CONFIGURE_MESSAGE);
        BranchBasesPopupStep step = new BranchBasesPopupStep(project, vcsRoot, configuration, callback, items, title, component);
        step.showPopupAt((JBPopup)JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
    }

    @NotNull
    private static String getBranchName(@NotNull SvnBranchItem branch) {
        if (branch == null) {
            SelectBranchPopup.$$$reportNull$$$0(12);
        }
        String string = branch.getUrl().getTail();
        if (string == null) {
            SelectBranchPopup.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showForBranchRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBranchName";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BranchRenderer
    extends JPanel
    implements ListCellRenderer<Object> {
        private final JLabel myUrlLabel = new JLabel();
        private final JLabel myDateLabel = new JLabel();

        BranchRenderer() {
            super(new BorderLayout());
            this.add((Component)this.myUrlLabel, "West");
            this.add((Component)this.myDateLabel, "East");
            this.myUrlLabel.setBorder(JBUI.Borders.empty((int)1));
            this.myDateLabel.setHorizontalAlignment(4);
            this.myDateLabel.setBorder(JBUI.Borders.empty((int)1));
            this.myDateLabel.setForeground(UIUtil.getInactiveTextColor());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(UIUtil.getListSelectionBackground());
                Color selectedForegroundColor = UIUtil.getListSelectionForeground();
                this.myUrlLabel.setForeground(selectedForegroundColor);
                this.myDateLabel.setForeground(selectedForegroundColor);
                this.setForeground(selectedForegroundColor);
            } else {
                this.setBackground(UIUtil.getListBackground());
                Color foregroundColor = UIUtil.getListForeground();
                this.myUrlLabel.setForeground(foregroundColor);
                this.myDateLabel.setForeground(UIUtil.getInactiveTextColor());
                this.setForeground(foregroundColor);
            }
            if (value instanceof String) {
                this.myUrlLabel.setText((String)value);
                this.myDateLabel.setText("");
            } else {
                SvnBranchItem item = (SvnBranchItem)value;
                this.myUrlLabel.setText(SelectBranchPopup.getBranchName(item));
                long creationMillis = item.getCreationDateMillis();
                this.myDateLabel.setText(creationMillis > 0L ? DateFormatUtil.formatDate((long)creationMillis) : "");
            }
            return this;
        }
    }

    private static class BranchBasesPopupStep
    extends BaseListPopupStep<Object> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myVcsRoot;
        @NotNull
        private final SvnBranchConfigurationNew myConfiguration;
        @NotNull
        private final BranchSelectedCallback myCallback;
        @Nullable
        private final Component myComponent;
        private static final String REFRESH_MESSAGE = SvnBundle.message("refresh.branches.item", new Object[0]);

        BranchBasesPopupStep(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull SvnBranchConfigurationNew configuration, @NotNull BranchSelectedCallback callback, @NotNull List<Object> items, @Nullable String title, @Nullable Component component) {
            if (project == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(0);
            }
            if (vcsRoot == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(2);
            }
            if (callback == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(3);
            }
            if (items == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(4);
            }
            this.myProject = project;
            this.myVcsRoot = vcsRoot;
            this.myConfiguration = configuration;
            this.myCallback = callback;
            this.myComponent = component;
            this.init(title, items, null);
        }

        public ListSeparator getSeparatorAbove(Object value) {
            return CONFIGURE_MESSAGE.equals(value) ? new ListSeparator("") : null;
        }

        @NotNull
        public String getTextFor(@NotNull Object value) {
            if (value == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(5);
            }
            if (value instanceof Url) {
                Url url = (Url)value;
                String suffix = url.equals(this.myConfiguration.getTrunk()) ? " (trunk)" : "...";
                String string = url.getTail() + suffix;
                if (string == null) {
                    BranchBasesPopupStep.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = String.valueOf(value);
            if (string == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(7);
            }
            return string;
        }

        public PopupStep onChosen(Object selectedValue, boolean finalChoice) {
            if (CONFIGURE_MESSAGE.equals(selectedValue)) {
                return this.doFinalStep(() -> BranchConfigurationDialog.configureBranches(this.myProject, this.myVcsRoot));
            }
            Url url = (Url)selectedValue;
            if (url.equals(this.myConfiguration.getTrunk())) {
                return this.doFinalStep(() -> this.myCallback.branchSelected(this.myProject, this.myConfiguration, url, -1L));
            }
            return this.doFinalStep(() -> this.showBranchPopup(url));
        }

        private void loadBranches(final @NotNull Url branchLocation, final @NotNull Runnable runnable) {
            if (branchLocation == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(8);
            }
            if (runnable == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(9);
            }
            new Task.Backgroundable(this.myProject, SvnBundle.message("compare.with.branch.progress.loading.branches", new Object[0]), true){

                public void onFinished() {
                    runnable.run();
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NewRootBunch manager = SvnBranchConfigurationManager.getInstance(this.myProject).getSvnBranchConfigManager();
                    manager.reloadBranches(myVcsRoot, branchLocation, InfoReliability.setByUser, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep$1", "run"));
                }
            }.queue();
        }

        private void showBranchPopup(@NotNull Url branchLocation) {
            if (branchLocation == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(10);
            }
            List<SvnBranchItem> branches = this.myConfiguration.getBranches(branchLocation);
            ArrayList<SvnBranchItem> items = new ArrayList<SvnBranchItem>(branches);
            items.add((SvnBranchItem)((Object)REFRESH_MESSAGE));
            JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(items).setTitle(branchLocation.getTail()).setRenderer((ListCellRenderer)new BranchRenderer()).setResizable(true).setItemChosenCallback(v -> {
                if (branchLocation == null) {
                    BranchBasesPopupStep.$$$reportNull$$$0(12);
                }
                if (REFRESH_MESSAGE.equals(v)) {
                    this.loadBranches(branchLocation, () -> {
                        if (branchLocation == null) {
                            BranchBasesPopupStep.$$$reportNull$$$0(13);
                        }
                        this.showBranchPopup(branchLocation);
                    });
                    return;
                }
                SvnBranchItem item = (SvnBranchItem)v;
                if (item != null) {
                    this.myCallback.branchSelected(this.myProject, this.myConfiguration, item.getUrl(), item.getRevision());
                }
            }).setNamerForFiltering(item -> item instanceof SvnBranchItem ? SelectBranchPopup.getBranchName((SvnBranchItem)item) : null).createPopup();
            this.showPopupAt(popup);
        }

        public void showPopupAt(@NotNull JBPopup listPopup) {
            if (listPopup == null) {
                BranchBasesPopupStep.$$$reportNull$$$0(11);
            }
            if (this.myComponent == null) {
                listPopup.showCenteredInCurrentWindow(this.myProject);
            } else {
                listPopup.showInCenterOf(this.myComponent);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsRoot";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep";
                    break;
                }
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchLocation";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getTextFor";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "loadBranches";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "showBranchPopup";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "showPopupAt";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$showBranchPopup$4";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface BranchSelectedCallback {
        public void branchSelected(Project var1, SvnBranchConfigurationNew var2, @NotNull Url var3, long var4);
    }
}

