/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeUtil;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnalysisActionUtils {
    private static AnalysisScope getFileScopeFromInspectionView(DataContext dataContext) {
        AnalysisScope scope;
        int type;
        InspectionResultsView inspectionView = (InspectionResultsView)dataContext.getData(InspectionResultsView.DATA_KEY);
        if (inspectionView != null && (type = (scope = inspectionView.getScope()).getScopeType()) != 4 && type != 1 && scope.isValid()) {
            return scope;
        }
        return null;
    }

    @Nullable
    public static AnalysisScope getInspectionScope(@NotNull DataContext dataContext, @NotNull Project project, Boolean acceptNonProjectDirectories) {
        AnalysisScope scope;
        if (dataContext == null) {
            AnalysisActionUtils.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AnalysisActionUtils.$$$reportNull$$$0(1);
        }
        if ((scope = AnalysisActionUtils.getFileScopeFromInspectionView(dataContext)) != null) {
            return scope;
        }
        scope = AnalysisActionUtils.getInspectionScopeImpl(dataContext, project, acceptNonProjectDirectories);
        return scope.getScopeType() != 6 ? scope : null;
    }

    @NotNull
    private static AnalysisScope getInspectionScopeImpl(@NotNull DataContext dataContext, @NotNull Project project, Boolean acceptNonProjectDirectories) {
        Project projectContext;
        if (dataContext == null) {
            AnalysisActionUtils.$$$reportNull$$$0(2);
        }
        if (project == null) {
            AnalysisActionUtils.$$$reportNull$$$0(3);
        }
        if ((projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext)) != null) {
            AnalysisScope analysisScope = new AnalysisScope(projectContext);
            if (analysisScope == null) {
                AnalysisActionUtils.$$$reportNull$$$0(4);
            }
            return analysisScope;
        }
        AnalysisScope analysisScope = (AnalysisScope)AnalysisScopeUtil.KEY.getData(dataContext);
        if (analysisScope != null) {
            AnalysisScope analysisScope2 = analysisScope;
            if (analysisScope2 == null) {
                AnalysisActionUtils.$$$reportNull$$$0(5);
            }
            return analysisScope2;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null && psiFile.getManager().isInProject((PsiElement)psiFile)) {
            PsiDirectory psiDirectory;
            VirtualFile jarRoot;
            VirtualFile file2 = psiFile.getVirtualFile();
            if (file2 != null && file2.isValid() && file2.getFileType() instanceof ArchiveFileType && acceptNonProjectDirectories.booleanValue() && (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(file2)) != null && (psiDirectory = psiFile.getManager().findDirectory(jarRoot)) != null) {
                AnalysisScope analysisScope3 = new AnalysisScope(psiDirectory);
                if (analysisScope3 == null) {
                    AnalysisActionUtils.$$$reportNull$$$0(6);
                }
                return analysisScope3;
            }
            AnalysisScope analysisScope4 = new AnalysisScope(psiFile);
            if (analysisScope4 == null) {
                AnalysisActionUtils.$$$reportNull$$$0(7);
            }
            return analysisScope4;
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles != null) {
            PsiDirectory psiDirectory;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            if (virtualFiles.length == 1 && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFiles[0])) != null && (acceptNonProjectDirectories.booleanValue() || psiDirectory.getManager().isInProject((PsiElement)psiDirectory))) {
                AnalysisScope analysisScope5 = new AnalysisScope(psiDirectory);
                if (analysisScope5 == null) {
                    AnalysisActionUtils.$$$reportNull$$$0(8);
                }
                return analysisScope5;
            }
            HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
            for (VirtualFile vFile : virtualFiles) {
                if (!fileIndex.isInContent(vFile)) continue;
                files2.add(vFile);
            }
            AnalysisScope analysisScope6 = new AnalysisScope(project, files2);
            if (analysisScope6 == null) {
                AnalysisActionUtils.$$$reportNull$$$0(9);
            }
            return analysisScope6;
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (moduleContext != null) {
            AnalysisScope analysisScope7 = new AnalysisScope(moduleContext);
            if (analysisScope7 == null) {
                AnalysisActionUtils.$$$reportNull$$$0(10);
            }
            return analysisScope7;
        }
        Module[] modulesArray = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modulesArray != null) {
            AnalysisScope analysisScope8 = new AnalysisScope(modulesArray);
            if (analysisScope8 == null) {
                AnalysisActionUtils.$$$reportNull$$$0(11);
            }
            return analysisScope8;
        }
        AnalysisScope analysisScope9 = new AnalysisScope(project);
        if (analysisScope9 == null) {
            AnalysisActionUtils.$$$reportNull$$$0(12);
        }
        return analysisScope9;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/AnalysisActionUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/AnalysisActionUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionScopeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionScopeImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

