/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ChangeLocalityDetector;
import com.intellij.codeInsight.daemon.impl.DefaultChangeLocalityDetector;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiChangeHandler
extends PsiTreeChangeAdapter
implements Disposable {
    private static final ExtensionPointName<ChangeLocalityDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.daemon.changeLocalityDetector");
    private final Key<Boolean> UPDATE_ON_COMMIT_ENGAGED;
    private final Project myProject;
    private final Map<Document, List<Pair<PsiElement, Boolean>>> changedElements;
    private final FileStatusMap myFileStatusMap;

    PsiChangeHandler(@NotNull Project project, final @NotNull PsiDocumentManagerImpl documentManager, @NotNull EditorFactory editorFactory, @NotNull MessageBusConnection connection, @NotNull FileStatusMap fileStatusMap) {
        if (project == null) {
            PsiChangeHandler.$$$reportNull$$$0(0);
        }
        if (documentManager == null) {
            PsiChangeHandler.$$$reportNull$$$0(1);
        }
        if (editorFactory == null) {
            PsiChangeHandler.$$$reportNull$$$0(2);
        }
        if (connection == null) {
            PsiChangeHandler.$$$reportNull$$$0(3);
        }
        if (fileStatusMap == null) {
            PsiChangeHandler.$$$reportNull$$$0(4);
        }
        this.UPDATE_ON_COMMIT_ENGAGED = Key.create((String)"UPDATE_ON_COMMIT_ENGAGED");
        this.changedElements = ContainerUtil.createWeakMap();
        this.myProject = project;
        this.myFileStatusMap = fileStatusMap;
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Document document = e.getDocument();
                if (documentManager.getSynchronizer().isInSynchronization(document)) {
                    return;
                }
                if (documentManager.getCachedPsiFile(document) == null) {
                    return;
                }
                if (document.getUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED) == null) {
                    document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, (Object)Boolean.TRUE);
                    PsiDocumentManagerBase.addRunOnCommit(document, () -> {
                        if (document.getUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED) != null) {
                            PsiChangeHandler.this.updateChangesForDocument(document);
                            document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, null);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler$1", "beforeDocumentChange"));
            }
        }, (Disposable)this);
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void transactionCompleted(@NotNull Document document, @NotNull PsiFile file2) {
                if (document == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                PsiChangeHandler.this.updateChangesForDocument(document);
                document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "doc";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiChangeHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionStarted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
    }

    private void updateChangesForDocument(@NotNull Document document) {
        if (document == null) {
            PsiChangeHandler.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        List<Pair<PsiElement, Boolean>> toUpdate = this.changedElements.get(document);
        if (toUpdate == null) {
            if (UpdateHighlightersUtil.isWhitespaceOptimizationAllowed(document)) {
                return;
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
            if (file2 == null) {
                return;
            }
            toUpdate = Collections.singletonList(Pair.create((Object)file2, (Object)true));
        }
        Application application = ApplicationManager.getApplication();
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor != null && !application.isUnitTestMode()) {
            application.invokeLater(() -> {
                if (!editor.isDisposed()) {
                    EditorMarkupModel markupModel = (EditorMarkupModel)editor.getMarkupModel();
                    PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                    ErrorStripeUpdateManager.getInstance(this.myProject).setOrRefreshErrorStripeRenderer(markupModel, file2);
                }
            }, ModalityState.stateForComponent((Component)editor.getComponent()), this.myProject.getDisposed());
        }
        for (Pair<PsiElement, Boolean> changedElement : toUpdate) {
            PsiElement element = (PsiElement)changedElement.getFirst();
            Boolean whiteSpaceOptimizationAllowed = (Boolean)changedElement.getSecond();
            this.updateByChange(element, document, whiteSpaceOptimizationAllowed);
        }
        this.changedElements.remove(document);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(6);
        }
        this.queueElement(event.getParent(), true, event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(7);
        }
        this.queueElement(event.getParent(), true, event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(8);
        }
        this.queueElement(event.getNewChild(), PsiChangeHandler.typesEqual(event.getNewChild(), event.getOldChild()), event);
    }

    private static boolean typesEqual(PsiElement newChild, PsiElement oldChild) {
        return newChild != null && oldChild != null && newChild.getClass() == oldChild.getClass();
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(9);
        }
        if (((PsiTreeChangeEventImpl)event).isGenericChange()) {
            return;
        }
        this.queueElement(event.getParent(), true, event);
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(10);
        }
        this.queueElement(event.getOldParent(), true, event);
        this.queueElement(event.getNewParent(), true, event);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(11);
        }
        if ((psiFile = event.getFile()) != null) {
            this.myFileStatusMap.markFileScopeDirtyDefensively(psiFile, event);
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        String propertyName;
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(12);
        }
        if (!(propertyName = event.getPropertyName()).equals("writable")) {
            Object oldValue = event.getOldValue();
            if (oldValue instanceof VirtualFile && this.shouldBeIgnored((VirtualFile)oldValue)) {
                return;
            }
            this.myFileStatusMap.markAllFilesDirty(event);
        }
    }

    private void queueElement(@NotNull PsiElement child2, boolean whitespaceOptimizationAllowed, @NotNull PsiTreeChangeEvent event) {
        if (child2 == null) {
            PsiChangeHandler.$$$reportNull$$$0(13);
        }
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile file2 = event.getFile();
        if (file2 == null) {
            file2 = child2.getContainingFile();
        }
        if (file2 == null) {
            this.myFileStatusMap.markAllFilesDirty(child2);
            return;
        }
        if (!child2.isValid()) {
            return;
        }
        PsiDocumentManagerImpl pdm = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = pdm.getCachedDocument(file2);
        if (document != null) {
            if (pdm.getSynchronizer().getTransaction(document) == null) {
                this.myFileStatusMap.markAllFilesDirty(child2);
                return;
            }
            SmartList toUpdate = this.changedElements.get(document);
            if (toUpdate == null) {
                toUpdate = new SmartList();
                this.changedElements.put(document, (List<Pair<PsiElement, Boolean>>)toUpdate);
            }
            toUpdate.add(Pair.create((Object)child2, (Object)whitespaceOptimizationAllowed));
        }
    }

    private void updateByChange(@NotNull PsiElement child2, @NotNull Document document, boolean whitespaceOptimizationAllowed) {
        PsiElement element;
        PsiFile file2;
        if (child2 == null) {
            PsiChangeHandler.$$$reportNull$$$0(15);
        }
        if (document == null) {
            PsiChangeHandler.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            file2 = child2.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            this.myFileStatusMap.markAllFilesDirty((Object)e);
            return;
        }
        if (file2 == null || file2 instanceof PsiCompiledElement) {
            this.myFileStatusMap.markAllFilesDirty(child2);
            return;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null && this.shouldBeIgnored(virtualFile)) {
            return;
        }
        int fileLength = file2.getTextLength();
        if (!file2.getViewProvider().isPhysical()) {
            this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, fileLength), fileLength, "Non-physical file update: " + file2);
            return;
        }
        PsiElement psiElement = element = whitespaceOptimizationAllowed && UpdateHighlightersUtil.isWhitespaceOptimizationAllowed(document) ? child2 : child2.getParent();
        while (true) {
            if (element == null || element instanceof PsiFile || element instanceof PsiDirectory) {
                this.myFileStatusMap.markAllFilesDirty("Top element: " + element);
                return;
            }
            PsiElement scope = PsiChangeHandler.getChangeHighlightingScope(element);
            if (scope != null) {
                this.myFileStatusMap.markFileScopeDirty(document, scope.getTextRange(), fileLength, "Scope: " + scope);
                return;
            }
            element = element.getParent();
        }
    }

    private boolean shouldBeIgnored(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PsiChangeHandler.$$$reportNull$$$0(17);
        }
        return ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile) || ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isExcluded(virtualFile);
    }

    @Nullable
    private static PsiElement getChangeHighlightingScope(@NotNull PsiElement element) {
        if (element == null) {
            PsiChangeHandler.$$$reportNull$$$0(18);
        }
        DefaultChangeLocalityDetector defaultDetector = null;
        for (ChangeLocalityDetector detector : EP_NAME.getExtensionList()) {
            if (detector instanceof DefaultChangeLocalityDetector) {
                assert (defaultDetector == null) : defaultDetector;
                defaultDetector = (DefaultChangeLocalityDetector)detector;
                continue;
            }
            PsiElement scope = detector.getChangeHighlightingDirtyScopeFor(element);
            if (scope == null) continue;
            return scope;
        }
        assert (defaultDetector != null) : "com.intellij.codeInsight.daemon.impl.DefaultChangeLocalityDetector is unregistered";
        return defaultDetector.getChangeHighlightingDirtyScopeFor(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatusMap";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiChangeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateChangesForDocument";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildMovement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildrenChange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "queueElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "updateByChange";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBeIgnored";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getChangeHighlightingScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

