/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameElementFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(RenameElementFix.class);
    private final String myNewName;
    private final String myText;

    public RenameElementFix(@NotNull PsiNamedElement element) {
        if (element == null) {
            RenameElementFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        assert (vFile != null) : element;
        this.myNewName = vFile.getNameWithoutExtension();
        this.myText = CodeInsightBundle.message((String)"rename.public.class.text", (Object[])new Object[]{element.getName(), this.myNewName});
    }

    public RenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName) {
        if (element == null) {
            RenameElementFix.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            RenameElementFix.$$$reportNull$$$0(2);
        }
        this(element, newName, CodeInsightBundle.message((String)"rename.named.element.text", (Object[])new Object[]{element.getName(), newName}));
    }

    public RenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName, @NotNull String text) {
        if (element == null) {
            RenameElementFix.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            RenameElementFix.$$$reportNull$$$0(4);
        }
        if (text == null) {
            RenameElementFix.$$$reportNull$$$0(5);
        }
        super((PsiElement)element);
        this.myNewName = newName;
        this.myText = text;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            RenameElementFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"rename.element.family", (Object[])new Object[0]);
        if (string == null) {
            RenameElementFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            RenameElementFix.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            RenameElementFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            RenameElementFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            RenameElementFix.$$$reportNull$$$0(11);
        }
        if (this.isAvailable(project, null, file2)) {
            LOG.assertTrue(file2 == startElement.getContainingFile());
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            RenameProcessor processor2 = new RenameProcessor(project, startElement, this.myNewName, false, false);
            processor2.run();
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            RenameElementFix.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            RenameElementFix.$$$reportNull$$$0(13);
        }
        if (startElement == null) {
            RenameElementFix.$$$reportNull$$$0(14);
        }
        if (endElement == null) {
            RenameElementFix.$$$reportNull$$$0(15);
        }
        return RenameUtil.isValidName(project, startElement, this.myNewName);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

