/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.io.PrintStream;
import java.util.List;

public class FormattingModelDumper {
    private FormattingModelDumper() {
    }

    public static void dumpFormattingModel(Block block, int indent, PrintStream stream) {
        StringBuilder builder2 = new StringBuilder();
        FormattingModelDumper.dumpFormattingModel(block, indent, builder2);
        stream.print(builder2.toString());
    }

    public static String dumpFormattingModelToString(Block block) {
        StringBuilder builder2 = new StringBuilder();
        FormattingModelDumper.dumpFormattingModel(block, 0, builder2);
        return builder2.toString();
    }

    public static void dumpFormattingModel(Block block, int indent, StringBuilder builder2) {
        if (indent == 0) {
            builder2.append("--- FORMATTING MODEL ---\n");
        }
        builder2.append(StringUtil.repeatSymbol((char)' ', (int)indent));
        List subBlocks = block.getSubBlocks();
        if (subBlocks.isEmpty()) {
            FormattingModelDumper.dumpTextBlock(block, builder2);
        } else {
            FormattingModelDumper.dumpBlock(block, builder2);
            Block prevBlock = null;
            for (Block subBlock : subBlocks) {
                Spacing spacing;
                if (prevBlock != null && (spacing = block.getSpacing(prevBlock, subBlock)) != null) {
                    FormattingModelDumper.dumpSpacing(spacing, indent + 2, builder2);
                }
                prevBlock = subBlock;
                FormattingModelDumper.dumpFormattingModel(subBlock, indent + 2, builder2);
            }
        }
    }

    private static void dumpTextBlock(Block block, StringBuilder builder2) {
        builder2.append("\"").append(FormattingModelDumper.getBlockText(block)).append("\"");
        FormattingModelDumper.dumpBlockProperties(block, builder2);
        builder2.append("\n");
    }

    private static String getBlockText(Block block) {
        if (block instanceof ASTBlock && ((ASTBlock)block).getNode() != null) {
            return ((ASTBlock)block).getNode().getText();
        }
        return "unknown block " + block.getClass();
    }

    private static void dumpBlock(Block block, StringBuilder builder2) {
        builder2.append("<block ");
        if (block instanceof ASTBlock && ((ASTBlock)block).getNode() != null) {
            builder2.append(((ASTBlock)block).getNode().getElementType());
        } else {
            builder2.append(block.getClass().getSimpleName());
        }
        FormattingModelDumper.dumpBlockProperties(block, builder2);
        builder2.append(">\n");
    }

    private static void dumpBlockProperties(Block block, StringBuilder blockData) {
        Alignment alignment;
        Indent indent;
        TextRange textRange = block.getTextRange();
        blockData.append(" ").append(textRange.getStartOffset()).append(":").append(textRange.getEndOffset());
        Wrap wrap = block.getWrap();
        if (wrap != null) {
            blockData.append(" ").append(wrap);
        }
        if ((indent = block.getIndent()) != null) {
            blockData.append(" ").append(indent);
        }
        if ((alignment = block.getAlignment()) != null) {
            blockData.append(" ").append(alignment);
        }
    }

    private static void dumpSpacing(Spacing spacing, int indent, StringBuilder out) {
        out.append(StringUtil.repeatSymbol((char)' ', (int)indent));
        out.append("spacing: ").append(spacing).append("\n");
    }
}

