/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyStringConcatenationToFormatIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.string.concatenation.to.format", new Object[0]);
        if (string == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyBinaryExpression.class, (boolean)false);
        if (element == null) {
            return false;
        }
        while (element.getParent() instanceof PyBinaryExpression) {
            element = element.getParent();
        }
        Collection<PyElementType> operators = PyStringConcatenationToFormatIntention.getOperators((PyBinaryExpression)element);
        for (PyElementType operator : operators) {
            if (operator == PyTokenTypes.PLUS) continue;
            return false;
        }
        Collection<PyExpression> expressions = PyStringConcatenationToFormatIntention.getSimpleExpressions((PyBinaryExpression)element);
        if (expressions.size() == 0) {
            return false;
        }
        PyBuiltinCache cache2 = PyBuiltinCache.getInstance(element);
        for (PyExpression expression : expressions) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PyStringLiteralExpression) continue;
            PyType type = TypeEvalContext.codeAnalysis(file.getProject(), file).getType(expression);
            boolean isStringReference = PyTypeChecker.match(cache2.getStringType(LanguageLevel.forElement((PsiElement)expression)), type, TypeEvalContext.codeAnalysis(file.getProject(), file)) && type != null;
            if (isStringReference) continue;
            return false;
        }
        if (LanguageLevel.forElement(element).isAtLeast(LanguageLevel.PYTHON27)) {
            this.setText(PyBundle.message("INTN.replace.plus.with.str.format", new Object[0]));
        } else {
            this.setText(PyBundle.message("INTN.replace.plus.with.format.operator", new Object[0]));
        }
        return true;
    }

    private static Collection<PyExpression> getSimpleExpressions(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(2);
        }
        ArrayList<PyExpression> res = new ArrayList<PyExpression>();
        if (expression.getLeftExpression() instanceof PyBinaryExpression) {
            res.addAll(PyStringConcatenationToFormatIntention.getSimpleExpressions((PyBinaryExpression)expression.getLeftExpression()));
        } else {
            res.add(expression.getLeftExpression());
        }
        if (expression.getRightExpression() instanceof PyBinaryExpression) {
            res.addAll(PyStringConcatenationToFormatIntention.getSimpleExpressions((PyBinaryExpression)expression.getRightExpression()));
        } else {
            res.add(expression.getRightExpression());
        }
        return res;
    }

    private static Collection<PyElementType> getOperators(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(3);
        }
        ArrayList<PyElementType> res = new ArrayList<PyElementType>();
        if (expression.getLeftExpression() instanceof PyBinaryExpression) {
            res.addAll(PyStringConcatenationToFormatIntention.getOperators((PyBinaryExpression)expression.getLeftExpression()));
        }
        if (expression.getRightExpression() instanceof PyBinaryExpression) {
            res.addAll(PyStringConcatenationToFormatIntention.getOperators((PyBinaryExpression)expression.getRightExpression()));
        }
        res.add(expression.getOperator());
        return res;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PyBinaryExpression element;
        if (project == null) {
            PyStringConcatenationToFormatIntention.$$$reportNull$$$0(4);
        }
        if ((element = (PyBinaryExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyBinaryExpression.class)) == null) {
            return;
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)element);
        boolean useFormatMethod = languageLevel.isAtLeast(LanguageLevel.PYTHON27);
        NotNullFunction escaper = StringUtil.escaper((boolean)false, (String)"\"'\\");
        StringBuilder stringLiteral = new StringBuilder();
        ArrayList<String> parameters2 = new ArrayList<String>();
        Pair<String, String> quotes = Pair.create((Object)"\"", (Object)"\"");
        boolean quotesDetected = false;
        TypeEvalContext context = TypeEvalContext.userInitiated(file.getProject(), file);
        int paramCount = 0;
        boolean isUnicode = false;
        PyClassTypeImpl unicodeType = PyBuiltinCache.getInstance((PsiElement)element).getObjectType("unicode");
        for (PyExpression expression : PyStringConcatenationToFormatIntention.getSimpleExpressions(element)) {
            if (expression instanceof PyStringLiteralExpression) {
                PyType type = context.getType(expression);
                if (type != null && type.equals(unicodeType)) {
                    isUnicode = true;
                }
                if (!quotesDetected) {
                    quotes = PyStringLiteralUtil.getQuotes(expression.getText());
                    quotesDetected = true;
                }
                String value = ((PyStringLiteralExpression)expression).getStringValue();
                if (!useFormatMethod) {
                    value = value.replace("%", "%%");
                }
                stringLiteral.append((String)escaper.fun((Object)value));
                continue;
            }
            PyStringConcatenationToFormatIntention.addParamToString(stringLiteral, paramCount, useFormatMethod);
            parameters2.add(expression.getText());
            ++paramCount;
        }
        if (quotes == null) {
            quotes = Pair.create((Object)"\"", (Object)"\"");
        }
        stringLiteral.insert(0, (String)quotes.getFirst());
        if (isUnicode && !((String)quotes.getFirst()).toLowerCase().contains("u")) {
            stringLiteral.insert(0, "u");
        }
        stringLiteral.append((String)quotes.getSecond());
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (!parameters2.isEmpty()) {
            PyExpression expression;
            if (useFormatMethod) {
                stringLiteral.append(".format(").append(StringUtil.join(parameters2, (String)",")).append(")");
            } else {
                String paramString = parameters2.size() > 1 ? "(" + StringUtil.join(parameters2, (String)",") + ")" : StringUtil.join(parameters2, (String)",");
                stringLiteral.append(" % ").append(paramString);
            }
            expression = elementGenerator.createFromText(LanguageLevel.getDefault(), PyExpressionStatement.class, stringLiteral.toString()).getExpression();
            element.replace((PsiElement)expression);
        } else {
            PyStringLiteralExpression stringLiteralExpression = elementGenerator.createStringLiteralAlreadyEscaped(stringLiteral.toString());
            element.replace(stringLiteralExpression);
        }
    }

    private static void addParamToString(StringBuilder stringLiteral, int i, boolean useFormatMethod) {
        if (useFormatMethod) {
            stringLiteral.append("{").append(i).append("}");
        } else {
            stringLiteral.append("%s");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyStringConcatenationToFormatIntention";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyStringConcatenationToFormatIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleExpressions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOperators";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

