/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.override;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.override.PyMethodMember;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyOverrideImplementUtil {
    @Nullable
    public static PyClass getContextClass(@NotNull Editor editor, @NotNull PsiFile file) {
        PyClass pyClass;
        PsiElement lastChild;
        int offset;
        PsiElement element;
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(1);
        }
        if ((element = file.findElementAt(offset = editor.getCaretModel().getOffset())) == null && (lastChild = file.getLastChild()) != null && offset >= lastChild.getTextRange().getStartOffset() && offset <= lastChild.getTextRange().getEndOffset()) {
            element = lastChild;
        }
        if ((pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false)) == null && element instanceof PsiWhiteSpace && element.getPrevSibling() instanceof PyClass) {
            return (PyClass)element.getPrevSibling();
        }
        return pyClass;
    }

    public static void chooseAndOverrideMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(3);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(5);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        PyPsiUtils.assertValid((PsiElement)cls);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, cls, PyOverrideImplementUtil.getAllSuperMethods(cls, context), false);
    }

    public static void chooseAndImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(7);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(9);
        }
        PyOverrideImplementUtil.chooseAndImplementMethods(project, editor, cls, PyOverrideImplementUtil.getAllSuperAbstractMethods(cls, context));
    }

    public static void chooseAndImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PyClass cls, @NotNull Collection<PyFunction> methods) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(11);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(12);
        }
        if (methods == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(13);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        PyPsiUtils.assertValid((PsiElement)cls);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, cls, methods, true);
    }

    private static void chooseAndOverrideOrImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PyClass cls, @NotNull Collection<PyFunction> methods, boolean implement) {
        if (project == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(15);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(16);
        }
        if (methods == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(17);
        }
        ArrayList<PyMethodMember> elements = new ArrayList<PyMethodMember>();
        for (PyFunction method : methods) {
            String name = method.getName();
            if (name == null || PyUtil.isClassPrivateName(name) || cls.findMethodByName(name, false, null) != null) continue;
            PyMethodMember member = new PyMethodMember(method);
            elements.add(member);
        }
        if (elements.isEmpty()) {
            return;
        }
        MemberChooser chooser = new MemberChooser((ClassMember[])elements.toArray(new PyMethodMember[0]), false, true, project);
        chooser.setTitle(implement ? "Select Methods to Implement" : "Select Methods to Override");
        chooser.setCopyJavadocVisible(false);
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return;
        }
        PyOverrideImplementUtil.overrideMethods(editor, cls, chooser.getSelectedElements(), implement);
    }

    public static void overrideMethods(Editor editor, PyClass pyClass, List<PyMethodMember> membersToOverride, boolean implement) {
        if (membersToOverride == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)pyClass.getProject(), (PsiFile[])new PsiFile[]{pyClass.getContainingFile()}).run(() -> PyOverrideImplementUtil.write(pyClass, membersToOverride, editor, implement));
    }

    private static void write(@NotNull PyClass pyClass, @NotNull List<PyMethodMember> newMembers, @NotNull Editor editor, boolean implement) {
        if (pyClass == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(18);
        }
        if (newMembers == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(20);
        }
        PyStatementList statementList = pyClass.getStatementList();
        int offset = editor.getCaretModel().getOffset();
        PyStatement anchor = null;
        for (PyStatement statement : statementList.getStatements()) {
            if (statement.getTextRange().getStartOffset() >= offset && (!(statement instanceof PyExpressionStatement) || !(((PyExpressionStatement)statement).getExpression() instanceof PyStringLiteralExpression))) continue;
            anchor = statement;
        }
        PyFunction element = null;
        for (PyMethodMember newMember : Lists.reverse(newMembers)) {
            element = PyOverrideImplementUtil.writeMember(pyClass, (PyFunction)newMember.getPsiElement(), (PsiElement)anchor, implement);
        }
        PyPsiUtils.removeRedundantPass(statementList);
        if (element != null) {
            PyStatementList targetStatementList = element.getStatementList();
            int start = targetStatementList.getTextRange().getStartOffset();
            editor.getCaretModel().moveToOffset(start);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(start, element.getTextRange().getEndOffset());
        }
    }

    @Nullable
    private static PyFunction writeMember(@NotNull PyClass cls, @NotNull PyFunction baseFunction, @Nullable PsiElement anchor, boolean implement) {
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(21);
        }
        if (baseFunction == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(22);
        }
        PyStatementList statementList = cls.getStatementList();
        TypeEvalContext context = TypeEvalContext.userInitiated(cls.getProject(), cls.getContainingFile());
        PyFunction function = PyOverrideImplementUtil.buildOverriddenFunction(cls, baseFunction, implement).addFunctionAfter((PsiElement)statementList, anchor);
        PyOverrideImplementUtil.addImports(baseFunction, function, context);
        PyiUtil.getOverloads(baseFunction, context).forEach(baseOverload -> {
            PyFunction overload = (PyFunction)statementList.addBefore((PsiElement)baseOverload, function);
            PyOverrideImplementUtil.addImports(baseOverload, overload, context);
        });
        return (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)function);
    }

    private static PyFunctionBuilder buildOverriddenFunction(PyClass pyClass, PyFunction baseFunction, boolean implement) {
        boolean overridingNew = "__new__".equals(baseFunction.getName());
        assert (baseFunction.getName() != null);
        PyFunctionBuilder pyFunctionBuilder = new PyFunctionBuilder(baseFunction.getName(), baseFunction);
        PyDecoratorList decorators = baseFunction.getDecoratorList();
        boolean baseMethodIsStatic = false;
        if (decorators != null) {
            if (decorators.findDecorator("classmethod") != null) {
                pyFunctionBuilder.decorate("classmethod");
            } else if (decorators.findDecorator("staticmethod") != null) {
                baseMethodIsStatic = true;
                pyFunctionBuilder.decorate("staticmethod");
            } else if (decorators.findDecorator("property") != null || decorators.findDecorator("abstractproperty") != null) {
                pyFunctionBuilder.decorate("property");
            }
        }
        LanguageLevel level = LanguageLevel.forElement((PsiElement)pyClass);
        PyAnnotation anno = baseFunction.getAnnotation();
        if (anno != null && !level.isPython2()) {
            pyFunctionBuilder.annotation(anno.getText());
        }
        if (baseFunction.isAsync()) {
            pyFunctionBuilder.makeAsync();
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(baseFunction.getProject(), baseFunction.getContainingFile());
        List baseParams = baseFunction.getParameters(context);
        for (PyCallableParameter parameter : baseParams) {
            PyParameter psi = parameter.getParameter();
            PyNamedParameter namedParameter = PyUtil.as(psi, PyNamedParameter.class);
            if (namedParameter != null) {
                PyExpression defaultValue;
                StringBuilder parameterBuilder = new StringBuilder();
                if (namedParameter.isPositionalContainer()) {
                    parameterBuilder.append("*");
                } else if (namedParameter.isKeywordContainer()) {
                    parameterBuilder.append("**");
                }
                parameterBuilder.append(namedParameter.getName());
                PyAnnotation annotation = namedParameter.getAnnotation();
                if (annotation != null && !level.isPython2()) {
                    parameterBuilder.append(annotation.getText());
                }
                if ((defaultValue = namedParameter.getDefaultValue()) != null) {
                    parameterBuilder.append("=");
                    parameterBuilder.append(defaultValue.getText());
                }
                pyFunctionBuilder.parameter(parameterBuilder.toString());
                continue;
            }
            if (psi == null) continue;
            pyFunctionBuilder.parameter(psi.getText());
        }
        PyClass baseClass = baseFunction.getContainingClass();
        assert (baseClass != null);
        StringBuilder statementBody = new StringBuilder();
        boolean hadStar = false;
        ArrayList<String> parameters2 = new ArrayList<String>();
        for (PyCallableParameter parameter : baseParams) {
            PyParameter psi = parameter.getParameter();
            PyNamedParameter namedParameter = PyUtil.as(psi, PyNamedParameter.class);
            if (namedParameter != null) {
                String repr = namedParameter.getRepr(false);
                parameters2.add(hadStar && !namedParameter.isKeywordContainer() ? namedParameter.getName() + "=" + repr : repr);
                if (!namedParameter.isPositionalContainer()) continue;
                hadStar = true;
                continue;
            }
            if (psi instanceof PySingleStarParameter) {
                hadStar = true;
                continue;
            }
            if (psi == null) continue;
            parameters2.add(psi.getText());
        }
        if (implement || "types.InstanceType".equals(baseClass.getQualifiedName()) || baseFunction.onlyRaisesNotImplementedError() || PyKnownDecoratorUtil.hasAbstractDecorator(baseFunction, context)) {
            statementBody.append("pass");
        } else {
            if (!"__init__".equals(baseFunction.getName()) && context.getReturnType(baseFunction) != PyNoneType.INSTANCE || overridingNew) {
                statementBody.append("return ");
            }
            if (baseFunction.isAsync()) {
                statementBody.append("await");
                statementBody.append(" ");
            }
            if (baseClass.isNewStyleClass(context)) {
                statementBody.append("super");
                statementBody.append("(");
                LanguageLevel langLevel = ((PyFile)pyClass.getContainingFile()).getLanguageLevel();
                if (langLevel.isPython2()) {
                    String baseFirstName = !baseParams.isEmpty() ? ((PyCallableParameter)baseParams.get(0)).getName() : null;
                    String firstName = baseFirstName != null ? baseFirstName : "self";
                    PyClass outerClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)pyClass, PyClass.class, (boolean)true, (Class[])new Class[]{PyFunction.class});
                    String className = pyClass.getName();
                    ArrayList nameResult = Lists.newArrayList((Object[])new String[]{className});
                    while (outerClass != null) {
                        nameResult.add(0, outerClass.getName());
                        outerClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)outerClass, PyClass.class, (boolean)true, (Class[])new Class[]{PyFunction.class});
                    }
                    StringUtil.join((Collection)nameResult, (String)".", (StringBuilder)statementBody);
                    statementBody.append(", ").append(firstName);
                }
                statementBody.append(").").append(baseFunction.getName()).append("(");
                if (parameters2.size() > 0 && !baseMethodIsStatic && !overridingNew) {
                    parameters2.remove(0);
                }
            } else {
                statementBody.append(PyOverrideImplementUtil.getReferenceText(pyClass, baseClass)).append(".").append(baseFunction.getName()).append("(");
            }
            StringUtil.join(parameters2, (String)", ", (StringBuilder)statementBody);
            statementBody.append(")");
        }
        pyFunctionBuilder.statement(statementBody.toString());
        return pyFunctionBuilder;
    }

    private static String getReferenceText(PyClass fromClass, PyClass toClass) {
        PyExpression[] superClassExpressions;
        for (PyExpression expression : superClassExpressions = fromClass.getSuperClassExpressions()) {
            PsiElement target;
            if (!(expression instanceof PyReferenceExpression) || (target = ((PyReferenceExpression)expression).getReference().resolve()) != toClass) continue;
            return expression.getText();
        }
        return toClass.getName();
    }

    @NotNull
    public static List<PyFunction> getAllSuperAbstractMethods(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(23);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(24);
        }
        List list = ContainerUtil.filter(PyOverrideImplementUtil.getAllSuperMethods(cls, context), method -> {
            if (cls == null) {
                PyOverrideImplementUtil.$$$reportNull$$$0(40);
            }
            if (context == null) {
                PyOverrideImplementUtil.$$$reportNull$$$0(41);
            }
            return PyOverrideImplementUtil.isAbstractMethodForClass(method, cls, context);
        });
        if (list == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(25);
        }
        return list;
    }

    private static boolean isAbstractMethodForClass(@NotNull PyFunction method, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        String methodName;
        if (method == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(26);
        }
        if (cls == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(27);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(28);
        }
        if ((methodName = method.getName()) == null || cls.findMethodByName(methodName, false, context) != null || cls.findClassAttribute(methodName, false, context) != null) {
            return false;
        }
        PyClass methodClass = method.getContainingClass();
        if (methodClass != null) {
            for (PyClass ancestor : cls.getAncestorClasses(context)) {
                if (ancestor.equals(methodClass)) break;
                if (ancestor.findClassAttribute(methodName, false, context) == null) continue;
                return false;
            }
        }
        return method.onlyRaisesNotImplementedError() || PyKnownDecoratorUtil.hasAbstractDecorator(method, context);
    }

    @NotNull
    public static List<PyFunction> getAllSuperMethods(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(29);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(30);
        }
        LinkedHashMap functions = Maps.newLinkedHashMap();
        for (PyClassLikeType type : pyClass.getAncestorTypes(context)) {
            if (type == null) continue;
            for (PyFunction function : PyTypeUtil.getMembersOfType(type, PyFunction.class, false, context)) {
                String name = function.getName();
                if (name == null || functions.containsKey(name) && (!PyiUtil.isOverload((PsiElement)functions.get(name), context) || PyiUtil.isOverload(function, context))) continue;
                functions.put(name, function);
            }
        }
        ArrayList arrayList = Lists.newArrayList(functions.values());
        if (arrayList == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    private static void addImports(@NotNull PyFunction baseFunction, @NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (baseFunction == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(32);
        }
        if (function == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(33);
        }
        if (context == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(34);
        }
        UnresolvedExpressionVisitor unresolvedExpressionVisitor = new UnresolvedExpressionVisitor();
        PyOverrideImplementUtil.getAnnotations(function, context).forEach(annotation -> annotation.accept(unresolvedExpressionVisitor));
        PyOverrideImplementUtil.getDecorators(function).forEach(decorator -> decorator.accept(unresolvedExpressionVisitor));
        ResolveExpressionVisitor resolveExpressionVisitor = new ResolveExpressionVisitor(unresolvedExpressionVisitor.getUnresolved());
        PyOverrideImplementUtil.getAnnotations(baseFunction, context).forEach(annotation -> annotation.accept(resolveExpressionVisitor));
        PyOverrideImplementUtil.getDecorators(baseFunction).forEach(decorator -> decorator.accept(resolveExpressionVisitor));
    }

    @NotNull
    private static List<PyAnnotation> getAnnotations(@NotNull PyFunction function, @NotNull TypeEvalContext typeEvalContext) {
        if (function == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(35);
        }
        if (typeEvalContext == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(36);
        }
        List list = ((StreamEx)StreamEx.of((Collection)function.getParameters(typeEvalContext)).map(PyCallableParameter::getParameter).select(PyNamedParameter.class).remove(PyParameter::isSelf)).map(PyAnnotationOwner::getAnnotation).append((Object)function.getAnnotation()).nonNull().toList();
        if (list == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    private static List<PyDecorator> getDecorators(@NotNull PyFunction function) {
        PyDecoratorList decoratorList;
        if (function == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(38);
        }
        List<PyDecorator> list = (decoratorList = function.getDecoratorList()) == null ? Collections.emptyList() : Arrays.asList(decoratorList.getDecorators());
        if (list == null) {
            PyOverrideImplementUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 31: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 31: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 23: 
            case 27: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 5: 
            case 9: 
            case 24: 
            case 28: 
            case 30: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMembers";
                break;
            }
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFunction";
                break;
            }
            case 25: 
            case 31: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 33: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSuperAbstractMethods";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSuperMethods";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndOverrideMethods";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndImplementMethods";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndOverrideOrImplementMethods";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeMember";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllSuperAbstractMethods";
                break;
            }
            case 25: 
            case 31: 
            case 37: 
            case 39: {
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractMethodForClass";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllSuperMethods";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addImports";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDecorators";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllSuperAbstractMethods$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 31: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResolveExpressionVisitor
    extends PyRecursiveElementVisitor {
        private final Map<String, PyReferenceExpression> myExpressionsToResolve;

        ResolveExpressionVisitor(@NotNull Collection<PyReferenceExpression> toResolve) {
            if (toResolve == null) {
                ResolveExpressionVisitor.$$$reportNull$$$0(0);
            }
            this.myExpressionsToResolve = StreamEx.of(toResolve).toMap(NavigationItem::getName, Function.identity(), (expression1, expression2) -> expression2);
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression referenceExpression) {
            super.visitPyReferenceExpression(referenceExpression);
            if (this.myExpressionsToResolve.containsKey(referenceExpression.getName())) {
                PyClassRefactoringUtil.rememberNamedReferences((PsiElement)referenceExpression, new String[0]);
                PyClassRefactoringUtil.restoreReference(referenceExpression, this.myExpressionsToResolve.get(referenceExpression.getName()), PsiElement.EMPTY_ARRAY);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toResolve", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil$ResolveExpressionVisitor", "<init>"));
        }
    }

    private static class UnresolvedExpressionVisitor
    extends PyRecursiveElementVisitor {
        private final List<PyReferenceExpression> myUnresolved = new ArrayList<PyReferenceExpression>();

        private UnresolvedExpressionVisitor() {
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression referenceExpression) {
            super.visitPyReferenceExpression(referenceExpression);
            PyResolveContext resolveContext = PyResolveContext.noImplicits();
            if (referenceExpression.getReference(resolveContext).multiResolve(false).length == 0) {
                this.myUnresolved.add(referenceExpression);
            }
        }

        @NotNull
        List<PyReferenceExpression> getUnresolved() {
            List<PyReferenceExpression> list = Collections.unmodifiableList(this.myUnresolved);
            if (list == null) {
                UnresolvedExpressionVisitor.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/override/PyOverrideImplementUtil$UnresolvedExpressionVisitor", "getUnresolved"));
        }
    }
}

