/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureDialog;
import com.jetbrains.python.refactoring.changeSignature.PyMethodDescriptor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChangeSignatureHandler
implements ChangeSignatureHandler {
    @Nullable
    public PsiElement findTargetMember(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        PsiElement element = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        return this.findTargetMember(element);
    }

    @Nullable
    public PsiElement findTargetMember(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        TypeEvalContext context = TypeEvalContext.codeInsightFallback(element.getProject());
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (callExpression != null) {
            PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context);
            PyCallable resolved = (PyCallable)ContainerUtil.getFirstItem(callExpression.multiResolveCalleeFunction(resolveContext));
            return resolved instanceof PyFunction && PyiUtil.isOverload((PsiElement)resolved, context) ? PyiUtil.getImplementation((PyFunction)resolved, context) : resolved;
        }
        PyFunction parent = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (parent != null && PyiUtil.isOverload(parent, context)) {
            return null;
        }
        return parent;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        if ((element = this.findTargetMember(file, editor)) == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        PyChangeSignatureHandler.invokeOnElement(project, element, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(4);
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext == null ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PyChangeSignatureHandler.invokeOnElement(project, elements[0], editor);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return PyBundle.message("refactoring.change.signature.error.wrong.caret.position.method.name", new Object[0]);
    }

    private static void invokeOnElement(Project project, PsiElement element, Editor editor) {
        PyParameter[] parameters2;
        if (element instanceof PyLambdaExpression) {
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project, editor, PyBundle.message("refactoring.change.signature.error.lambda.call", new Object[0]));
            return;
        }
        if (!(element instanceof PyFunction)) {
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project, editor, PyBundle.message("refactoring.change.signature.error.wrong.caret.position.method.name", new Object[0]));
            return;
        }
        if (PyChangeSignatureHandler.isNotUnderSourceRoot(project, element.getContainingFile())) {
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project, editor, PyBundle.message("refactoring.change.signature.error.not.under.source.root", new Object[0]));
            return;
        }
        PyFunction superMethod = PyChangeSignatureHandler.getSuperMethod((PyFunction)element);
        if (superMethod == null) {
            return;
        }
        if (!superMethod.equals(element)) {
            element = superMethod;
            if (PyChangeSignatureHandler.isNotUnderSourceRoot(project, superMethod.getContainingFile())) {
                return;
            }
        }
        PyFunction function = (PyFunction)element;
        for (PyParameter p : parameters2 = function.getParameterList().getParameters()) {
            if (!(p instanceof PyTupleParameter)) continue;
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project, editor, PyBundle.message("refactoring.change.signature.error.tuple.parameters", new Object[0]));
            return;
        }
        PyMethodDescriptor method = new PyMethodDescriptor((PyFunction)element);
        PyChangeSignatureDialog dialog = new PyChangeSignatureDialog(project, method);
        dialog.show();
    }

    private static void showCannotRefactorErrorHint(@NotNull Project project, @Nullable Editor editor, @NotNull String details) {
        if (project == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(5);
        }
        if (details == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(6);
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)details);
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.renameRefactorings");
    }

    public static boolean isNotUnderSourceRoot(@NotNull Project project, @Nullable PsiFile psiFile) {
        ProjectFileIndex fileIndex;
        if (project == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            return true;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return virtualFile != null && ((fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).isExcluded(virtualFile) || fileIndex.isInLibraryClasses(virtualFile) && !fileIndex.isInContent(virtualFile));
    }

    @Nullable
    protected static PyFunction getSuperMethod(@Nullable PyFunction function) {
        if (function == null) {
            return null;
        }
        PyClass containingClass = function.getContainingClass();
        if (containingClass == null) {
            return function;
        }
        PyFunction deepestSuperMethod = PySuperMethodsSearch.findDeepestSuperMethod(function);
        if (!deepestSuperMethod.equals(function)) {
            String baseClassName;
            PyClass baseClass = deepestSuperMethod.getContainingClass();
            PyBuiltinCache cache2 = PyBuiltinCache.getInstance((PsiElement)baseClass);
            String string = baseClassName = baseClass == null ? "" : baseClass.getName();
            if (cache2.isBuiltin((PsiElement)baseClass)) {
                return function;
            }
            String message = PyBundle.message("refactoring.change.signature.find.usages.of.base.class", function.getName(), containingClass.getName(), baseClassName);
            int choice = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)function.getProject(), (String)message, (String)REFACTORING_NAME, (Icon)Messages.getQuestionIcon());
            switch (choice) {
                case 0: {
                    return deepestSuperMethod;
                }
                case 1: {
                    return function;
                }
            }
            return null;
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetMember";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showCannotRefactorErrorHint";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotUnderSourceRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

