/*
 * Decompiled with CFR 0.152.
 */
package tr.archive;

import java.util.Date;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ArchivePrefs {
    private static final Logger LOG = Logger.getLogger("tr.archive");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/archive");
    private static final String KEY_PATH = "path";
    private static final String DEF_PATH = "";
    private static final String KEY_DATE = "date";
    private static final long DEF_DATE = -1L;
    private static final String KEY_DONE_PROJECTS_ONLY = "done.projects.only";
    private static final boolean DEF_DONE_PROJECTS_ONLY = true;

    public static final String getPath() {
        return prefs.get(KEY_PATH, DEF_PATH);
    }

    public static final void setPath(String value) {
        prefs.put(KEY_PATH, value);
        ArchivePrefs.flush();
    }

    public static final Date getDate() {
        long ms = prefs.getLong(KEY_DATE, -1L);
        if (ms == -1L) {
            return null;
        }
        return new Date(ms);
    }

    public static final void setDate(Date date) {
        prefs.putLong(KEY_DATE, date == null ? -1L : date.getTime());
        ArchivePrefs.flush();
    }

    public static final boolean isDoneProjectsOnly() {
        return prefs.getBoolean(KEY_DONE_PROJECTS_ONLY, true);
    }

    public static final void setDoneProjectsOnly(boolean b) {
        prefs.putBoolean(KEY_DONE_PROJECTS_ONLY, b);
        ArchivePrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Archive preferences error. " + ex.getMessage());
        }
    }
}

