/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.util.Utils;
import tr.view.actions.screens.filters.FilterChoice;
import tr.view.filters.Choice;
import tr.view.filters.FilterComboAbstract;

public class FilterDone
extends FilterChoice
implements PropertyChangeListener {
    public static final byte INDEX = 0;
    private static final Logger LOG = Logger.getLogger("tr.view.actions");

    public FilterDone() {
        this.initialise();
    }

    protected void initialise() {
        this.combo = new DoneChoiceComboBox(new DoneChoiceComboBoxModel());
        this.combo.addValueChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        Choice choice = (Choice)this.combo.getSelectedItem();
        if (choice instanceof Done) {
            this.fireChanged(new DoneMatcher(true));
        } else if (choice instanceof ToDo) {
            this.fireChanged(new DoneMatcher(false));
        } else {
            this.fireMatchAll();
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-done");
    }

    public String[] getSerialValues() {
        String[] stringArray;
        if (this.combo == null) {
            return null;
        }
        Choice choice = (Choice)this.combo.getSelectedItem();
        if (choice == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = choice.getID();
        }
        return stringArray;
    }

    public void setSerialValues(String[] values) {
        if (this.combo == null) {
            return;
        }
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.combo.setSelectedItem(null);
        } else {
            this.combo.setSelectedItem((Object)this.getChoice(values[0]));
        }
        this.combo.startChangeEvents();
    }

    private Choice getChoice(String id) {
        if (id == null) {
            return null;
        }
        if (id.equals("0")) {
            return new All();
        }
        if (id.equals("1")) {
            return new Done();
        }
        if (id.equals("2")) {
            return new ToDo();
        }
        return null;
    }

    public byte getIndex() {
        return 0;
    }

    public boolean isShowDone() {
        return !(this.combo.getSelectedItem() instanceof ToDo);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilterDone)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Choice thisChoice = (Choice)this.combo.getSelectedItem();
        Choice thatChoice = (Choice)((FilterChoice)((Object)object)).combo.getSelectedItem();
        return Utils.equal((Object)thisChoice, (Object)thatChoice);
    }

    protected boolean canExcludeNulls() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoneMatcher
    implements Matcher<Action> {
        private final boolean done;

        public DoneMatcher(boolean done) {
            this.done = done;
        }

        public boolean matches(Action action) {
            return action.isDone() == this.done;
        }
    }

    private class DoneChoiceComboBox
    extends FilterComboAbstract {
        private ActionListener listener;

        public DoneChoiceComboBox(DoneChoiceComboBoxModel model) {
            super((ComboBoxModel)model);
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DoneChoiceComboBox.this.fireValueChange();
                }
            };
            this.addActionListener(this.listener);
        }

        public void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        public void startChangeEvents() {
            this.addActionListener(this.listener);
        }
    }

    private class DoneChoiceComboBoxModel
    extends DefaultComboBoxModel {
        private final Choice[] items;

        private DoneChoiceComboBoxModel() {
            this.items = new Choice[]{new All(), new Done(), new ToDo()};
        }

        public Object getElementAt(int index) {
            return this.items[index];
        }

        public int getSize() {
            return this.items.length;
        }
    }

    public final class ToDo
    extends Choice {
        public static final String ID = "2";

        public String getID() {
            return ID;
        }

        public String getLabel() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-done-todo");
        }
    }

    public final class Done
    extends Choice {
        public static final String ID = "1";

        public String getID() {
            return ID;
        }

        public String getLabel() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-done-done");
        }
    }

    public final class All
    extends Choice {
        public static final String ID = "0";

        public String getID() {
            return ID;
        }

        public String getLabel() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-all");
        }
    }
}

