/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class PrintPreferences {
    private static final PrintPreferences INSTANCE = new PrintPreferences();
    private static final String PROP_WRAP = "wrap";
    private static final String PROP_HEADER_FORMAT = "headerFormat";
    private static final String PROP_FOOTER_FORMAT = "footerFormat";
    private static final String PROP_HEADER_ALIGNMENT = "headerAlignment";
    private static final String PROP_FOOTER_ALIGNMENT = "footerAlignment";
    private static final String PROP_PAGE_ORIENTATION = "pageOrientation";
    private static final String PROP_PAGE_WIDTH = "pageWidth";
    private static final String PROP_PAGE_HEIGHT = "pageHeight";
    private static final String PROP_PAGE_IMAGEABLEAREA_Y = "imageableAreaY";
    private static final String PROP_PAGE_IMAGEABLEAREA_X = "imageableAreaX";
    private static final String PROP_PAGE_IMAGEABLEAREA_WIDTH = "imageableAreaWidth";
    private static final String PROP_PAGE_IMAGEABLEAREA_HEIGHT = "imageableAreaHeight";
    private static final String PROP_HEADER_FONT_NAME = "headerFontName";
    private static final String PROP_HEADER_FONT_STYLE = "headerFontStyle";
    private static final String PROP_HEADER_FONT_SIZE = "headerFontSize";
    private static final String PROP_FOOTER_FONT_NAME = "footerFontName";
    private static final String PROP_FOOTER_FONT_STYLE = "footerFontStyle";
    private static final String PROP_FOOTER_FONT_SIZE = "footerFontSize";
    private static final String DEFAULT_FONT_NAME = "Monospaced";
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_FONT_SIZE = 6;
    private static final String PROP_LINE_ASCENT_CORRECTION = "lineAscentCorrection";

    private PrintPreferences() {
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(PrintPreferences.class);
    }

    public static PageFormat getPageFormat(PrinterJob printerJob) {
        PageFormat pageFormat = null;
        pageFormat = printerJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        int n = PrintPreferences.getPreferences().getInt(PROP_PAGE_ORIENTATION, pageFormat.getOrientation());
        double d = PrintPreferences.getPreferences().getDouble(PROP_PAGE_WIDTH, paper.getWidth());
        double d2 = PrintPreferences.getPreferences().getDouble(PROP_PAGE_HEIGHT, paper.getHeight());
        double d3 = PrintPreferences.getPreferences().getDouble(PROP_PAGE_IMAGEABLEAREA_WIDTH, paper.getImageableWidth());
        double d4 = PrintPreferences.getPreferences().getDouble(PROP_PAGE_IMAGEABLEAREA_HEIGHT, paper.getImageableHeight());
        double d5 = PrintPreferences.getPreferences().getDouble(PROP_PAGE_IMAGEABLEAREA_X, paper.getImageableX());
        double d6 = PrintPreferences.getPreferences().getDouble(PROP_PAGE_IMAGEABLEAREA_Y, paper.getImageableY());
        pageFormat.setOrientation(n);
        paper.setSize(d, d2);
        paper.setImageableArea(d5, d6, d3, d4);
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static void setPageFormat(PageFormat pageFormat) {
        PrintPreferences.getPreferences().putInt(PROP_PAGE_ORIENTATION, pageFormat.getOrientation());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_WIDTH, pageFormat.getPaper().getWidth());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_HEIGHT, pageFormat.getPaper().getHeight());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_IMAGEABLEAREA_WIDTH, pageFormat.getPaper().getImageableWidth());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_IMAGEABLEAREA_HEIGHT, pageFormat.getPaper().getImageableHeight());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_IMAGEABLEAREA_X, pageFormat.getPaper().getImageableX());
        PrintPreferences.getPreferences().putDouble(PROP_PAGE_IMAGEABLEAREA_Y, pageFormat.getPaper().getImageableY());
    }

    public static boolean getWrap() {
        return PrintPreferences.getPreferences().getBoolean(PROP_WRAP, true);
    }

    public static void setWrap(boolean bl) {
        if (PrintPreferences.getWrap() == bl) {
            return;
        }
        PrintPreferences.getPreferences().putBoolean(PROP_WRAP, bl);
    }

    public static String getHeaderFormat() {
        return PrintPreferences.getPreferences().get(PROP_HEADER_FORMAT, NbBundle.getMessage(PrintPreferences.class, (String)"CTL_Header_format"));
    }

    public static void setHeaderFormat(String string) {
        if (PrintPreferences.getHeaderFormat().equals(string)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_HEADER_FORMAT, string);
    }

    public static String getFooterFormat() {
        return PrintPreferences.getPreferences().get(PROP_FOOTER_FORMAT, NbBundle.getMessage(PrintPreferences.class, (String)"CTL_Footer_format"));
    }

    public static void setFooterFormat(String string) {
        if (PrintPreferences.getFooterFormat().equals(string)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_FOOTER_FORMAT, string);
    }

    public static Font getHeaderFont() {
        String string = PrintPreferences.getPreferences().get(PROP_HEADER_FONT_NAME, DEFAULT_FONT_NAME);
        int n = PrintPreferences.getPreferences().getInt(PROP_HEADER_FONT_STYLE, 0);
        int n2 = PrintPreferences.getPreferences().getInt(PROP_HEADER_FONT_SIZE, 6);
        return new Font(string, n, n2);
    }

    public static void setHeaderFont(Font font) {
        if (PrintPreferences.getHeaderFont().equals(font)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_HEADER_FONT_NAME, font.getName());
        PrintPreferences.getPreferences().putInt(PROP_HEADER_FONT_STYLE, font.getStyle());
        PrintPreferences.getPreferences().putInt(PROP_HEADER_FONT_SIZE, font.getSize());
    }

    public static Font getFooterFont() {
        String string = PrintPreferences.getPreferences().get(PROP_FOOTER_FONT_NAME, DEFAULT_FONT_NAME);
        int n = PrintPreferences.getPreferences().getInt(PROP_FOOTER_FONT_STYLE, 0);
        int n2 = PrintPreferences.getPreferences().getInt(PROP_FOOTER_FONT_SIZE, 6);
        return new Font(string, n, n2);
    }

    public static void setFooterFont(Font font) {
        if (PrintPreferences.getFooterFont().equals(font)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_FOOTER_FONT_NAME, font.getName());
        PrintPreferences.getPreferences().putInt(PROP_FOOTER_FONT_STYLE, font.getStyle());
        PrintPreferences.getPreferences().putInt(PROP_FOOTER_FONT_SIZE, font.getSize());
    }

    public static Alignment getHeaderAlignment() {
        return Alignment.valueOf(PrintPreferences.getPreferences().get(PROP_HEADER_ALIGNMENT, Alignment.CENTER.name()));
    }

    public static void setHeaderAlignment(Alignment alignment) {
        if (PrintPreferences.getHeaderAlignment().equals((Object)alignment)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_HEADER_ALIGNMENT, alignment.name());
    }

    public static Alignment getFooterAlignment() {
        return Alignment.valueOf(PrintPreferences.getPreferences().get(PROP_FOOTER_ALIGNMENT, Alignment.CENTER.name()));
    }

    public static void setFooterAlignment(Alignment alignment) {
        if (PrintPreferences.getFooterAlignment().equals((Object)alignment)) {
            return;
        }
        PrintPreferences.getPreferences().put(PROP_FOOTER_ALIGNMENT, alignment.name());
    }

    public static float getLineAscentCorrection() {
        return PrintPreferences.getPreferences().getFloat(PROP_LINE_ASCENT_CORRECTION, 1.0f);
    }

    public static void setLineAscentCorrection(float f) {
        if (PrintPreferences.getLineAscentCorrection() == f) {
            return;
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException();
        }
        PrintPreferences.getPreferences().putFloat(PROP_LINE_ASCENT_CORRECTION, f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

