/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;

public class LRUWeakCache<K, V>
extends LRUCache<K, V> {
    private static final long serialVersionUID = 1L;

    public LRUWeakCache(int maximumCacheSize) {
        super(maximumCacheSize);
    }

    public LRUWeakCache(int initialCapacity, int maximumCacheSize) {
        super(initialCapacity, maximumCacheSize);
    }

    @Override
    public V put(K key, V value) {
        WeakReference<V> put = new WeakReference<V>(value);
        WeakReference<V> prev = super.put(key, put);
        return prev != null ? (V)prev.get() : null;
    }

    @Override
    public V get(Object o) {
        WeakReference ref = (WeakReference)super.get(o);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object o) {
        WeakReference ref = (WeakReference)super.remove(o);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public Collection<V> values() {
        Collection col = super.values();
        ArrayList answer = new ArrayList();
        for (WeakReference ref : col) {
            Object value = ref.get();
            if (value == null) continue;
            answer.add(value);
        }
        return answer;
    }

    @Override
    public int size() {
        int size = 0;
        for (Object value : super.values()) {
            WeakReference ref = (WeakReference)value;
            if (ref == null || ref.get() == null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.get(o) != null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set original = super.entrySet();
        LinkedHashSet<Map.Entry<K, V>> answer = new LinkedHashSet<Map.Entry<K, V>>(original.size());
        for (final Map.Entry entry : original) {
            Map.Entry view = new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    WeakReference ref = (WeakReference)entry.getValue();
                    return ref != null ? (Object)ref.get() : null;
                }

                @Override
                public V setValue(V v) {
                    WeakReference put = new WeakReference(v);
                    WeakReference prev = entry.setValue(put);
                    return prev != null ? (Object)prev.get() : null;
                }
            };
            answer.add(view);
        }
        return answer;
    }

    @Override
    public String toString() {
        return "LRUWeakCache@" + ObjectHelper.getIdentityHashCode(this);
    }
}

