/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OsgiServiceRegistry
extends LifecycleStrategySupport
implements Registry {
    private final BundleContext bundleContext;
    private final Map<String, Object> serviceCacheMap = new ConcurrentHashMap<String, Object>();
    private final Queue<ServiceReference<?>> serviceReferenceQueue = new ConcurrentLinkedQueue();

    public OsgiServiceRegistry(BundleContext bc) {
        this.bundleContext = bc;
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object service = this.serviceCacheMap.get(name);
        if (service == null) {
            ServiceReference sr = null;
            try {
                ServiceReference[] refs = this.bundleContext.getServiceReferences(type.getName(), "(name=" + name + ")");
                if (refs != null && refs.length > 0) {
                    sr = refs[0];
                    this.serviceReferenceQueue.add(sr);
                    service = this.bundleContext.getService(sr);
                    if (service != null) {
                        this.serviceCacheMap.put(name, service);
                    }
                }
            }
            catch (Exception ex) {
                throw ObjectHelper.wrapRuntimeCamelException(ex);
            }
        }
        return type.cast(service);
    }

    @Override
    public Object lookupByName(String name) {
        ServiceReference sr;
        Object service = this.serviceCacheMap.get(name);
        if (service == null && (sr = this.bundleContext.getServiceReference(name)) != null) {
            this.serviceReferenceQueue.add(sr);
            service = this.bundleContext.getService(sr);
            if (service != null) {
                this.serviceCacheMap.put(name, service);
            }
        }
        return service;
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        HashMap<String, T> result = new HashMap<String, T>();
        int count = 0;
        try {
            ServiceReference[] refs = this.bundleContext.getAllServiceReferences(type.getName(), null);
            if (refs != null) {
                for (ServiceReference sr : refs) {
                    if (sr == null) continue;
                    Object service = this.bundleContext.getService(sr);
                    this.serviceReferenceQueue.add(sr);
                    if (service == null) continue;
                    String name = (String)sr.getProperty("name");
                    if (name != null) {
                        result.put(name, type.cast(service));
                        continue;
                    }
                    result.put(type.getSimpleName() + count, type.cast(service));
                    ++count;
                }
            }
        }
        catch (Exception ex) {
            throw ObjectHelper.wrapRuntimeCamelException(ex);
        }
        return result;
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        Map<String, T> map = this.findByTypeWithName(type);
        return new HashSet<T>(map.values());
    }

    @Override
    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.findByTypeWithName(type);
    }

    @Override
    public void onContextStop(CamelContext context) {
        ServiceReference<?> sr = this.serviceReferenceQueue.poll();
        while (sr != null) {
            this.bundleContext.ungetService(sr);
            sr = this.serviceReferenceQueue.poll();
        }
        this.serviceReferenceQueue.clear();
        this.serviceCacheMap.clear();
    }
}

