/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.Component;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedComponentMBean;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Component")
public class ManagedComponent
implements ManagedInstance,
ManagedComponentMBean {
    private final Component component;
    private final String name;

    public ManagedComponent(String name, Component component) {
        this.name = name;
        this.component = component;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public String getComponentName() {
        return this.name;
    }

    @Override
    public String getState() {
        if (this.component instanceof StatefulService) {
            ServiceStatus status2 = ((StatefulService)((Object)this.component)).getStatus();
            return status2.name();
        }
        return ServiceStatus.Started.name();
    }

    @Override
    public String getCamelId() {
        return this.component.getCamelContext().getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.component.getCamelContext().getManagementName();
    }

    @Override
    public Object getInstance() {
        return this.component;
    }

    @Override
    public String informationJson() {
        try {
            String defaultName = this.component.getCamelContext().resolveComponentDefaultName(this.component.getClass().getName());
            String target = defaultName != null ? defaultName : this.name;
            return this.component.getCamelContext().getComponentParameterJsonSchema(target);
        }
        catch (IOException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public TabularData explain(boolean allOptions) {
        try {
            String defaultName = this.component.getCamelContext().resolveComponentDefaultName(this.component.getClass().getName());
            String target = defaultName != null ? defaultName : this.name;
            String json = this.component.getCamelContext().explainComponentJson(target, allOptions);
            List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("componentProperties", json, true);
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.explainComponentTabularType());
            for (Map<String, String> row : rows) {
                String name = row.get("name");
                String kind = row.get("kind");
                String group = row.get("group") != null ? row.get("group") : "";
                String label = row.get("label") != null ? row.get("label") : "";
                String type = row.get("type");
                String javaType = row.get("javaType");
                String deprecated = row.get("deprecated") != null ? row.get("deprecated") : "";
                String value = row.get("value") != null ? row.get("value") : "";
                String defaultValue = row.get("defaultValue") != null ? row.get("defaultValue") : "";
                String description = row.get("description") != null ? row.get("description") : "";
                CompositeType ct = CamelOpenMBeanTypes.explainComponentCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"option", "kind", "group", "label", "type", "java type", "deprecated", "value", "default value", "description"}, new Object[]{name, kind, group, label, type, javaType, deprecated, value, defaultValue, description});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

