/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.linkedin.util.io.ObjectInputStreamWithClassLoader;

public class IOUtils {
    public static boolean deleteFile(File file) throws IOException {
        if (!file.exists()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File childFile = files[i];
                if (childFile.equals(file)) continue;
                if (childFile.isDirectory()) {
                    IOUtils.deleteFile(childFile);
                    continue;
                }
                childFile.delete();
            }
        }
        return file.delete();
    }

    public static boolean createNewDirectory(File directory) throws IOException {
        if (directory.exists()) {
            return false;
        }
        if (!directory.mkdirs()) {
            throw new IOException("cannot create the directory: " + directory);
        }
        return true;
    }

    public static File createTempDirectory(String namespace, String name) throws IOException {
        File dir = File.createTempFile(namespace, "");
        if (dir.exists()) {
            IOUtils.deleteFile(dir);
        }
        IOUtils.createNewDirectory(dir);
        File tempDir = new File(dir, name);
        IOUtils.createNewDirectory(tempDir);
        return tempDir.getCanonicalFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> byte[] serialize(T ser) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(ser);
        }
        finally {
            oos.close();
        }
        return baos.toByteArray();
    }

    public static <T extends Serializable> T deserialize(byte[] array) throws IOException, ClassNotFoundException {
        return IOUtils.deserialize(array, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T deserialize(byte[] array, boolean useContextClassLoader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        ObjectInputStream ois = useContextClassLoader ? new ObjectInputStreamWithClassLoader(bais, null) : new ObjectInputStream(bais);
        try {
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
        finally {
            ois.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T deserialize(byte[] array, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        ObjectInputStream ois = classLoader != null ? new ObjectInputStreamWithClassLoader(bais, classLoader) : new ObjectInputStream(bais);
        try {
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
        finally {
            ois.close();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IOUtils.copy(in, out, -1);
    }

    public static void copy(InputStream in, OutputStream out, int num_bytes) throws IOException {
        if (num_bytes == 0) {
            return;
        }
        if (num_bytes < 0) {
            int n;
            byte[] b = new byte[2048];
            while ((n = in.read(b, 0, b.length)) > 0) {
                out.write(b, 0, n);
            }
        } else {
            int n;
            int offset = 0;
            byte[] b = new byte[num_bytes];
            while (num_bytes > 0 && (n = in.read(b, offset, num_bytes)) > 0) {
                offset += n;
                num_bytes -= n;
            }
            out.write(b);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        IOUtils.copy(in, out, -1);
    }

    public static void copy(Reader in, Writer out, int num_bytes) throws IOException {
        if (num_bytes == 0) {
            return;
        }
        if (num_bytes < 0) {
            int n;
            char[] b = new char[2048];
            while ((n = in.read(b, 0, b.length)) > 0) {
                out.write(b, 0, n);
            }
        } else {
            int n;
            int offset = 0;
            char[] b = new char[num_bytes];
            while (num_bytes > 0 && (n = in.read(b, offset, num_bytes)) > 0) {
                offset += n;
                num_bytes -= n;
            }
            out.write(b);
        }
    }

    protected IOUtils() {
    }
}

