/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava;

import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.PragmaHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.CommentCode;
import com.github.mustachejava.codes.DefaultCode;
import com.github.mustachejava.codes.DefaultMustache;
import com.github.mustachejava.codes.ExtendCode;
import com.github.mustachejava.codes.ExtendNameCode;
import com.github.mustachejava.codes.IterableCode;
import com.github.mustachejava.codes.NotIterableCode;
import com.github.mustachejava.codes.PartialCode;
import com.github.mustachejava.codes.ValueCode;
import com.github.mustachejava.codes.WriteCode;
import com.github.mustachejava.util.Node;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class DefaultMustacheVisitor
implements MustacheVisitor {
    protected static Logger logger = Logger.getLogger(DefaultMustacheVisitor.class.getSimpleName());
    private static final Code EOF = new DefaultCode(){

        @Override
        public Node invert(Node node, String text, AtomicInteger position) {
            return text.length() == position.get() ? node : null;
        }
    };
    protected final List<Code> list = new LinkedList<Code>();
    private final Map<String, PragmaHandler> handlers = new HashMap<String, PragmaHandler>(){
        {
            this.put("implicit-iterator", (tc, pragma, args) -> new DefaultCode());
        }
    };
    protected DefaultMustacheFactory df;

    public DefaultMustacheVisitor(DefaultMustacheFactory df) {
        this.df = df;
    }

    public void addPragmaHandler(String pragma, PragmaHandler handler) {
        this.handlers.put(pragma.toLowerCase(), handler);
    }

    @Override
    public Mustache mustache(TemplateContext templateContext) {
        return new DefaultMustache(templateContext, this.df, this.list.toArray(new Code[this.list.size()]), templateContext.file());
    }

    @Override
    public void iterable(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new IterableCode(templateContext, this.df, mustache, variable));
    }

    @Override
    public void notIterable(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new NotIterableCode(templateContext, this.df, mustache, variable));
    }

    @Override
    public void name(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new ExtendNameCode(templateContext, this.df, mustache, variable));
    }

    @Override
    public void partial(TemplateContext tc, String variable) {
        TemplateContext partialTC = new TemplateContext("{{", "}}", tc.file(), tc.line(), tc.startOfLine());
        this.list.add(new PartialCode(partialTC, this.df, variable));
    }

    @Override
    public void value(TemplateContext tc, String variable, boolean encoded) {
        this.list.add(new ValueCode(tc, this.df, variable, encoded));
    }

    @Override
    public void write(TemplateContext tc, String text) {
        if (text.length() > 0) {
            int size = this.list.size();
            if (size > 0) {
                Code code = this.list.get(size - 1);
                code.append(text);
            } else {
                this.list.add(new WriteCode(tc, this.df, text));
            }
        }
    }

    @Override
    public void pragma(TemplateContext tc, String pragma, String args) {
        PragmaHandler pragmaHandler = this.handlers.get(pragma.toLowerCase());
        if (pragmaHandler == null) {
            logger.warning("Unimplemented pragma: " + pragma);
        } else {
            Code code = pragmaHandler.handle(tc, pragma, args);
            if (code != null) {
                this.list.add(code);
            }
        }
    }

    @Override
    public void eof(TemplateContext templateContext) {
        this.list.add(EOF);
    }

    @Override
    public void extend(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new ExtendCode(templateContext, this.df, mustache, variable));
    }

    @Override
    public void comment(TemplateContext templateContext, String comment) {
        this.list.add(new CommentCode(templateContext, this.df, comment));
    }
}

