/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.LinkedHashSet;
import java.util.Map;
import org.gradle.internal.execution.history.changes.AbstractFingerprintCompareStrategy;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DefaultFileChange;
import org.gradle.internal.execution.history.changes.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;

public class AbsolutePathFingerprintCompareStrategy
extends AbstractFingerprintCompareStrategy {
    public static final FingerprintCompareStrategy INSTANCE = new AbsolutePathFingerprintCompareStrategy();

    private AbsolutePathFingerprintCompareStrategy() {
    }

    @Override
    protected boolean doVisitChangesSince(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> current, Map<String, FileSystemLocationFingerprint> previous, String propertyTitle) {
        LinkedHashSet<String> unaccountedForPreviousFingerprints = new LinkedHashSet<String>(previous.keySet());
        for (Map.Entry<String, FileSystemLocationFingerprint> currentEntry : current.entrySet()) {
            DefaultFileChange added;
            DefaultFileChange modified;
            FileSystemLocationFingerprint previousFingerprint;
            HashCode previousContentHash;
            String currentAbsolutePath = currentEntry.getKey();
            FileSystemLocationFingerprint currentFingerprint = currentEntry.getValue();
            HashCode currentContentHash = currentFingerprint.getNormalizedContentHash();
            if (!(unaccountedForPreviousFingerprints.remove(currentAbsolutePath) ? !currentContentHash.equals((Object)(previousContentHash = (previousFingerprint = previous.get(currentAbsolutePath)).getNormalizedContentHash())) && !visitor.visitChange(modified = DefaultFileChange.modified(currentAbsolutePath, propertyTitle, previousFingerprint.getType(), currentFingerprint.getType(), currentAbsolutePath)) : !visitor.visitChange(added = DefaultFileChange.added(currentAbsolutePath, propertyTitle, currentFingerprint.getType(), currentAbsolutePath)))) continue;
            return false;
        }
        for (String previousAbsolutePath : unaccountedForPreviousFingerprints) {
            DefaultFileChange removed = DefaultFileChange.removed(previousAbsolutePath, propertyTitle, previous.get(previousAbsolutePath).getType(), previousAbsolutePath);
            if (visitor.visitChange(removed)) continue;
            return false;
        }
        return true;
    }
}

