/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionLeafVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.DefaultFileMetadata;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.fingerprint.FileCollectionSnapshotter;
import org.gradle.internal.fingerprint.impl.PatternSetSnapshottingFilter;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemSnapshotter;
import org.gradle.internal.snapshot.SnapshottingFilter;

public class DefaultFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final Stat stat;

    public DefaultFileCollectionSnapshotter(FileSystemSnapshotter fileSystemSnapshotter, Stat stat) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.stat = stat;
    }

    @Override
    public List<FileSystemSnapshot> snapshot(FileCollection fileCollection) {
        FileCollectionLeafVisitorImpl visitor = new FileCollectionLeafVisitorImpl();
        ((FileCollectionInternal)fileCollection).visitLeafCollections((FileCollectionLeafVisitor)visitor);
        return visitor.getRoots();
    }

    private FileSystemSnapshot snapshotFileTree(FileTreeInternal tree) {
        final FileSystemSnapshotBuilder builder = this.fileSystemSnapshotter.newFileSystemSnapshotBuilder();
        tree.visitTreeOrBackingFile(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                builder.addDir(dirDetails.getFile(), dirDetails.getRelativePath().getSegments());
            }

            public void visitFile(FileVisitDetails fileDetails) {
                builder.addFile(fileDetails.getFile(), fileDetails.getRelativePath().getSegments(), fileDetails.getName(), (FileMetadataSnapshot)new DefaultFileMetadata(FileType.RegularFile, fileDetails.getLastModified(), fileDetails.getSize()));
            }
        });
        return builder.build();
    }

    private class FileCollectionLeafVisitorImpl
    implements FileCollectionLeafVisitor {
        private final List<FileSystemSnapshot> roots = new ArrayList<FileSystemSnapshot>();

        private FileCollectionLeafVisitorImpl() {
        }

        public void visitCollection(FileCollectionInternal fileCollection) {
            for (File file : fileCollection) {
                this.roots.add((FileSystemSnapshot)DefaultFileCollectionSnapshotter.this.fileSystemSnapshotter.snapshot(file));
            }
        }

        public void visitGenericFileTree(FileTreeInternal fileTree) {
            this.roots.add(DefaultFileCollectionSnapshotter.this.snapshotFileTree(fileTree));
        }

        public void visitFileTree(File root, PatternSet patterns) {
            this.roots.add(DefaultFileCollectionSnapshotter.this.fileSystemSnapshotter.snapshotDirectoryTree(root, (SnapshottingFilter)new PatternSetSnapshottingFilter(patterns, DefaultFileCollectionSnapshotter.this.stat)));
        }

        public List<FileSystemSnapshot> getRoots() {
            return this.roots;
        }
    }
}

