/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.provider.AbstractReadOnlyProvider;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.internal.state.Managed;
import org.gradle.util.GUtil;

public abstract class AbstractMinimalProvider<T>
implements ProviderInternal<T>,
Managed {
    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
        return new TransformBackedProvider<S, T>(transformer, this);
    }

    public <S> Provider<S> flatMap(Transformer<? extends Provider<? extends S>, ? super T> transformer) {
        return new FlatMapProvider(this, transformer);
    }

    public boolean isPresent() {
        return this.getOrNull() != null;
    }

    public T getOrElse(T defaultValue) {
        Object value = this.getOrNull();
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public Provider<T> orElse(T value) {
        return new OrElseFixedValueProvider<T>(this, value);
    }

    public Provider<T> orElse(Provider<? extends T> provider) {
        return new OrElseProvider<T>(this, Providers.internal(provider));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.maybeVisitBuildDependencies(context);
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        return false;
    }

    @Override
    public ProviderInternal<T> withFinalValue() {
        Object value = this.getOrNull();
        if (value == null) {
            return Providers.notDefined();
        }
        return Providers.of(value);
    }

    public String toString() {
        return String.format("provider(%s)", GUtil.elvis(this.getType(), (Object)"?"));
    }

    @Override
    public boolean immutable() {
        return false;
    }

    @Override
    public Class<?> publicType() {
        return Provider.class;
    }

    @Override
    public Object unpackState() {
        return this.getOrNull();
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.ProviderManagedFactory.FACTORY_ID;
    }

    private static class OrElseProvider<T>
    extends AbstractReadOnlyProvider<T> {
        private final ProviderInternal<T> left;
        private final ProviderInternal<? extends T> right;

        public OrElseProvider(ProviderInternal<T> left, ProviderInternal<? extends T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return this.left.getType();
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            if (this.left.isPresent()) {
                return this.left.maybeVisitBuildDependencies(context);
            }
            return this.right.maybeVisitBuildDependencies(context);
        }

        @Override
        public boolean isPresent() {
            return this.left.isPresent() || this.right.isPresent();
        }

        @Nullable
        public T getOrNull() {
            Object value = this.left.getOrNull();
            if (value == null) {
                value = this.right.getOrNull();
            }
            return (T)value;
        }
    }

    private static class OrElseFixedValueProvider<T>
    extends AbstractProviderWithValue<T> {
        private final ProviderInternal<T> provider;
        private final T value;

        public OrElseFixedValueProvider(ProviderInternal<T> provider, T value) {
            this.provider = provider;
            this.value = value;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return this.provider.getType();
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            if (this.provider.isPresent()) {
                return this.provider.maybeVisitBuildDependencies(context);
            }
            return super.maybeVisitBuildDependencies(context);
        }

        public T get() {
            Object value = this.provider.getOrNull();
            return (T)(value != null ? value : this.value);
        }
    }

    private static class FlatMapProvider<S, T>
    extends AbstractMinimalProvider<S> {
        private final Provider<? extends T> provider;
        private final Transformer<? extends Provider<? extends S>, ? super T> transformer;

        FlatMapProvider(ProviderInternal<? extends T> provider, Transformer<? extends Provider<? extends S>, ? super T> transformer) {
            this.provider = provider;
            this.transformer = transformer;
        }

        @Override
        @Nullable
        public Class<S> getType() {
            return null;
        }

        @Override
        public boolean isPresent() {
            Object value = this.provider.getOrNull();
            if (value == null) {
                return false;
            }
            return this.map(value).isPresent();
        }

        public S get() {
            Object value = this.provider.get();
            return (S)this.map(value).get();
        }

        @Nullable
        public S getOrNull() {
            Object value = this.provider.getOrNull();
            if (value == null) {
                return null;
            }
            return (S)this.map(value).getOrNull();
        }

        private Provider<? extends S> map(T value) {
            Provider result = (Provider)this.transformer.transform(value);
            if (result == null) {
                throw new IllegalStateException("Transformer for this provider returned a null value.");
            }
            return result;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return Providers.internal(this.map(this.provider.get())).maybeVisitBuildDependencies(context);
        }

        @Override
        public String toString() {
            return "flatmap(" + this.provider + ")";
        }
    }
}

