/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.artifacts.transform.TransformOutputsInternal;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.GFileUtils;

public class DefaultTransformOutputs
implements TransformOutputsInternal {
    private final ImmutableList.Builder<File> outputsBuilder = ImmutableList.builder();
    private final Set<File> outputDirectories = new HashSet<File>();
    private final Set<File> outputFiles = new HashSet<File>();
    private final PathToFileResolver resolver;
    private final File inputArtifact;
    private final File outputDir;
    private final String inputArtifactPrefix;
    private final String outputDirPrefix;

    public DefaultTransformOutputs(File inputArtifact, File outputDir) {
        this.resolver = new BaseDirFileResolver(outputDir, PatternSets.getNonCachingPatternSetFactory());
        this.inputArtifact = inputArtifact;
        this.outputDir = outputDir;
        this.inputArtifactPrefix = inputArtifact.getPath() + File.separator;
        this.outputDirPrefix = outputDir.getPath() + File.separator;
    }

    @Override
    public ImmutableList<File> getRegisteredOutputs() {
        ImmutableList outputs = this.outputsBuilder.build();
        for (File output : outputs) {
            TransformOutputsInternal.validateOutputExists(output);
            if (this.outputFiles.contains(output) && !output.isFile()) {
                throw new InvalidUserDataException("Transform output file " + output.getPath() + " must be a file, but is not.");
            }
            if (!this.outputDirectories.contains(output) || output.isDirectory()) continue;
            throw new InvalidUserDataException("Transform output directory " + output.getPath() + " must be a directory, but is not.");
        }
        return outputs;
    }

    public File dir(Object path) {
        File outputDir = this.resolveAndRegister(path, location -> GFileUtils.mkdirs((File)location));
        this.outputDirectories.add(outputDir);
        return outputDir;
    }

    public File file(Object path) {
        File outputFile = this.resolveAndRegister(path, location -> GFileUtils.mkdirs((File)location.getParentFile()));
        this.outputFiles.add(outputFile);
        return outputFile;
    }

    private File resolveAndRegister(Object path, Consumer<File> prepareOutputLocation) {
        File output = this.resolver.resolve(path);
        TransformOutputsInternal.OutputLocationType outputLocationType = TransformOutputsInternal.determineOutputLocationType(output, this.inputArtifact, this.inputArtifactPrefix, this.outputDir, this.outputDirPrefix);
        if (outputLocationType == TransformOutputsInternal.OutputLocationType.WORKSPACE) {
            prepareOutputLocation.accept(output);
        }
        this.outputsBuilder.add((Object)output);
        return output;
    }
}

