/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.codahale.metrics.MetricRegistry;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.ConcurrentLFUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LFUCache<K, V>
implements SolrCache<K, V>,
Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LFUCache.class);
    private List<ConcurrentLFUCache.Stats> statsList;
    private long warmupTime = 0L;
    private String name;
    private int autowarmCount;
    private SolrCache.State state;
    private CacheRegenerator regenerator;
    private String description = "Concurrent LFU Cache";
    private ConcurrentLFUCache<K, V> cache;
    private int showItems = 0;
    private Boolean timeDecay = true;
    private MetricsMap cacheMap;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private MetricRegistry registry;

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        this.state = SolrCache.State.CREATED;
        this.regenerator = regenerator;
        this.name = (String)args.get("name");
        String str = (String)args.get("size");
        int limit = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get("minSize");
        int minLimit = str == null ? (int)((double)limit * 0.9) : Integer.parseInt(str);
        if (minLimit == 0) {
            minLimit = 1;
        }
        if (limit <= minLimit) {
            limit = minLimit + 1;
        }
        int acceptableSize = (str = (String)args.get("acceptableSize")) == null ? (int)((double)limit * 0.95) : Integer.parseInt(str);
        acceptableSize = Math.max(minLimit, acceptableSize);
        str = (String)args.get("initialSize");
        int initialSize = str == null ? limit : Integer.parseInt(str);
        str = (String)args.get("autowarmCount");
        this.autowarmCount = str == null ? 0 : Integer.parseInt(str);
        str = (String)args.get("cleanupThread");
        boolean newThread = str == null ? false : Boolean.parseBoolean(str);
        str = (String)args.get("showItems");
        this.showItems = str == null ? 0 : Integer.parseInt(str);
        str = (String)args.get("timeDecay");
        this.timeDecay = str == null ? true : Boolean.parseBoolean(str);
        this.description = "Concurrent LFU Cache(maxSize=" + limit + ", initialSize=" + initialSize + ", minSize=" + minLimit + ", acceptableSize=" + acceptableSize + ", cleanupThread=" + newThread + ", timeDecay=" + Boolean.toString(this.timeDecay);
        if (this.autowarmCount > 0) {
            this.description = this.description + ", autowarmCount=" + this.autowarmCount + ", regenerator=" + regenerator;
        }
        this.description = this.description + ')';
        this.cache = new ConcurrentLFUCache(limit, minLimit, acceptableSize, initialSize, newThread, false, null, this.timeDecay);
        this.cache.setAlive(false);
        this.statsList = (List)persistence;
        if (this.statsList == null) {
            this.statsList = new CopyOnWriteArrayList<ConcurrentLFUCache.Stats>();
            this.statsList.add(new ConcurrentLFUCache.Stats());
        }
        this.statsList.add(this.cache.getStats());
        return this.statsList;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void setState(SolrCache.State state) {
        this.state = state;
        this.cache.setAlive(state == SolrCache.State.LIVE);
    }

    @Override
    public SolrCache.State getState() {
        return this.state;
    }

    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache old) {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.nanoTime();
        LFUCache other = (LFUCache)old;
        if (this.autowarmCount != 0) {
            int sz = other.size();
            if (this.autowarmCount != -1) {
                sz = Math.min(sz, this.autowarmCount);
            }
            Map<K, V> items = other.cache.getMostUsedItems(sz);
            Map.Entry[] itemsArr = new Map.Entry[items.size()];
            int counter = 0;
            for (Map.Entry<K, V> mapEntry : items.entrySet()) {
                itemsArr[counter++] = mapEntry;
            }
            for (int i = itemsArr.length - 1; i >= 0; --i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, itemsArr[i].getKey(), itemsArr[i].getValue());
                    if (continueRegen) continue;
                    break;
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + itemsArr[i].getKey()), (Throwable)e);
                }
            }
        }
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() {
        this.statsList.get(0).add(this.cache.getStats());
        this.statsList.remove(this.cache.getStats());
        this.cache.destroy();
    }

    @Override
    public String getName() {
        return LFUCache.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.CACHE;
    }

    private static String calcHitRatio(long lookups, long hits) {
        if (lookups == 0L) {
            return "0.00";
        }
        if (lookups == hits) {
            return "1.00";
        }
        int hundredths = (int)(hits * 100L / lookups);
        if (hundredths < 10) {
            return "0.0" + hundredths;
        }
        return "0." + hundredths;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String tag, String scope) {
        this.registry = manager.registry(registryName);
        this.cacheMap = new MetricsMap((detailed, map) -> {
            if (this.cache != null) {
                ConcurrentLFUCache.Stats stats = this.cache.getStats();
                long lookups = stats.getCumulativeLookups();
                long hits = stats.getCumulativeHits();
                long inserts = stats.getCumulativePuts();
                long evictions = stats.getCumulativeEvictions();
                long size = stats.getCurrentSize();
                map.put("lookups", lookups);
                map.put("hits", hits);
                map.put("hitratio", LFUCache.calcHitRatio(lookups, hits));
                map.put("inserts", inserts);
                map.put("evictions", evictions);
                map.put("size", size);
                map.put("warmupTime", this.warmupTime);
                map.put("timeDecay", this.timeDecay);
                long clookups = 0L;
                long chits = 0L;
                long cinserts = 0L;
                long cevictions = 0L;
                for (ConcurrentLFUCache.Stats statistics : this.statsList) {
                    clookups += statistics.getCumulativeLookups();
                    chits += statistics.getCumulativeHits();
                    cinserts += statistics.getCumulativePuts();
                    cevictions += statistics.getCumulativeEvictions();
                }
                map.put("cumulative_lookups", clookups);
                map.put("cumulative_hits", chits);
                map.put("cumulative_hitratio", LFUCache.calcHitRatio(clookups, chits));
                map.put("cumulative_inserts", cinserts);
                map.put("cumulative_evictions", cevictions);
                if (detailed.booleanValue() && this.showItems != 0) {
                    Map<K, V> items = this.cache.getMostUsedItems(this.showItems == -1 ? Integer.MAX_VALUE : this.showItems);
                    for (Map.Entry<K, V> e : items.entrySet()) {
                        K k = e.getKey();
                        V v = e.getValue();
                        String ks = "item_" + k;
                        String vs = v.toString();
                        map.put(ks, vs);
                    }
                }
            }
        });
        manager.registerGauge(this, registryName, this.cacheMap, tag, true, scope, this.getCategory().toString());
    }

    MetricsMap getMetricsMap() {
        return this.cacheMap;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    public String toString() {
        return this.name + (this.cacheMap != null ? this.cacheMap.getValue().toString() : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ramBytesUsed() {
        List<ConcurrentLFUCache.Stats> list = this.statsList;
        synchronized (list) {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOfObject((Object)this.name) + RamUsageEstimator.sizeOfObject(this.metricNames) + RamUsageEstimator.sizeOfObject(this.statsList) + RamUsageEstimator.sizeOfObject(this.cache);
        }
    }
}

