from miasm2.jitter.jitload import Jitter
from miasm2.core.locationdb import LocationDB
from miasm2.core.utils import pck16, upck16
from miasm2.arch.msp430.sem import ir_msp430

import logging

log = logging.getLogger('jit_msp430')
hnd = logging.StreamHandler()
hnd.setFormatter(logging.Formatter("[%(levelname)s]: %(message)s"))
log.addHandler(hnd)
log.setLevel(logging.CRITICAL)

class jitter_msp430(Jitter):

    def __init__(self, *args, **kwargs):
        sp = LocationDB()
        Jitter.__init__(self, ir_msp430(sp), *args, **kwargs)
        self.vm.set_little_endian()

    def push_uint16_t(self, value):
        regs = self.cpu.get_gpreg()
        regs['SP'] -= 2
        self.cpu.set_gpreg(regs)
        self.vm.set_mem(regs['SP'], pck16(value))

    def pop_uint16_t(self):
        regs = self.cpu.get_gpreg()
        value = self.vm.get_u16(regs['SP'])
        regs['SP'] += 2
        self.cpu.set_gpreg(regs)
        return value

    def get_stack_arg(self, index):
        regs = self.cpu.get_gpreg()
        value = self.vm.get_u16(regs['SP'] + 2 * index)
        return value

    def init_run(self, *args, **kwargs):
        Jitter.init_run(self, *args, **kwargs)
        self.cpu.PC = self.pc

