/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import java.io.File;
import java.io.IOException;
import org.linkedin.util.io.resource.FileResource;
import org.linkedin.util.io.resource.ResourceFilter;
import org.linkedin.util.io.resource.internal.AbstractResourceProvider;
import org.linkedin.util.io.resource.internal.InternalResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResourceProvider
extends AbstractResourceProvider {
    public static final String MODULE = FileResourceProvider.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private final File _root;

    public FileResourceProvider(File root) throws IOException {
        this._root = root.getCanonicalFile();
    }

    @Override
    public InternalResource doBuildResource(String path) {
        return new FileResource(this, path, new File(this._root, path));
    }

    @Override
    public InternalResourceProvider doCreateResourceProvider(String rootPath) {
        try {
            return new FileResourceProvider(new File(this._root, rootPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean doList(String path, ResourceFilter filter) {
        File[] files;
        File file = null;
        try {
            file = new File(this._root, path).getCanonicalFile();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("exception (ignored) while converting canonical file " + new File(this._root, path), (Throwable)e);
            }
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        for (File f : files = file.listFiles()) {
            filter.accept(new FileResource(this, path + f.getName(), f));
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileResourceProvider that = (FileResourceProvider)o;
        return this._root.equals(that._root);
    }

    public int hashCode() {
        return this._root.hashCode();
    }
}

