/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class Indent {
    private int _level;
    private String _indent_string;
    private String _indentation = null;

    public Indent() {
        this("  ", 0);
    }

    public Indent(String indent_string) {
        this(indent_string, 0);
    }

    public Indent(int level) {
        this("  ", level);
    }

    public Indent(String indent_string, int level) {
        this._indent_string = indent_string;
        this._level = level;
        this.calculateIndentationString();
    }

    public String getIndentString() {
        return this._indent_string;
    }

    public void setIndentString(String indent_string) {
        this._indent_string = indent_string;
        this.calculateIndentationString();
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int level) {
        this._level = level;
        if (this._level < 0) {
            this._level = 0;
        }
        this.calculateIndentationString();
    }

    public void inc() {
        ++this._level;
        this.calculateIndentationString();
    }

    public void dec() {
        --this._level;
        if (this._level < 0) {
            this._level = 0;
        }
        this.calculateIndentationString();
    }

    public String getIndentation() {
        return this._indentation;
    }

    private void calculateIndentationString() {
        if (this._level == 0) {
            this._indentation = "";
            return;
        }
        if (this._level == 1) {
            this._indentation = this._indent_string;
            return;
        }
        StringBuilder sb = new StringBuilder(this._level + this._indent_string.length());
        for (int i = 0; i < this._level; ++i) {
            sb.append(this._indent_string);
        }
        this._indentation = sb.toString();
    }

    public String toString() {
        return this.getIndentation();
    }

    public static String indentBlock(String block, Indent indent) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(block));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(indent).append(line).append('\n');
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return sb.toString();
    }
}

