/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Method;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationUtils;

class BeanAnnotationHelper {
    BeanAnnotationHelper() {
    }

    public static boolean isBeanAnnotated(Method method) {
        return AnnotationUtils.findAnnotation((Method)method, Bean.class) != null;
    }

    public static String determineBeanNameFor(Method beanMethod) {
        String beanName = beanMethod.getName();
        Bean bean = (Bean)AnnotationUtils.findAnnotation((Method)beanMethod, Bean.class);
        if (bean != null && bean.name().length > 0) {
            beanName = bean.name()[0];
        }
        return beanName;
    }
}

