(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/actor/rpc/server#current-rpc-server (make-parameter '#f))
  (define std/actor/rpc/server#start-rpc-server!__%
    (lambda (_g207613_ _proto207478207481_ . _addresses207483_)
      (let ((_proto207485_
             (if (eq? _proto207478207481_ absent-value)
                 (std/actor/rpc/proto/null#rpc-null-proto)
                 _proto207478207481_)))
        (std/logger#start-logger!__0)
        (gerbil/gambit/threads#spawn/group
         'rpc-server
         std/actor/rpc/server#rpc-server
         _proto207485_
         _addresses207483_))))
  (define std/actor/rpc/server#start-rpc-server!__@
    (lambda (_keys207477207490_ . _args207492_)
      (apply std/actor/rpc/server#start-rpc-server!__%
             _keys207477207490_
             (table-ref _keys207477207490_ 'proto: absent-value)
             _args207492_)))
  (define std/actor/rpc/server#start-rpc-server!
    (lambda _args207479207498_
      (apply keyword-dispatch
             '#(proto:)
             std/actor/rpc/server#start-rpc-server!__@
             _args207479207498_)))
  (define std/actor/rpc/server#stop-rpc-server!
    (lambda (_rpcd207470_)
      (let ((_tgroup207472_ (thread-thread-group _rpcd207470_)))
        (with-unwind-protect
         (lambda ()
           (std/actor/message#send-message__0
            _rpcd207470_
            (##structure
             std/actor/proto#!event::t
             (##structure std/actor/rpc/base#rpc.shutdown::t)))
           (thread-join! _rpcd207470_))
         (lambda () (std/misc/threads#thread-group-kill! _tgroup207472_))))))
  (define std/actor/rpc/server#rpc-connect__%
    (lambda (_rpcd207441_ _id207442_ _address207443_ _proto207444_)
      (let ((_$e207446_
             (std/actor/rpc/server#rpc-canonical-address _address207443_)))
        (if _$e207446_
            ((lambda (_address207449_)
               (let ((_token207451_ (##structure std/actor/proto#!token::t))
                     (_dest207453_ _rpcd207441_))
                 (std/actor/message#send-message__%
                  _dest207453_
                  (##structure
                   std/actor/proto#!call::t
                   (##structure
                    std/actor/rpc/base#rpc.connect::t
                    _id207442_
                    _address207449_
                    _proto207444_)
                   _token207451_)
                  '#f
                  '#t)
                 (std/actor/proto#!!call-recv _token207451_ _dest207453_)))
             _$e207446_)
            (error '"Bad rpc address" _address207443_)))))
  (define std/actor/rpc/server#rpc-connect__0
    (lambda (_rpcd207459_ _id207460_ _address207461_)
      (let ((_proto207463_ '#f))
        (std/actor/rpc/server#rpc-connect__%
         _rpcd207459_
         _id207460_
         _address207461_
         _proto207463_))))
  (define std/actor/rpc/server#rpc-connect
    (lambda _g207615_
      (let ((_g207614_ (length _g207615_)))
        (cond ((##fx= _g207614_ 3)
               (apply std/actor/rpc/server#rpc-connect__0 _g207615_))
              ((##fx= _g207614_ 4)
               (apply std/actor/rpc/server#rpc-connect__% _g207615_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/server#rpc-connect
                _g207615_))))))
  (define std/actor/rpc/server#rpc-register__%
    (lambda (_rpcd207419_ _id207420_ _proto207421_)
      (let ((_token207423_ (##structure std/actor/proto#!token::t))
            (_dest207425_ _rpcd207419_))
        (std/actor/message#send-message__%
         _dest207425_
         (##structure
          std/actor/proto#!call::t
          (##structure
           std/actor/rpc/base#rpc.register::t
           _id207420_
           _proto207421_)
          _token207423_)
         '#f
         '#t)
        (std/actor/proto#!!call-recv _token207423_ _dest207425_))))
  (define std/actor/rpc/server#rpc-register__0
    (lambda (_rpcd207431_ _id207432_)
      (let ((_proto207434_ '#f))
        (std/actor/rpc/server#rpc-register__%
         _rpcd207431_
         _id207432_
         _proto207434_))))
  (define std/actor/rpc/server#rpc-register
    (lambda _g207617_
      (let ((_g207616_ (length _g207617_)))
        (cond ((##fx= _g207616_ 2)
               (apply std/actor/rpc/server#rpc-register__0 _g207617_))
              ((##fx= _g207616_ 3)
               (apply std/actor/rpc/server#rpc-register__% _g207617_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/server#rpc-register
                _g207617_))))))
  (define std/actor/rpc/server#rpc-unregister
    (lambda (_rpcd207410_ _id207411_)
      (let ((_token207413_ (##structure std/actor/proto#!token::t))
            (_dest207415_ _rpcd207410_))
        (std/actor/message#send-message__%
         _dest207415_
         (##structure
          std/actor/proto#!call::t
          (##structure std/actor/rpc/base#rpc.unregister::t _id207411_)
          _token207413_)
         '#f
         '#t)
        (std/actor/proto#!!call-recv _token207413_ _dest207415_))))
  (define std/actor/rpc/server#rpc-canonical-address
    (lambda (_address207405_)
      (if (std/net/address#resolved-address? _address207405_)
          _address207405_
          (if (or (std/net/address#inet-address? _address207405_)
                  (std/net/address#inet-address-string? _address207405_))
              (std/net/address#resolve-address _address207405_)
              (if (string? _address207405_) _address207405_ '#f)))))
  (define std/actor/rpc/server#rpc-server
    (lambda (_proto207388_ _addresses207389_)
      (let* ((_sas207391_ (map std/os/socket#socket-address _addresses207389_))
             (_g207618_
              (for-each
               std/actor/rpc/server#rpc-unlink-unix-socket
               _sas207391_))
             (_socks207394_
              (map std/net/socket/api#ssocket-listen _sas207391_)))
        (call-with-parameters
         (lambda ()
           (with-exception-catcher
            (lambda (_g207397207399_)
              (if '#t
                  (let ((_e207402_ _g207397207399_))
                    (if (eq? _e207402_ 'shutdown)
                        '#!void
                        (begin
                          (std/logger#log-error
                           '"unhandled exception"
                           _e207402_)
                          (raise _e207402_))))
                  (raise _g207397207399_)))
            (lambda ()
              (std/actor/rpc/server#rpc-server-loop
               _socks207394_
               _sas207391_
               _proto207388_))))
         std/actor/rpc/server#current-rpc-server
         (current-thread)))))
  (define std/actor/rpc/server#rpc-unlink-unix-socket
    (lambda (_sa207385_)
      (if (eq? (std/os/_socket#sockaddr_family _sa207385_)
               std/os/_socket#AF_UNIX)
          (with-exception-catcher
           void
           (lambda ()
             (delete-file (std/os/socket#socket-address->string _sa207385_))))
          '#!void)))
  (define std/actor/rpc/server#rpc-server-loop
    (lambda (_socks206682_ _sas206683_ _proto206684_)
      (letrec* ((_connect-e206686_
                 (##structure-ref
                  _proto206684_
                  '1
                  std/actor/rpc/base#!rpc-protocol::t
                  '#f))
                (_accept-e206687_
                 (##structure-ref
                  _proto206684_
                  '2
                  std/actor/rpc/base#!rpc-protocol::t
                  '#f))
                (_actors206688_ (std/actor/rpc/base#make-actor-table))
                (_actor-threads206689_ (make-table 'test: eq?))
                (_conns206690_ (make-table))
                (_threads206691_ (make-table 'test: eq?))
                (_monitors206692_ (make-table 'test: eq?))
                (_acceptors206693_
                 (map (lambda (_sock207382_ _sa207383_)
                        (gerbil/gambit/threads#spawn/name
                         'rpc-server-accept
                         std/actor/rpc/server#rpc-server-accept
                         (current-thread)
                         _sock207382_
                         (std/os/_socket#sockaddr_family _sa207383_)))
                      _socks206682_
                      _sas206683_))
                (_server-connection206694_ '0)
                (_accept-connection206695_
                 (lambda (_cli207372_ _clisa207373_)
                   (let* ((_cliaddr207375_
                           (std/os/socket#socket-address->address
                            _clisa207373_))
                          (_address207377_
                           (list _cliaddr207375_ _server-connection206694_))
                          (_thr207379_
                           (gerbil/gambit/threads#spawn/name
                            'rpc-connection
                            std/actor/rpc/connection#rpc-server-connection
                            (current-thread)
                            _actors206688_
                            _cli207372_
                            _clisa207373_
                            _address207377_
                            _accept-e206687_)))
                     (set! _server-connection206694_
                           (+ _server-connection206694_ '1))
                     (table-set! _conns206690_ _address207377_ _thr207379_)
                     (table-set! _threads206691_ _thr207379_ _address207377_)
                     (std/actor/rpc/base#rpc-monitor__0 _thr207379_))))
                (_open-connection206696_
                 (lambda (_address207360_)
                   (let ((_$e207362_
                          (table-ref _conns206690_ _address207360_ '#f)))
                     (if _$e207362_
                         (values _$e207362_)
                         (if (list? _address207360_)
                             '#f
                             (let ((_address207365_
                                    (std/actor/rpc/server#rpc-canonical-address
                                     _address207360_)))
                               (if (not _address207365_)
                                   '#f
                                   (let ((_$e207367_
                                          (table-ref
                                           _conns206690_
                                           _address207365_
                                           '#f)))
                                     (if _$e207367_
                                         (values _$e207367_)
                                         (let ((_thr207370_
                                                (gerbil/gambit/threads#spawn/name
                                                 'rpc-connection
                                                 std/actor/rpc/connection#rpc-client-connection
                                                 (current-thread)
                                                 _actors206688_
                                                 _address207365_
                                                 _connect-e206686_)))
                                           (table-set!
                                            _conns206690_
                                            _address207365_
                                            _thr207370_)
                                           (table-set!
                                            _threads206691_
                                            _thr207370_
                                            _address207365_)
                                           (std/actor/rpc/base#rpc-monitor__0
                                            _thr207370_)
                                           _thr207370_))))))))))
                (_handle-protocol-action206697_
                 (lambda (_msg206951_)
                   (let* ((_msg206952206961_ _msg206951_)
                          (_E206954206965_
                           (lambda ()
                             (error '"No clause matching" _msg206952206961_)))
                          (_K206955207337_
                           (lambda (_opt206968_
                                    _dest206969_
                                    _src206970_
                                    _content206971_)
                             (let* ((_content206972207022_ _content206971_)
                                    (_else206983207030_
                                     (lambda ()
                                       (std/logger#warning
                                        '"Unexpected message ~a"
                                        _msg206951_))))
                               (let ((_K207017207321_
                                      (lambda (_cliaddr207318_ _cli207319_)
                                        (_accept-connection206695_
                                         _cli207319_
                                         _cliaddr207318_)))
                                     (_K207015207309_
                                      (lambda ()
                                        (let ((_$e207304_
                                               (table-ref
                                                _threads206691_
                                                _src206970_
                                                '#f)))
                                          (if _$e207304_
                                              ((lambda (_address207307_)
                                                 (std/actor/message#send-message__0
                                                  _src206970_
                                                  (##structure
                                                   std/actor/proto#!event::t
                                                   (##structure
                                                    std/actor/rpc/base#rpc.connection-close::t)))
                                                 (_remove-thread!206699_
                                                  _src206970_))
                                               _$e207304_)
                                              (std/logger#warning
                                               '"Unexpected protocol mesage ~a"
                                               _msg206951_)))))
                                     (_K207009207273_
                                      (lambda (_k207258_
                                               _proto207259_
                                               _address207260_
                                               _id207261_)
                                        (let* ((_uuid207263_
                                                (std/misc/uuid#UUID
                                                 _id207261_))
                                               (_proto207268_
                                                (let ((_$e207265_
                                                       _proto207259_))
                                                  (if _$e207265_
                                                      _$e207265_
                                                      (std/actor/rpc/base#lookup-protocol
                                                       _uuid207263_)))))
                                          (if (##structure-direct-instance-of?
                                               _proto207268_
                                               'std/actor/proto#!protocol::t)
                                              (let ((_handler207271_
                                                     (_open-connection206696_
                                                      _address207260_)))
                                                (if _handler207271_
                                                    (std/actor/message#send-message__%
                                                     _src206970_
                                                     (##structure
                                                      std/actor/proto#!value::t
                                                      (let ((__obj207612
                                                             (make-object
                                                              std/actor/proto#remote::t
                                                              '4)))
                                                        (std/actor/proto#remote:::init!
                                                         __obj207612
                                                         _handler207271_
                                                         _id207261_
                                                         _address207260_
                                                         _proto207268_)
                                                        __obj207612)
                                                      _k207258_)
                                                     '#f
                                                     '#f)
                                                    (std/actor/message#send-message__%
                                                     _src206970_
                                                     (##structure
                                                      std/actor/proto#!error::t
                                                      (make-struct-instance
                                                       std/actor/proto#rpc-error::t
                                                       'rpc-server
                                                       '"invalid address")
                                                      _k207258_)
                                                     '#f
                                                     '#f)))
                                              (std/actor/message#send-message__%
                                               _src206970_
                                               (##structure
                                                std/actor/proto#!error::t
                                                '"bad protocol"
                                                _k207258_)
                                               '#f
                                               '#f)))))
                                     (_K207004207233_
                                      (lambda (_k207216_
                                               _proto207217_
                                               _id207218_)
                                        (let ((_uuid207220_
                                               (std/misc/uuid#UUID
                                                _id207218_)))
                                          (if (std/misc/sync#sync-hash-key?
                                               _actors206688_
                                               _uuid207220_)
                                              (std/actor/message#send-message__%
                                               _src206970_
                                               (##structure
                                                std/actor/proto#!error::t
                                                '"duplicate registration"
                                                _k207216_)
                                               '#f
                                               '#f)
                                              (let ((_proto207225_
                                                     (let ((_$e207222_
                                                            _proto207217_))
                                                       (if _$e207222_
                                                           _$e207222_
                                                           (std/actor/rpc/base#lookup-protocol
                                                            _uuid207220_)))))
                                                (if (##structure-direct-instance-of?
                                                     _proto207225_
                                                     'std/actor/proto#!protocol::t)
                                                    (let ((_thread207227_
                                                           (_actor-thread-e206698_
                                                            _src206970_)))
                                                      (std/actor/rpc/base#actor-table-put!
                                                       _actors206688_
                                                       _uuid207220_
                                                       _src206970_
                                                       _proto207225_)
                                                      (hash-update!
                                                       _actor-threads206689_
                                                       _thread207227_
                                                       (lambda (_g207228207230_)
                                                         (cons _uuid207220_
                                                               _g207228207230_))
                                                       '())
                                                      (std/actor/rpc/base#rpc-monitor__0
                                                       _thread207227_)
                                                      (std/actor/message#send-message__%
                                                       _src206970_
                                                       (##structure
                                                        std/actor/proto#!value::t
                                                        _uuid207220_
                                                        _k207216_)
                                                       '#f
                                                       '#f))
                                                    (std/actor/message#send-message__%
                                                     _src206970_
                                                     (##structure
                                                      std/actor/proto#!error::t
                                                      '"bad protocol"
                                                      _k207216_)
                                                     '#f
                                                     '#f)))))))
                                     (_K207000207196_
                                      (lambda (_k207182_ _id207183_)
                                        (let* ((_uuid207185_
                                                (std/misc/uuid#UUID
                                                 _id207183_))
                                               (_thread207187_
                                                (_actor-thread-e206698_
                                                 _src206970_)))
                                          (std/misc/sync#sync-hash-remove!
                                           _actors206688_
                                           _uuid207185_)
                                          (let ((_actor-rest207194_
                                                 (remf (lambda (_g207189207191_)
                                                         (std/misc/uuid#uuid=?
                                                          _g207189207191_
                                                          _uuid207185_))
                                                       (table-ref
                                                        _actor-threads206689_
                                                        _thread207187_
                                                        '()))))
                                            (if (null? _actor-rest207194_)
                                                (table-set!
                                                 _actor-threads206689_
                                                 _thread207187_)
                                                (table-set!
                                                 _actor-threads206689_
                                                 _thread207187_
                                                 _actor-rest207194_)))
                                          (std/actor/message#send-message__%
                                           _src206970_
                                           (##structure
                                            std/actor/proto#!value::t
                                            '#!void
                                            _k207182_)
                                           '#f
                                           '#f))))
                                     (_K206996207162_
                                      (lambda (_k207121_ _id207122_)
                                        (let* ((_uuid207124_
                                                (std/misc/uuid#UUID
                                                 _id207122_))
                                               (_actor207159_
                                                (let ((_$e207126_
                                                       (std/misc/sync#sync-hash-get
                                                        _actors206688_
                                                        _uuid207124_)))
                                                  (if _$e207126_
                                                      ((lambda (_e207128207130_)
                                                         (let* ((_g207132207139_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _e207128207130_)
                        (_E207134207143_
                         (lambda ()
                           (error '"No clause matching" _g207132207139_)))
                        (_K207135207148_
                         (lambda (_actor207146_) _actor207146_)))
                   (if (##fx= (if (##values? _g207132207139_)
                                  (##vector-length _g207132207139_)
                                  '1)
                              '2)
                       (let* ((_e207136207151_
                               (##vector-ref _g207132207139_ '0))
                              (_actor207154_ _e207136207151_)
                              (_e207137207156_
                               (##vector-ref _g207132207139_ '1)))
                         (_K207135207148_ _actor207154_))
                       (_E207134207143_))))
               _$e207126_)
              '#f))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                          (std/actor/message#send-message__%
                                           _src206970_
                                           (##structure
                                            std/actor/proto#!value::t
                                            _actor207159_
                                            _k207121_)
                                           '#f
                                           '#f))))
                                     (_K206993207106_
                                      (lambda (_k207102_)
                                        (let ((_addresses207104_
                                               (map std/os/socket#socket-address->address
                                                    _sas206683_)))
                                          (std/actor/message#send-message__%
                                           _src206970_
                                           (##structure
                                            std/actor/proto#!value::t
                                            _addresses207104_
                                            _k207102_)
                                           '#f
                                           '#f))))
                                     (_K206990207087_
                                      (lambda (_remote207074_)
                                        (let* ((_address207076_
                                                (##direct-structure-ref
                                                 _remote207074_
                                                 '3
                                                 std/actor/proto#remote::t
                                                 '#f))
                                               (_$e207078_
                                                (table-ref
                                                 _conns206690_
                                                 _address207076_
                                                 '#f)))
                                          (if _$e207078_
                                              ((lambda (_thread207081_)
                                                 (hash-update!
                                                  _monitors206692_
                                                  _thread207081_
                                                  (lambda (_g207082207084_)
                                                    (cons (cons _src206970_
                                                                _remote207074_)
                                                          _g207082207084_))
                                                  '()))
                                               _$e207078_)
                                              (std/actor/message#send-message__0
                                               _src206970_
                                               (##structure
                                                std/actor/proto#!event::t
                                                (##structure
                                                 std/actor/rpc/base#rpc.disconnect::t
                                                 _remote207074_)))))))
                                     (_K206987207059_
                                      (lambda (_remote207045_)
                                        (let* ((_address207047_
                                                (##direct-structure-ref
                                                 _remote207045_
                                                 '3
                                                 std/actor/proto#remote::t
                                                 '#f))
                                               (_thread207048207050_
                                                (table-ref
                                                 _conns206690_
                                                 _address207047_
                                                 '#f)))
                                          (if _thread207048207050_
                                              (let ((_thread207053_
                                                     _thread207048207050_))
                                                (hash-update!
                                                 _monitors206692_
                                                 _thread207053_
                                                 (lambda (_g207054207056_)
                                                   (remove (cons _src206970_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _remote207045_)
                   _g207054207056_))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 '()))
                                              '#f))))
                                     (_K206985207035_
                                      (lambda () (raise 'shutdown))))
                                 (let ((_try-match206975207299_
                                        (lambda ()
                                          (if (##structure-direct-instance-of?
                                               _content206972207022_
                                               'std/actor/proto#!call::t)
                                              (let ((_e207010207276_
                                                     (##vector-ref
                                                      _content206972207022_
                                                      '1)))
                                                (if (##structure-direct-instance-of?
                                                     _e207010207276_
                                                     'std/actor#rpc.connect::t)
                                                    (let* ((_e207012207279_
                                                            (##vector-ref
                                                             _e207010207276_
                                                             '1))
                                                           (_e207013207284_
                                                            (##vector-ref
                                                             _e207010207276_
                                                             '2))
                                                           (_e207014207289_
                                                            (##vector-ref
                                                             _e207010207276_
                                                             '3))
                                                           (_e207011207294_
                                                            (##vector-ref
                                                             _content206972207022_
                                                             '2)))
                                                      (let ((_id207282_
                                                             _e207012207279_)
                                                            (_address207287_
                                                             _e207013207284_)
                                                            (_proto207292_
                                                             _e207014207289_)
                                                            (_k207297_
                                                             _e207011207294_))
                                                        (_K207009207273_
                                                         _k207297_
                                                         _proto207292_
                                                         _address207287_
                                                         _id207282_)))
                                                    (if (##structure-direct-instance-of?
                                                         _e207010207276_
                                                         'std/actor#rpc.register::t)
                                                        (let* ((_e207007207239_
                                                                (##vector-ref
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _e207010207276_
                         '1))
                       (_e207008207244_ (##vector-ref _e207010207276_ '2))
                       (_e207006207249_
                        (##vector-ref _content206972207022_ '2)))
                  (let ((_id207242_ _e207007207239_)
                        (_proto207247_ _e207008207244_)
                        (_k207252_ _e207006207249_))
                    (_K207004207233_ _k207252_ _proto207247_ _id207242_)))
                (if (##structure-direct-instance-of?
                     _e207010207276_
                     'std/actor#rpc.unregister::t)
                    (let* ((_e207003207202_ (##vector-ref _e207010207276_ '1))
                           (_e207002207207_
                            (##vector-ref _content206972207022_ '2)))
                      (let ((_id207205_ _e207003207202_)
                            (_k207210_ _e207002207207_))
                        (_K207000207196_ _k207210_ _id207205_)))
                    (if (##structure-direct-instance-of?
                         _e207010207276_
                         'std/actor#rpc.resolve::t)
                        (let* ((_e206999207168_
                                (##vector-ref _e207010207276_ '1))
                               (_e206998207173_
                                (##vector-ref _content206972207022_ '2)))
                          (let ((_id207171_ _e206999207168_)
                                (_k207176_ _e206998207173_))
                            (_K206996207162_ _k207176_ _id207171_)))
                        (if (##structure-direct-instance-of?
                             _e207010207276_
                             'std/actor#rpc.server-address::t)
                            (let* ((_e206995207112_
                                    (##vector-ref _content206972207022_ '2))
                                   (_k207115_ _e206995207112_))
                              (_K206993207106_ _k207115_))
                            (_else206983207030_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                              (_else206983207030_)))))
                                   (if (##structure-direct-instance-of?
                                        _content206972207022_
                                        'std/actor/proto#!event::t)
                                       (let ((_e207018207324_
                                              (##vector-ref
                                               _content206972207022_
                                               '1)))
                                         (if (##structure-direct-instance-of?
                                              _e207018207324_
                                              'std/actor#rpc.connection-accept::t)
                                             (let* ((_e207019207327_
                                                     (##vector-ref
                                                      _e207018207324_
                                                      '1))
                                                    (_e207020207332_
                                                     (##vector-ref
                                                      _e207018207324_
                                                      '2)))
                                               (let ((_cli207330_
                                                      _e207019207327_)
                                                     (_cliaddr207335_
                                                      _e207020207332_))
                                                 (_K207017207321_
                                                  _cliaddr207335_
                                                  _cli207330_)))
                                             (if (##structure-direct-instance-of?
                                                  _e207018207324_
                                                  'std/actor#rpc.connection-shutdown::t)
                                                 (_K207015207309_)
                                                 (if (##structure-direct-instance-of?
                                                      _e207018207324_
                                                      'std/actor#rpc.monitor::t)
                                                     (let* ((_e206992207093_
                                                             (##vector-ref
                                                              _e207018207324_
                                                              '1))
                                                            (_remote207096_
                                                             _e206992207093_))
                                                       (_K206990207087_
                                                        _remote207096_))
                                                     (if (##structure-direct-instance-of?
                                                          _e207018207324_
                                                          'std/actor#rpc.unmonitor::t)
                                                         (let* ((_e206989207065_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (##vector-ref _e207018207324_ '1))
                        (_remote207068_ _e206989207065_))
                   (_K206987207059_ _remote207068_))
                 (if (##structure-direct-instance-of?
                      _e207018207324_
                      'std/actor#rpc.shutdown::t)
                     (_K206985207035_)
                     (_else206983207030_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                       (_try-match206975207299_))))))))
                     (if (##structure-direct-instance-of?
                          _msg206952206961_
                          'std/actor/message#message::t)
                         (let* ((_e206956207340_
                                 (##vector-ref _msg206952206961_ '1))
                                (_content207343_ _e206956207340_)
                                (_e206957207345_
                                 (##vector-ref _msg206952206961_ '2))
                                (_src207348_ _e206957207345_)
                                (_e206958207350_
                                 (##vector-ref _msg206952206961_ '3))
                                (_dest207353_ _e206958207350_)
                                (_e206959207355_
                                 (##vector-ref _msg206952206961_ '4))
                                (_opt207358_ _e206959207355_))
                           (_K206955207337_
                            _opt207358_
                            _dest207353_
                            _src207348_
                            _content207343_))
                         (_E206954206965_)))))
                (_actor-thread-e206698_
                 (lambda (_actor206949_)
                   (if (thread? _actor206949_)
                       _actor206949_
                       (if (##structure-instance-of?
                            _actor206949_
                            'std/actor/message#proxy::t)
                           (##structure-ref
                            _actor206949_
                            '1
                            std/actor/message#proxy::t
                            '#f)
                           (error '"Bad actor" _actor206949_)))))
                (_remove-thread!206699_
                 (lambda (_thread206901_)
                   (let ((_$e206903_
                          (table-ref _threads206691_ _thread206901_ '#f)))
                     (if _$e206903_
                         ((lambda (_address206906_)
                            (for-each
                             (lambda (_e206907206909_)
                               (let* ((_g206911206918_ _e206907206909_)
                                      (_E206913206922_
                                       (lambda ()
                                         (error '"No clause matching"
                                                _g206911206918_)))
                                      (_K206914206928_
                                       (lambda (_remote206925_ _actor206926_)
                                         (std/actor/message#send-message__0
                                          _actor206926_
                                          (##structure
                                           std/actor/proto#!event::t
                                           (##structure
                                            std/actor/rpc/base#rpc.disconnect::t
                                            _remote206925_))))))
                                 (if (##pair? _g206911206918_)
                                     (let ((_hd206915206931_
                                            (##car _g206911206918_))
                                           (_tl206916206933_
                                            (##cdr _g206911206918_)))
                                       (let* ((_actor206936_ _hd206915206931_)
                                              (_remote206938_
                                               _tl206916206933_))
                                         (_K206914206928_
                                          _remote206938_
                                          _actor206936_)))
                                     (_E206913206922_))))
                             (table-ref _monitors206692_ _thread206901_ '()))
                            (table-set! _conns206690_ _address206906_)
                            (table-set! _threads206691_ _thread206901_)
                            (table-set! _monitors206692_ _thread206901_))
                          _$e206903_)
                         '#!void))
                   (let ((_$e206940_
                          (table-ref
                           _actor-threads206689_
                           _thread206901_
                           '#f)))
                     (if _$e206940_
                         ((lambda (_uuids206943_)
                            (for-each
                             (lambda (_g206944206946_)
                               (std/misc/sync#sync-hash-remove!
                                _actors206688_
                                _g206944206946_))
                             _uuids206943_)
                            (table-set! _actor-threads206689_ _thread206901_))
                          _$e206940_)
                         '#!void))))
                (_loop206700_
                 (lambda ()
                   (let _loop206762206764_ ()
                     (let ((_next206768_ (thread-mailbox-next)))
                       ((lambda (_msg206771_)
                          (let* ((_msg206773206791_ _msg206771_)
                                 (_else206779206799_
                                  (lambda () (_loop206762206764_))))
                            (let ((_K206789206896_
                                   (lambda (_msg206853_)
                                     (thread-mailbox-extract-and-rewind)
                                     (let ((_dest206855_
                                            (##direct-structure-ref
                                             _msg206853_
                                             '3
                                             std/actor/message#message::t
                                             '#f)))
                                       (if (eq? (current-thread) _dest206855_)
                                           (_handle-protocol-action206697_
                                            _msg206853_)
                                           (if (##structure-direct-instance-of?
                                                _dest206855_
                                                'std/actor/proto#remote::t)
                                               (let* ((_address206857_
                                                       (##direct-structure-ref
                                                        _dest206855_
                                                        '3
                                                        std/actor/proto#remote::t
                                                        '#f))
                                                      (_handler206859_
                                                       (_open-connection206696_
                                                        _address206857_)))
                                                 (if _handler206859_
                                                     (thread-send
                                                      _handler206859_
                                                      _msg206853_)
                                                     (std/actor/rpc/connection#rpc-send-error-response
                                                      _msg206853_
                                                      '"ivalid address")))
                                               (if (##structure-instance-of?
                                                    _dest206855_
                                                    'std/actor/proto#handle::t)
                                                   (let* ((_uuid206861_
                                                           (##structure-ref
                                                            _dest206855_
                                                            '2
                                                            std/actor/proto#handle::t
                                                            '#f))
                                                          (_$e206863_
                                                           (std/misc/sync#sync-hash-get
                                                            _actors206688_
                                                            _uuid206861_)))
                                                     (if _$e206863_
                                                         ((lambda (_e206865206867_)
                                                            (let* ((_g206869206876_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _e206865206867_)
                           (_E206871206880_
                            (lambda ()
                              (error '"No clause matching" _g206869206876_)))
                           (_K206872206885_
                            (lambda (_actor206883_)
                              (std/actor/message#send__0
                               _actor206883_
                               _msg206853_))))
                      (if (##fx= (if (##values? _g206869206876_)
                                     (##vector-length _g206869206876_)
                                     '1)
                                 '2)
                          (let* ((_e206873206888_
                                  (##vector-ref _g206869206876_ '0))
                                 (_actor206891_ _e206873206888_)
                                 (_e206874206893_
                                  (##vector-ref _g206869206876_ '1)))
                            (_K206872206885_ _actor206891_))
                          (_E206871206880_))))
                  _$e206863_)
                 (std/actor/rpc/connection#rpc-send-error-response
                  _msg206853_
                  '"unknown actor")))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (begin
                                                     (std/logger#warning
                                                      '"bad destination ~a"
                                                      _dest206855_)
                                                     (std/actor/rpc/connection#rpc-send-error-response
                                                      _msg206853_
                                                      '"bad destination"))))))))
                                  (_K206788206845_
                                   (lambda (_thread206843_)
                                     (thread-mailbox-extract-and-rewind)
                                     (if (memq _thread206843_
                                               _acceptors206693_)
                                         (std/logger#warning
                                          '"acceptor thread has exited abnormally ~a"
                                          _thread206843_)
                                         (_remove-thread!206699_
                                          _thread206843_))))
                                  (_K206787206836_
                                   (lambda ()
                                     (thread-mailbox-extract-and-rewind)
                                     (_dump!206701_ (current-error-port))))
                                  (_K206782206816_
                                   (lambda (_port206814_)
                                     (thread-mailbox-extract-and-rewind)
                                     (_dump!206701_ _port206814_)))
                                  (_K206781206805_
                                   (lambda (_value206803_)
                                     (thread-mailbox-extract-and-rewind)
                                     (std/logger#warning
                                      '"unexepected message ~a"
                                      _value206803_))))
                              (let* ((_try-match206777206831_
                                      (lambda ()
                                        (if (##pair? _msg206773206791_)
                                            (let ((_tl206784206821_
                                                   (##cdr _msg206773206791_))
                                                  (_hd206783206819_
                                                   (##car _msg206773206791_)))
                                              (if (##eq? _hd206783206819_
                                                         'dump)
                                                  (if (##pair? _tl206784206821_)
                                                      (let ((_tl206786206826_
                                                             (##cdr _tl206784206821_))
                                                            (_hd206785206824_
                                                             (##car _tl206784206821_)))
                                                        (if (##null? _tl206786206826_)
                                                            (let ((_port206829_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           _hd206785206824_))
                      (_K206782206816_ _port206829_))
                    (let ((_value206808_ _msg206773206791_))
                      (_K206781206805_ _value206808_))))
              (let ((_value206808_ _msg206773206791_))
                (_K206781206805_ _value206808_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  (let ((_value206808_
                                                         _msg206773206791_))
                                                    (_K206781206805_
                                                     _value206808_))))
                                            (let ((_value206808_
                                                   _msg206773206791_))
                                              (_K206781206805_
                                               _value206808_)))))
                                     (_try-match206776206839_
                                      (lambda ()
                                        (if (##eq? _msg206773206791_ 'dump)
                                            (_K206787206836_)
                                            (_try-match206777206831_))))
                                     (_try-match206775206850_
                                      (lambda ()
                                        (if (thread? _msg206773206791_)
                                            (let ((_thread206848_
                                                   _msg206773206791_))
                                              (_K206788206845_ _thread206848_))
                                            (_try-match206776206839_)))))
                                (if (##structure-direct-instance-of?
                                     _msg206773206791_
                                     'std/actor/message#message::t)
                                    (let ((_msg206899_ _msg206773206791_))
                                      (_K206789206896_ _msg206899_))
                                    (_try-match206775206850_))))))
                        _next206768_)))
                   (_loop206700_)))
                (_dump!206701_
                 (lambda (_port206716_)
                   (call-with-parameters
                    (lambda ()
                      (displayln '"=== rpc-server ===")
                      (std/misc/sync#sync-hash-do
                       _actors206688_
                       (lambda (_ht206719_)
                         (displayln '"actors: " (table-length _ht206719_))
                         (table-for-each
                          (lambda (_uuid206721_ _actor-state206722_)
                            (let* ((_actor-state206723206730_
                                    _actor-state206722_)
                                   (_E206725206734_
                                    (lambda ()
                                      (error '"No clause matching"
                                             _actor-state206723206730_)))
                                   (_K206726206740_
                                    (lambda (_proto206737_ _actor206738_)
                                      (displayln
                                       (std/misc/uuid#uuid->string
                                        _uuid206721_)
                                       '" -> "
                                       (cons _actor206738_
                                             (cons _proto206737_ '()))))))
                              (if (##fx= (if (##values?
                                              _actor-state206723206730_)
                                             (##vector-length
                                              _actor-state206723206730_)
                                             '1)
                                         '2)
                                  (let* ((_e206727206743_
                                          (##vector-ref
                                           _actor-state206723206730_
                                           '0))
                                         (_actor206746_ _e206727206743_)
                                         (_e206728206748_
                                          (##vector-ref
                                           _actor-state206723206730_
                                           '1))
                                         (_proto206751_ _e206728206748_))
                                    (_K206726206740_
                                     _proto206751_
                                     _actor206746_))
                                  (_E206725206734_))))
                          _ht206719_)))
                      (displayln
                       '"actor-threads: "
                       (table-length _actor-threads206689_))
                      (table-for-each
                       (lambda (_thread206753_ _uuids206754_)
                         (displayln
                          _thread206753_
                          '" -> "
                          (map std/misc/uuid#uuid->string _uuids206754_)))
                       _actor-threads206689_)
                      (displayln '"connections: " (table-length _conns206690_))
                      (table-for-each
                       (lambda (_address206756_ _conn206757_)
                         (displayln _address206756_ '" -> " _conn206757_))
                       _conns206690_)
                      (displayln '"monitors: " (table-length _monitors206692_))
                      (table-for-each
                       (lambda (_conn206759_ _mons206760_)
                         (displayln _conn206759_ '" -> " _mons206760_))
                       _monitors206692_))
                    current-output-port
                    _port206716_))))
        (for-each std/actor/rpc/base#rpc-monitor _acceptors206693_)
        (with-exception-catcher
         (lambda (_g206702206704_)
           (if '#t
               (let ((_e206707_ _g206702206704_))
                 (for-each
                  (lambda (_g206708206710_)
                    (std/actor/message#send-message__0
                     _g206708206710_
                     (##structure
                      std/actor/proto#!event::t
                      (##structure std/actor/rpc/base#rpc.shutdown::t))))
                  (hash-keys _actor-threads206689_))
                 (for-each std/net/socket/api#ssocket-close _socks206682_)
                 (for-each
                  (lambda (_thread206713_)
                    (thread-send _thread206713_ 'shutdown)
                    (std/actor/message#send-message__0
                     _thread206713_
                     (##structure
                      std/actor/proto#!event::t
                      (##structure
                       std/actor/rpc/base#rpc.connection-close::t))))
                  (hash-keys _threads206691_))
                 (for-each thread-join! (hash-keys _threads206691_))
                 (std/actor/rpc/connection#rpc-send-error-responses
                  '"server shutdown")
                 (raise _e206707_))
               (raise _g206702206704_)))
         (lambda () (_loop206700_))))))
  (define std/actor/rpc/server#rpc-server-accept
    (lambda (_rpc-server206655_ _sock206656_ _safamily206657_)
      (letrec ((_loop206659_
                (lambda ()
                  (let* ((_cliaddr206675_
                          (std/os/socket#make-socket-address _safamily206657_))
                         (_clisock206677_
                          (std/net/socket/api#ssocket-accept__1
                           _sock206656_
                           _cliaddr206675_)))
                    (std/logger#debug
                     '"accepted connection from ~a"
                     (let ((_clistr206680_
                            (std/os/socket#socket-address->string
                             _cliaddr206675_)))
                       (if (string-empty? _clistr206680_)
                           '"?"
                           _clistr206680_)))
                    (std/actor/message#send-message__0
                     _rpc-server206655_
                     (##structure
                      std/actor/proto#!event::t
                      (##structure
                       std/actor/rpc/base#rpc.connection-accept::t
                       _clisock206677_
                       _cliaddr206675_)))
                    (_loop206659_)))))
        (let _again206661_ ()
          (with-exception-catcher
           (lambda (_g206663206665_)
             (if ((lambda (_$obj206668_) (os-exception? _$obj206668_))
                  _g206663206665_)
                 (let ((_e206671_ _g206663206665_))
                   (std/logger#log-error
                    '"error accepting connection"
                    _e206671_)
                   (_again206661_))
                 (raise _g206663206665_)))
           (lambda () (_loop206659_))))))))
