export class SecurityModel extends SDK.SDKModel{constructor(target){super(target);this._dispatcher=new SecurityDispatcher(this);this._securityAgent=target.securityAgent();target.registerSecurityDispatcher(this._dispatcher);this._securityAgent.enable();}
resourceTreeModel(){return(this.target().model(SDK.ResourceTreeModel));}
networkManager(){return(this.target().model(SDK.NetworkManager));}
static SecurityStateComparator(a,b){let securityStateMap;if(SecurityModel._symbolicToNumericSecurityState){securityStateMap=SecurityModel._symbolicToNumericSecurityState;}else{securityStateMap=new Map();const ordering=[Protocol.Security.SecurityState.Info,Protocol.Security.SecurityState.InsecureBroken,Protocol.Security.SecurityState.Insecure,Protocol.Security.SecurityState.Neutral,Protocol.Security.SecurityState.Secure,Protocol.Security.SecurityState.Unknown];for(let i=0;i<ordering.length;i++){securityStateMap.set(ordering[i],i+1);}
SecurityModel._symbolicToNumericSecurityState=securityStateMap;}
const aScore=securityStateMap.get(a)||0;const bScore=securityStateMap.get(b)||0;return aScore-bScore;}}
SDK.SDKModel.register(SecurityModel,SDK.Target.Capability.Security,false);export const Events={SecurityStateChanged:Symbol('SecurityStateChanged'),VisibleSecurityStateChanged:Symbol('VisibleSecurityStateChanged')};export const SummaryMessages={[Protocol.Security.SecurityState.Unknown]:ls`The security of this page is unknown.`,[Protocol.Security.SecurityState.Insecure]:ls`This page is not secure.`,[Protocol.Security.SecurityState.Neutral]:ls`This page is not secure.`,[Protocol.Security.SecurityState.Secure]:ls`This page is secure (valid HTTPS).`,[Protocol.Security.SecurityState.InsecureBroken]:ls`This page is not secure (broken HTTPS).`};export class PageSecurityState{constructor(securityState,explanations,summary){this.securityState=securityState;this.explanations=explanations;this.summary=summary;}}
export class PageVisibleSecurityState{constructor(securityState,certificateSecurityState,safetyTipInfo,securityStateIssueIds){this.securityState=securityState;this.certificateSecurityState=certificateSecurityState?new CertificateSecurityState(certificateSecurityState):null;this.safetyTipInfo=safetyTipInfo?new SafetyTipInfo(safetyTipInfo):null;this.securityStateIssueIds=securityStateIssueIds;}}
export class CertificateSecurityState{constructor(certificateSecurityState){this.protocol=certificateSecurityState.protocol;this.keyExchange=certificateSecurityState.keyExchange;this.keyExchangeGroup=certificateSecurityState.keyExchangeGroup||null;this.cipher=certificateSecurityState.cipher;this.mac=certificateSecurityState.mac||null;this.certificate=certificateSecurityState.certificate;this.subjectName=certificateSecurityState.subjectName;this.issuer=certificateSecurityState.issuer;this.validFrom=certificateSecurityState.validFrom;this.validTo=certificateSecurityState.validTo;this.certificateNetworkError=certificateSecurityState.certificateNetworkError||null;this.certificateHasWeakSignature=certificateSecurityState.certificateHasWeakSignature;this.certificateHasSha1Signature=certificateSecurityState.certificateHasSha1Signature;this.modernSSL=certificateSecurityState.modernSSL;this.obsoleteSslProtocol=certificateSecurityState.obsoleteSslProtocol;this.obsoleteSslKeyExchange=certificateSecurityState.obsoleteSslKeyExchange;this.obsoleteSslCipher=certificateSecurityState.obsoleteSslCipher;this.obsoleteSslSignature=certificateSecurityState.obsoleteSslSignature;}
isCertificateExpiringSoon(){const expiryDate=new Date(this.validTo*1000);return(expiryDate<new Date(Date.now()).setHours(48))&&(expiryDate>Date.now());}
getKeyExchangeName(){if(this.keyExchangeGroup){return this.keyExchange?ls`${this.keyExchange} with ${this.keyExchangeGroup}`:this.keyExchangeGroup;}
return this.keyExchange;}
getCipherFullName(){return this.mac?ls`${this.cipher} with ${this.mac}`:this.cipher;}}
class SafetyTipInfo{constructor(safetyTipInfo){this.safetyTipStatus=safetyTipInfo.safetyTipStatus;this.safeUrl=safetyTipInfo.safeUrl||null;}}
export class SecurityStyleExplanation{constructor(securityState,title,summary,description,certificate=[],mixedContentType=Protocol.Security.MixedContentType.None,recommendations=[]){this.securityState=securityState;this.title=title;this.summary=summary;this.description=description;this.certificate=certificate;this.mixedContentType=mixedContentType;this.recommendations=recommendations;}}
class SecurityDispatcher{constructor(model){this._model=model;}
securityStateChanged(securityState,schemeIsCryptographic,explanations,insecureContentStatus,summary){const pageSecurityState=new PageSecurityState(securityState,explanations,summary||null);this._model.dispatchEventToListeners(Events.SecurityStateChanged,pageSecurityState);}
visibleSecurityStateChanged(visibleSecurityState){const pageVisibleSecurityState=new PageVisibleSecurityState(visibleSecurityState.securityState,visibleSecurityState.certificateSecurityState||null,visibleSecurityState.safetyTipInfo||null,visibleSecurityState.securityStateIssueIds);this._model.dispatchEventToListeners(Events.VisibleSecurityStateChanged,pageVisibleSecurityState);}
certificateError(eventId,errorType,requestURL){}}