"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var fast_deep_equal_1 = require("../../../../utils/fast_deep_equal");
var bar_values_utils_1 = require("./bar_values_utils");
var react_redux_1 = require("react-redux");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var compute_chart_dimensions_1 = require("../../state/selectors/compute_chart_dimensions");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var compute_series_geometries_1 = require("../../state/selectors/compute_series_geometries");
var light_theme_1 = require("../../../../utils/themes/light_theme");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var BarValuesComponent = /** @class */ (function (_super) {
    __extends(BarValuesComponent, _super);
    function BarValuesComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderBarValues = function () {
            var _a = _this.props, bars = _a.bars, debug = _a.debug, chartRotation = _a.chartRotation, chartDimensions = _a.chartDimensions, theme = _a.theme;
            var displayValueStyle = theme.barSeriesStyle.displayValue;
            return bars.map(function (bar, index) {
                var displayValue = bar.displayValue, x = bar.x, y = bar.y, height = bar.height, width = bar.width;
                if (!displayValue) {
                    return;
                }
                var key = "bar-value-" + index;
                var displayValueProps = bar_values_utils_1.buildBarValueProps({
                    x: x,
                    y: y,
                    barHeight: height,
                    barWidth: width,
                    displayValueStyle: displayValueStyle,
                    displayValue: displayValue,
                    chartRotation: chartRotation,
                    chartDimensions: chartDimensions,
                });
                var debugProps = __assign(__assign({}, displayValueProps), { stroke: 'violet', strokeWidth: 1, fill: 'transparent' });
                return (react_1.default.createElement(react_konva_1.Group, { key: key },
                    debug && react_1.default.createElement(react_konva_1.Rect, __assign({}, debugProps)),
                    displayValue && react_1.default.createElement(react_konva_1.Text, __assign({}, displayValueProps))));
            });
        };
        return _this;
    }
    BarValuesComponent.prototype.shouldComponentUpdate = function (nextProps) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps);
    };
    BarValuesComponent.prototype.render = function () {
        var _a = this.props, chartDimensions = _a.chartDimensions, bars = _a.bars;
        if (!bars) {
            return;
        }
        return (react_1.default.createElement(react_konva_1.Group, { x: chartDimensions.left, y: chartDimensions.top }, this.renderBarValues()));
    };
    return BarValuesComponent;
}(react_1.default.Component));
exports.BarValuesComponent = BarValuesComponent;
var mapStateToProps = function (state) {
    if (!state.specsInitialized) {
        return {
            theme: light_theme_1.LIGHT_THEME,
            chartDimensions: {
                width: 0,
                left: 0,
                top: 0,
                height: 0,
            },
            chartRotation: 0,
            debug: false,
            bars: [],
        };
    }
    var geometries = compute_series_geometries_1.computeSeriesGeometriesSelector(state);
    return {
        theme: get_chart_theme_1.getChartThemeSelector(state),
        chartDimensions: compute_chart_dimensions_1.computeChartDimensionsSelector(state).chartDimensions,
        chartRotation: get_chart_rotation_1.getChartRotationSelector(state),
        debug: get_settings_specs_1.getSettingsSpecSelector(state).debug,
        bars: geometries.geometries.bars,
    };
};
exports.BarValues = react_redux_1.connect(mapStateToProps)(BarValuesComponent);
//# sourceMappingURL=bar_values.js.map