/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.response.ClusteringResponse;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.Group;
import org.apache.solr.client.solrj.response.GroupCommand;
import org.apache.solr.client.solrj.response.GroupResponse;
import org.apache.solr.client.solrj.response.IntervalFacet;
import org.apache.solr.client.solrj.response.PivotField;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.client.solrj.response.SuggesterResponse;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.client.solrj.response.json.NestableJsonFacet;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class QueryResponse
extends SolrResponseBase {
    private NamedList<Object> _header = null;
    private SolrDocumentList _results = null;
    private NamedList<ArrayList> _sortvalues = null;
    private NamedList<Object> _facetInfo = null;
    private NamedList<Object> _debugInfo = null;
    private NamedList<Object> _highlightingInfo = null;
    private NamedList<Object> _spellInfo = null;
    private List<NamedList<Object>> _clusterInfo = null;
    private NamedList<Object> _jsonFacetingInfo = null;
    private Map<String, NamedList<Object>> _suggestInfo = null;
    private NamedList<Object> _statsInfo = null;
    private NamedList<NamedList<Object>> _termsInfo = null;
    private NamedList<SolrDocumentList> _moreLikeThisInfo = null;
    private String _cursorMarkNext = null;
    private NamedList<Object> _groupedInfo = null;
    private GroupResponse _groupResponse = null;
    private NamedList<Object> _expandedInfo = null;
    private Map<String, SolrDocumentList> _expandedResults = null;
    private Map<String, Integer> _facetQuery = null;
    private List<FacetField> _facetFields = null;
    private List<FacetField> _limitingFacets = null;
    private List<FacetField> _facetDates = null;
    private List<RangeFacet> _facetRanges = null;
    private NamedList<List<PivotField>> _facetPivot = null;
    private List<IntervalFacet> _intervalFacets = null;
    private Map<String, Map<String, List<String>>> _highlighting = null;
    private SpellCheckResponse _spellResponse = null;
    private ClusteringResponse _clusterResponse = null;
    private NestableJsonFacet _jsonFacetingResponse = null;
    private SuggesterResponse _suggestResponse = null;
    private TermsResponse _termsResponse = null;
    private Map<String, FieldStatsInfo> _fieldStatsInfo = null;
    private Map<String, Object> _debugMap = null;
    private Map<String, Object> _explainMap = null;
    private final transient SolrClient solrClient;

    public QueryResponse() {
        this.solrClient = null;
    }

    public QueryResponse(NamedList<Object> res, SolrClient solrClient) {
        this.setResponse(res);
        this.solrClient = solrClient;
    }

    public QueryResponse(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    @Override
    public void setResponse(NamedList<Object> res) {
        super.setResponse(res);
        for (int i = 0; i < res.size(); ++i) {
            String n = res.getName(i);
            if ("responseHeader".equals(n)) {
                this._header = (NamedList)res.getVal(i);
                continue;
            }
            if ("response".equals(n)) {
                this._results = (SolrDocumentList)res.getVal(i);
                continue;
            }
            if ("sort_values".equals(n)) {
                this._sortvalues = (NamedList)res.getVal(i);
                continue;
            }
            if ("facet_counts".equals(n)) {
                this._facetInfo = (NamedList)res.getVal(i);
                continue;
            }
            if ("debug".equals(n)) {
                this._debugInfo = (NamedList)res.getVal(i);
                this.extractDebugInfo(this._debugInfo);
                continue;
            }
            if ("grouped".equals(n)) {
                this._groupedInfo = (NamedList)res.getVal(i);
                this.extractGroupedInfo(this._groupedInfo);
                continue;
            }
            if ("expanded".equals(n)) {
                NamedList map = (NamedList)res.getVal(i);
                this._expandedResults = map.asMap(1);
                continue;
            }
            if ("highlighting".equals(n)) {
                this._highlightingInfo = (NamedList)res.getVal(i);
                this.extractHighlightingInfo(this._highlightingInfo);
                continue;
            }
            if ("spellcheck".equals(n)) {
                this._spellInfo = (NamedList)res.getVal(i);
                this.extractSpellCheckInfo(this._spellInfo);
                continue;
            }
            if ("clusters".equals(n)) {
                this._clusterInfo = (ArrayList)res.getVal(i);
                this.extractClusteringInfo(this._clusterInfo);
                continue;
            }
            if ("facets".equals(n)) {
                this._jsonFacetingInfo = (NamedList)res.getVal(i);
                continue;
            }
            if ("suggest".equals(n)) {
                this._suggestInfo = (Map)res.getVal(i);
                this.extractSuggesterInfo(this._suggestInfo);
                continue;
            }
            if ("stats".equals(n)) {
                this._statsInfo = (NamedList)res.getVal(i);
                this.extractStatsInfo(this._statsInfo);
                continue;
            }
            if ("terms".equals(n)) {
                this._termsInfo = (NamedList)res.getVal(i);
                this.extractTermsInfo(this._termsInfo);
                continue;
            }
            if ("moreLikeThis".equals(n)) {
                this._moreLikeThisInfo = (NamedList)res.getVal(i);
                continue;
            }
            if (!"nextCursorMark".equals(n)) continue;
            this._cursorMarkNext = (String)res.getVal(i);
        }
        if (this._facetInfo != null) {
            this.extractFacetInfo(this._facetInfo);
        }
    }

    private void extractSpellCheckInfo(NamedList<Object> spellInfo) {
        this._spellResponse = new SpellCheckResponse(spellInfo);
    }

    private void extractClusteringInfo(List<NamedList<Object>> clusterInfo) {
        this._clusterResponse = new ClusteringResponse(clusterInfo);
    }

    private void extractJsonFacetingInfo(NamedList<Object> facetInfo) {
        this._jsonFacetingResponse = new NestableJsonFacet(facetInfo);
    }

    private void extractSuggesterInfo(Map<String, NamedList<Object>> suggestInfo) {
        this._suggestResponse = new SuggesterResponse(suggestInfo);
    }

    private void extractTermsInfo(NamedList<NamedList<Object>> termsInfo) {
        this._termsResponse = new TermsResponse(termsInfo);
    }

    private void extractStatsInfo(NamedList<Object> info) {
        this._fieldStatsInfo = this.extractFieldStatsInfo(info);
    }

    private Map<String, FieldStatsInfo> extractFieldStatsInfo(NamedList<Object> info) {
        if (info != null) {
            TreeMap<String, FieldStatsInfo> fieldStatsInfoMap = new TreeMap<String, FieldStatsInfo>();
            NamedList ff = (NamedList)info.get("stats_fields");
            if (ff != null) {
                for (Map.Entry entry : ff) {
                    NamedList v = (NamedList)entry.getValue();
                    if (v == null) continue;
                    fieldStatsInfoMap.put(entry.getKey(), new FieldStatsInfo(v, entry.getKey()));
                }
            }
            return fieldStatsInfoMap;
        }
        return null;
    }

    private void extractDebugInfo(NamedList<Object> debug) {
        this._debugMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : debug) {
            this._debugMap.put(entry.getKey(), entry.getValue());
        }
        this._explainMap = new HashMap<String, Object>();
        NamedList explain = (NamedList)this._debugMap.get("explain");
        if (explain != null) {
            for (Map.Entry info : explain) {
                String key = info.getKey();
                this._explainMap.put(key, info.getValue());
            }
        }
    }

    private void extractGroupedInfo(NamedList<Object> info) {
        if (info != null) {
            this._groupResponse = new GroupResponse();
            int size = info.size();
            for (int i = 0; i < size; ++i) {
                GroupCommand groupCommand;
                Integer iMatches;
                String fieldName = info.getName(i);
                Object fieldGroups = info.getVal(i);
                SimpleOrderedMap simpleOrderedMap = (SimpleOrderedMap)fieldGroups;
                Object oMatches = simpleOrderedMap.get("matches");
                Object oNGroups = simpleOrderedMap.get("ngroups");
                Object oGroups = simpleOrderedMap.get("groups");
                Object queryCommand = simpleOrderedMap.get("doclist");
                if (oMatches == null) continue;
                if (oGroups != null) {
                    GroupCommand groupedCommand;
                    iMatches = (Integer)oMatches;
                    ArrayList groupsArr = (ArrayList)oGroups;
                    if (oNGroups != null) {
                        Integer iNGroups = (Integer)oNGroups;
                        groupedCommand = new GroupCommand(fieldName, iMatches, iNGroups);
                    } else {
                        groupedCommand = new GroupCommand(fieldName, iMatches);
                    }
                    for (Object oGrp : groupsArr) {
                        SimpleOrderedMap grpMap = (SimpleOrderedMap)oGrp;
                        Object sGroupValue = grpMap.get("groupValue");
                        SolrDocumentList doclist = (SolrDocumentList)grpMap.get("doclist");
                        Group group = new Group(sGroupValue != null ? sGroupValue.toString() : null, doclist);
                        groupedCommand.add(group);
                    }
                    this._groupResponse.add(groupedCommand);
                    continue;
                }
                if (queryCommand == null) continue;
                iMatches = (Integer)oMatches;
                if (oNGroups != null) {
                    Integer iNGroups = (Integer)oNGroups;
                    groupCommand = new GroupCommand(fieldName, iMatches, iNGroups);
                } else {
                    groupCommand = new GroupCommand(fieldName, iMatches);
                }
                SolrDocumentList docList = (SolrDocumentList)queryCommand;
                groupCommand.add(new Group(fieldName, docList));
                this._groupResponse.add(groupCommand);
            }
        }
    }

    private void extractHighlightingInfo(NamedList<Object> info) {
        this._highlighting = new HashMap<String, Map<String, List<String>>>();
        for (Map.Entry<String, Object> entry : info) {
            HashMap fieldMap = new HashMap();
            this._highlighting.put(entry.getKey(), fieldMap);
            NamedList fnl = (NamedList)entry.getValue();
            for (Map.Entry field : fnl) {
                fieldMap.put(field.getKey(), field.getValue());
            }
        }
    }

    private void extractFacetInfo(NamedList<Object> info) {
        NamedList intervalsNL;
        NamedList pf;
        NamedList rf;
        NamedList ff;
        this._facetQuery = new LinkedHashMap<String, Integer>();
        NamedList fq = (NamedList)info.get("facet_queries");
        if (fq != null) {
            for (Map.Entry entry : fq) {
                this._facetQuery.put(entry.getKey(), (Integer)entry.getValue());
            }
        }
        if ((ff = (NamedList)info.get("facet_fields")) != null) {
            this._facetFields = new ArrayList<FacetField>(ff.size());
            this._limitingFacets = new ArrayList<FacetField>(ff.size());
            long minsize = this._results == null ? Long.MAX_VALUE : this._results.getNumFound();
            for (Map.Entry facet : ff) {
                FacetField f = new FacetField(facet.getKey());
                for (Map.Entry entry : (NamedList)facet.getValue()) {
                    f.add(entry.getKey(), ((Number)entry.getValue()).longValue());
                }
                this._facetFields.add(f);
                FacetField nl = f.getLimitingFields(minsize);
                if (nl.getValueCount() <= 0) continue;
                this._limitingFacets.add(nl);
            }
        }
        if ((rf = (NamedList)info.get("facet_ranges")) != null) {
            this._facetRanges = this.extractRangeFacets(rf);
        }
        if ((pf = (NamedList)info.get("facet_pivot")) != null) {
            this._facetPivot = new NamedList();
            for (int i = 0; i < pf.size(); ++i) {
                this._facetPivot.add(pf.getName(i), this.readPivots((List)pf.getVal(i)));
            }
        }
        if ((intervalsNL = (NamedList)info.get("facet_intervals")) != null) {
            this._intervalFacets = new ArrayList<IntervalFacet>(intervalsNL.size());
            for (Map.Entry intervalField : intervalsNL) {
                String field = intervalField.getKey();
                ArrayList<IntervalFacet.Count> counts = new ArrayList<IntervalFacet.Count>(((NamedList)intervalField.getValue()).size());
                for (Map.Entry interval : (NamedList)intervalField.getValue()) {
                    counts.add(new IntervalFacet.Count(interval.getKey(), (Integer)interval.getValue()));
                }
                this._intervalFacets.add(new IntervalFacet(field, counts));
            }
        }
    }

    private List<RangeFacet> extractRangeFacets(NamedList<NamedList<Object>> rf) {
        ArrayList<RangeFacet> facetRanges = new ArrayList<RangeFacet>(rf.size());
        for (Map.Entry<String, NamedList<Object>> entry : rf) {
            RangeFacet rangeFacet;
            Number between;
            Number after;
            Number before;
            Object end;
            Object start;
            Object gap;
            NamedList<Object> values = entry.getValue();
            Object rawGap = values.get("gap");
            if (rawGap instanceof Number) {
                gap = (Number)rawGap;
                start = (Number)values.get("start");
                end = (Number)values.get("end");
                before = (Number)values.get("before");
                after = (Number)values.get("after");
                between = (Number)values.get("between");
                rangeFacet = new RangeFacet.Numeric(entry.getKey(), (Number)start, (Number)end, (Number)gap, before, after, between);
            } else if (rawGap instanceof String && values.get("start") instanceof Date) {
                gap = (String)rawGap;
                start = (Date)values.get("start");
                end = (Date)values.get("end");
                before = (Number)values.get("before");
                after = (Number)values.get("after");
                between = (Number)values.get("between");
                rangeFacet = new RangeFacet.Date(entry.getKey(), (Date)start, (Date)end, (String)gap, before, after, between);
            } else {
                gap = (String)rawGap;
                start = (String)values.get("start");
                end = (String)values.get("end");
                before = (Number)values.get("before");
                after = (Number)values.get("after");
                between = (Number)values.get("between");
                rangeFacet = new RangeFacet.Currency(entry.getKey(), (String)start, (String)end, (String)gap, before, after, between);
            }
            NamedList counts = (NamedList)values.get("counts");
            for (Map.Entry entry2 : counts) {
                rangeFacet.addCount(entry2.getKey(), (Integer)entry2.getValue());
            }
            facetRanges.add(rangeFacet);
        }
        return facetRanges;
    }

    protected List<PivotField> readPivots(List<NamedList> list) {
        ArrayList<PivotField> values = new ArrayList<PivotField>(list.size());
        for (NamedList nl : list) {
            assert ("field".equals(nl.getName(0)));
            String f = (String)nl.getVal(0);
            assert ("value".equals(nl.getName(1)));
            Object v = nl.getVal(1);
            assert ("count".equals(nl.getName(2)));
            int cnt = (Integer)nl.getVal(2);
            List<PivotField> subPivots = null;
            Map<String, FieldStatsInfo> fieldStatsInfos = null;
            LinkedHashMap queryCounts = null;
            List<RangeFacet> ranges = null;
            if (4 <= nl.size()) {
                block13: for (int index = 3; index < nl.size(); ++index) {
                    String key = nl.getName(index);
                    Object val = nl.getVal(index);
                    switch (key) {
                        case "pivot": {
                            assert (null != val) : "Server sent back 'null' for sub pivots?";
                            assert (val instanceof List) : "Server sent non-List for sub pivots?";
                            subPivots = this.readPivots((List)val);
                            continue block13;
                        }
                        case "stats": {
                            assert (null != val) : "Server sent back 'null' for stats?";
                            assert (val instanceof NamedList) : "Server sent non-NamedList for stats?";
                            fieldStatsInfos = this.extractFieldStatsInfo((NamedList)val);
                            continue block13;
                        }
                        case "queries": {
                            queryCounts = new LinkedHashMap();
                            NamedList fq = (NamedList)val;
                            if (fq == null) continue block13;
                            for (Map.Entry entry : fq) {
                                queryCounts.put(entry.getKey(), entry.getValue());
                            }
                            continue block13;
                        }
                        case "ranges": {
                            ranges = this.extractRangeFacets((NamedList)val);
                            continue block13;
                        }
                        default: {
                            throw new RuntimeException("unknown key in pivot: " + key + " [" + val + "]");
                        }
                    }
                }
            }
            values.add(new PivotField(f, v, cnt, subPivots, fieldStatsInfos, queryCounts, ranges));
        }
        return values;
    }

    public void removeFacets() {
        this._facetFields = new ArrayList<FacetField>();
    }

    public NamedList<Object> getHeader() {
        return this._header;
    }

    public SolrDocumentList getResults() {
        return this._results;
    }

    public NamedList<ArrayList> getSortValues() {
        return this._sortvalues;
    }

    public Map<String, Object> getDebugMap() {
        return this._debugMap;
    }

    public Map<String, Object> getExplainMap() {
        return this._explainMap;
    }

    public Map<String, Integer> getFacetQuery() {
        return this._facetQuery;
    }

    public Map<String, SolrDocumentList> getExpandedResults() {
        return this._expandedResults;
    }

    public GroupResponse getGroupResponse() {
        return this._groupResponse;
    }

    public Map<String, Map<String, List<String>>> getHighlighting() {
        return this._highlighting;
    }

    public SpellCheckResponse getSpellCheckResponse() {
        return this._spellResponse;
    }

    public ClusteringResponse getClusteringResponse() {
        return this._clusterResponse;
    }

    public NestableJsonFacet getJsonFacetingResponse() {
        if (this._jsonFacetingInfo != null && this._jsonFacetingResponse == null) {
            this.extractJsonFacetingInfo(this._jsonFacetingInfo);
        }
        return this._jsonFacetingResponse;
    }

    public SuggesterResponse getSuggesterResponse() {
        return this._suggestResponse;
    }

    public TermsResponse getTermsResponse() {
        return this._termsResponse;
    }

    public NamedList<SolrDocumentList> getMoreLikeThis() {
        return this._moreLikeThisInfo;
    }

    public List<FacetField> getFacetFields() {
        return this._facetFields;
    }

    public List<FacetField> getFacetDates() {
        return this._facetDates;
    }

    public List<RangeFacet> getFacetRanges() {
        return this._facetRanges;
    }

    public NamedList<List<PivotField>> getFacetPivot() {
        return this._facetPivot;
    }

    public List<IntervalFacet> getIntervalFacets() {
        return this._intervalFacets;
    }

    public FacetField getFacetField(String name) {
        if (this._facetFields == null) {
            return null;
        }
        for (FacetField f : this._facetFields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public FacetField getFacetDate(String name) {
        if (this._facetDates == null) {
            return null;
        }
        for (FacetField f : this._facetDates) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public List<FacetField> getLimitingFacets() {
        return this._limitingFacets;
    }

    public <T> List<T> getBeans(Class<T> type) {
        return this.solrClient == null ? new DocumentObjectBinder().getBeans(type, this._results) : this.solrClient.getBinder().getBeans(type, this._results);
    }

    public Map<String, FieldStatsInfo> getFieldStatsInfo() {
        return this._fieldStatsInfo;
    }

    public String getNextCursorMark() {
        return this._cursorMarkNext;
    }
}

