/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.Position;

public class KnuthPenalty
extends KnuthElement {
    public static final int FLAGGED_PENALTY = 50;
    private int penalty;
    private boolean bFlagged;
    private int breakClass = -1;

    public KnuthPenalty(int w, int p, boolean f, Position pos, boolean bAux) {
        super(w, pos, bAux);
        this.penalty = p;
        this.bFlagged = f;
    }

    public KnuthPenalty(int w, int p, boolean f, int iBreakClass, Position pos, boolean bAux) {
        super(w, pos, bAux);
        this.penalty = p;
        this.bFlagged = f;
        this.breakClass = iBreakClass;
    }

    public boolean isPenalty() {
        return true;
    }

    public int getP() {
        return this.penalty;
    }

    public void setP(int p) {
        this.penalty = p;
    }

    public boolean isFlagged() {
        return this.bFlagged;
    }

    public boolean isForcedBreak() {
        return this.penalty == -1000;
    }

    public int getBreakClass() {
        return this.breakClass;
    }

    public void setBreakClass(int cl) {
        this.breakClass = cl;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        if (this.isAuxiliary()) {
            sb.append("aux. ");
        }
        sb.append("penalty");
        sb.append(" p=");
        if (this.getP() < 0) {
            sb.append("-");
        }
        if (Math.abs(this.getP()) == 1000) {
            sb.append("INFINITE");
        } else {
            sb.append(this.getP());
        }
        if (this.isFlagged()) {
            sb.append(" [flagged]");
        }
        sb.append(" w=");
        sb.append(this.getW());
        if (this.isForcedBreak()) {
            sb.append(" (forced break");
            switch (this.getBreakClass()) {
                case 104: {
                    sb.append(", page");
                    break;
                }
                case 28: {
                    sb.append(", column");
                    break;
                }
                case 44: {
                    sb.append(", even page");
                    break;
                }
                case 100: {
                    sb.append(", odd page");
                    break;
                }
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

