/*	$OpenBSD: tccreg.h,v 1.1 2012/09/29 21:46:02 miod Exp $	*/

/*
 * Copyright (c) 2012 Miodrag Vallat.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * POWER Indigo2 TBus Cache Controller (Stream Cache) support code.
 */

#define	TCC_BASE		0x0000000018000000UL

/*
 * TCC Control Registers
 */

#define	TCC_FIFO_CTRL		0x0000000

#define	TCC_GCACHE_CTRL		0x0000008
#define	TCC_GCACHE_SET_0		0x00000001 /* cache set enables */
#define	TCC_GCACHE_SET_1		0x00000002
#define	TCC_GCACHE_SET_2		0x00000004
#define	TCC_GCACHE_SET_3		0x00000008
#define	TCC_GCACHE_SET_ALL		0x0000000f
#define	TCC_GCACHE_DISABLE_WB		0x00000020 /* prevents writebacks */
#define	TCC_GCACHE_REV_MASK		0x03c00000
#define	TCC_GCACHE_REV_SHIFT		18

#define	TCC_INTR		0x0000010
#define	TCC_INTR_MASK_0			0x00000001
#define	TCC_INTR_MASK_1			0x00000002
#define	TCC_INTR_MASK_2			0x00000004
#define	TCC_INTR_MASK_3			0x00000008
#define	TCC_INTR_MASK_4			0x00000010
#define	TCC_INTR_MASK_5			0x00000020
#define	TCC_INTR_GFX_FIFO_HIWAT		0x00000040
#define	TCC_INTR_GFX_FIFO_LOWAT		0x00000080
#define	TCC_INTR_COUNTER		0x00000100
#define	TCC_INTR_BERR			0x00000200
#define	TCC_INTR_MCHECK			0x00000400
#define	TCC_INTR_PENDING_MASK		0x000007ff
#define	TCC_INTR_GFX_FIFO_HIWAT_ENAB	0x00000800
#define	TCC_INTR_GFX_FIFO_LOWAT_ENAB	0x00001000
#define	TCC_INTR_COUNTER_ENAB		0x00002000
#define	TCC_INTR_BERR_ENAB		0x00004000
#define	TCC_INTR_MCHECK_ENAB		0x00008000
#define	TCC_INTR_ENABLE_MASK		0x0000f800

#define	TCC_BERR_ADDR		0x0000018

#define	TCC_ERROR		0x0000020
#define	TCC_ERROR_NESTED_BERR		0x00000001
#define	TCC_ERROR_NESTED_MCHECK		0x00000002
#define	TCC_ERROR_TYPE_MASK		0x0000001c
#define	TCC_ERROR_TYPE_SHIFT		2

#define	TCC_ERROR_TYPE_TDB_PAR		0
#define	TCC_ERROR_TYPE_TCC_PAR		1
#define	TCC_ERROR_TYPE_CMD_PAR		2
#define	TCC_ERROR_TYPE_SYSAD		3
#define	TCC_ERROR_TYPE_GCACHE_PAR	4
#define	TCC_ERROR_TYPE_TBUS		5

#define	TCC_PARITY_CTRL		0x0000028

#define	TCC_COUNT		0x0000030

#define	TCC_COMPARE		0x0000038

#define	TCC_PREFETCH_CTRL	0x0010038

#define	TCC_PREFETCH_INVALIDATE		0x0000000000000001 /* one-shot */
#define	TCC_PREFETCH_TIMEOUT_MASK	0x000000000000001e
#define	TCC_PREFETCH_TIMEOUT_MAX	15
#define	TCC_PREFETCH_TIMEOUT_SHIFT	1
#define	TCC_PREFETCH_BUF_A_ENABLE	0x0000000000000020
#define	TCC_PREFETCH_BUF_B_ENABLE	0x0000000000000040
#define	TCC_PREFETCH_QUEUE_DEPTH_MASK	0x0000000000000380
#define	TCC_PREFETCH_QUEUE_DEPTH_MAX	7
#define	TCC_PREFETCH_QUEUE_DEPTH_SHIFT	7

/*
 * The following default prefetch settings has been borrowed from IRIX's
 * <sys/IP26.h>. We can only assume these settings are optimal for most
 * workloads.
 */
#define	TCC_PREFETCH_ENABLE \
    (TCC_PREFETCH_BUF_A_ENABLE | TCC_PREFETCH_BUF_B_ENABLE | \
     (3 << TCC_PREFETCH_TIMEOUT_SHIFT) | \
     (TCC_PREFETCH_QUEUE_DEPTH_MAX << TCC_PREFETCH_QUEUE_DEPTH_SHIFT))

/*
 * TCC Cache Operations
 */

#define	TCC_CACHEOP_BASE	0x0000000100000000UL

#define	TCC_CACHEOP_HIT			0x00000000
#define	TCC_CACHEOP_INDEX		0x00000004
#define	TCC_CACHEOP_WRITEBACK		0x00000008
#define	TCC_CACHEOP_INVALIDATE		0x00000010
#define	TCC_CACHEOP_SET_SHIFT		5
#define	TCC_CACHEOP_INDEX_SHIFT		7
#define	TCC_CACHE_SETS			4
#define	TCC_CACHE_LINE			128UL
