/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.net.URI;
import java.util.Optional;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.RestoreCore;
import org.apache.solr.handler.admin.CoreAdminHandler;

class RestoreCoreOp
implements CoreAdminHandler.CoreAdminOp {
    RestoreCoreOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        String name = params.required().get("name");
        ZkController zkController = it.handler.coreContainer.getZkController();
        if (zkController == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only valid for SolrCloud");
        }
        String repoName = params.get("repository");
        BackupRepository repository = it.handler.coreContainer.newBackupRepository(Optional.ofNullable(repoName));
        String location = repository.getBackupLocation(params.get("location"));
        if (location == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property");
        }
        URI locationUri = repository.createURI(location);
        try (SolrCore core = it.handler.coreContainer.getCore(cname);){
            CloudDescriptor cd = core.getCoreDescriptor().getCloudDescriptor();
            Slice slice = zkController.getClusterState().getCollection(cd.getCollectionName()).getSlice(cd.getShardId());
            if (slice.getReplicas().size() != 1) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to restore core=" + core.getName() + ", the core must be the only replica in its shard");
            }
            RestoreCore restoreCore = new RestoreCore(repository, core, locationUri, name);
            boolean success = restoreCore.doRestore();
            if (!success) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to restore core=" + core.getName());
            }
            zkController.getShardTerms(cd.getCollectionName(), cd.getShardId()).ensureHighestTermsAreNotZero();
        }
    }
}

