/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.util.StringUtil;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.WordClusterDictionary;

public class WordClusterFeatureGenerator
implements AdaptiveFeatureGenerator {
    private WordClusterDictionary tokenDictionary;
    private String resourceName;
    private boolean lowerCaseDictionary;

    public WordClusterFeatureGenerator(WordClusterDictionary dict, String dictResourceKey, boolean lowerCaseDictionary) {
        this.tokenDictionary = dict;
        this.resourceName = dictResourceKey;
        this.lowerCaseDictionary = lowerCaseDictionary;
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String clusterId = this.lowerCaseDictionary ? this.tokenDictionary.lookupToken(StringUtil.toLowerCase(tokens[index])) : this.tokenDictionary.lookupToken(tokens[index]);
        if (clusterId != null) {
            features.add(this.resourceName + clusterId);
        }
    }
}

